/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.helpers;

import java.net.URI;
import org.neo4j.server.NeoServer;
import org.neo4j.server.rest.domain.GraphDbHelper;

public final class FunctionalTestHelper {
    private final NeoServer server;
    private final GraphDbHelper helper;

    public FunctionalTestHelper(NeoServer server) {
        if (server.getDatabaseService() == null) {
            throw new RuntimeException("Server must be started before using " + this.getClass().getName());
        }
        this.helper = new GraphDbHelper(server.getDatabaseService());
        this.server = server;
    }

    public GraphDbHelper getGraphDbHelper() {
        return this.helper;
    }

    private String databaseUri() {
        return this.databaseUri("neo4j");
    }

    private String databaseUri(String databaseName) {
        return String.format("%sdb/%s/", this.server.baseUri(), databaseName);
    }

    public URI baseUri() {
        return this.server.baseUri();
    }

    public String txCommitUri() {
        return this.databaseUri() + "tx/commit";
    }

    public String txCommitUri(String databaseName) {
        return this.databaseUri(databaseName) + "tx/commit";
    }
}

