/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web;

import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.http.HttpHeader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.server.web.HttpHeaderUtils;

public class HttpHeaderUtilsTest {
    public final AssertableLogProvider logProvider = new AssertableLogProvider(true);
    private final HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);

    @Test
    void retrieveCustomTransactionTimeout() {
        Mockito.when((Object)this.request.getHeader("max-execution-time")).thenReturn((Object)"100");
        Log log = this.logProvider.getLog(HttpServletRequest.class);
        long transactionTimeout = HttpHeaderUtils.getTransactionTimeout((HttpServletRequest)this.request, (Log)log);
        Assertions.assertEquals((long)100L, (long)transactionTimeout, (String)"Transaction timeout should be retrieved.");
        this.logProvider.assertNoLoggingOccurred();
    }

    @Test
    void defaultValueWhenCustomTransactionTimeoutNotSpecified() {
        Log log = this.logProvider.getLog(HttpServletRequest.class);
        long transactionTimeout = HttpHeaderUtils.getTransactionTimeout((HttpServletRequest)this.request, (Log)log);
        Assertions.assertEquals((long)0L, (long)transactionTimeout, (String)"Transaction timeout not specified.");
        this.logProvider.assertNoLoggingOccurred();
    }

    @Test
    void defaultValueWhenCustomTransactionTimeoutNotANumber() {
        Mockito.when((Object)this.request.getHeader("max-execution-time")).thenReturn((Object)"aa");
        Log log = this.logProvider.getLog(HttpServletRequest.class);
        long transactionTimeout = HttpHeaderUtils.getTransactionTimeout((HttpServletRequest)this.request, (Log)log);
        Assertions.assertEquals((long)0L, (long)transactionTimeout, (String)"Transaction timeout not specified.");
        this.logProvider.rawMessageMatcher().assertContains("Fail to parse `max-execution-time` header with value: 'aa'. Should be a positive number.");
    }

    @Test
    void shouldCheckHttpHeaders() {
        Assertions.assertFalse((boolean)HttpHeaderUtils.isValidHttpHeaderName(null));
        Assertions.assertFalse((boolean)HttpHeaderUtils.isValidHttpHeaderName((String)""));
        Assertions.assertFalse((boolean)HttpHeaderUtils.isValidHttpHeaderName((String)" "));
        Assertions.assertFalse((boolean)HttpHeaderUtils.isValidHttpHeaderName((String)"      "));
        Assertions.assertFalse((boolean)HttpHeaderUtils.isValidHttpHeaderName((String)" \r "));
        Assertions.assertFalse((boolean)HttpHeaderUtils.isValidHttpHeaderName((String)" \r\n\t "));
        Assertions.assertTrue((boolean)HttpHeaderUtils.isValidHttpHeaderName((String)HttpHeader.ACCEPT.toString()));
        Assertions.assertTrue((boolean)HttpHeaderUtils.isValidHttpHeaderName((String)HttpHeader.ACCEPT_ENCODING.toString()));
        Assertions.assertTrue((boolean)HttpHeaderUtils.isValidHttpHeaderName((String)HttpHeader.AGE.toString()));
        Assertions.assertTrue((boolean)HttpHeaderUtils.isValidHttpHeaderName((String)HttpHeader.CONTENT_ENCODING.toString()));
        Assertions.assertTrue((boolean)HttpHeaderUtils.isValidHttpHeaderName((String)HttpHeader.EXPIRES.toString()));
        Assertions.assertTrue((boolean)HttpHeaderUtils.isValidHttpHeaderName((String)HttpHeader.IF_MATCH.toString()));
        Assertions.assertTrue((boolean)HttpHeaderUtils.isValidHttpHeaderName((String)HttpHeader.TRANSFER_ENCODING.toString()));
        Assertions.assertTrue((boolean)HttpHeaderUtils.isValidHttpHeaderName((String)"Weird Header With Spaces"));
        Assertions.assertFalse((boolean)HttpHeaderUtils.isValidHttpHeaderName((String)"My\nHeader"));
        Assertions.assertFalse((boolean)HttpHeaderUtils.isValidHttpHeaderName((String)"Other\rStrange-Header"));
        Assertions.assertFalse((boolean)HttpHeaderUtils.isValidHttpHeaderName((String)"Header-With-Tab\t"));
    }
}

