/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.database;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsInstanceOf;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.ResourceLock;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.facade.ExternalDependencies;
import org.neo4j.graphdb.facade.GraphDatabaseDependencies;
import org.neo4j.kernel.internal.locker.FileLockException;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.ServerTestUtils;
import org.neo4j.server.database.DatabaseService;
import org.neo4j.server.database.GraphFactory;
import org.neo4j.server.database.LifecycleManagingDatabaseService;
import org.neo4j.server.database.SimpleGraphFactory;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.SuppressOutputExtension;

@ExtendWith(value={SuppressOutputExtension.class})
@ImpermanentDbmsExtension(configurationCallback="configure")
@ResourceLock(value="java.lang.System.out")
class TestLifecycleManagedDatabase {
    private final AssertableLogProvider logProvider = new AssertableLogProvider();
    @Inject
    private DatabaseManagementService dbms;
    private File dataDirectory;
    private DatabaseService theDatabase;
    private boolean deletionFailureOk;
    private GraphFactory dbFactory;
    private Config dbConfig;

    TestLifecycleManagedDatabase() {
    }

    @ExtensionCallback
    void configure(TestDatabaseManagementServiceBuilder builder) {
        builder.setInternalLogProvider((LogProvider)this.logProvider);
    }

    @BeforeEach
    void setup() throws Exception {
        this.dataDirectory = ServerTestUtils.createTempDir();
        this.dbFactory = new SimpleGraphFactory(this.dbms);
        this.dbConfig = Config.defaults((Setting)GraphDatabaseSettings.data_directory, (Object)this.dataDirectory.toPath().toAbsolutePath());
        this.theDatabase = this.newDatabase();
    }

    private LifecycleManagingDatabaseService newDatabase() {
        return new LifecycleManagingDatabaseService(this.dbConfig, this.dbFactory, (ExternalDependencies)GraphDatabaseDependencies.newDependencies().userLogProvider((LogProvider)this.logProvider));
    }

    @AfterEach
    void shutdownDatabase() throws Throwable {
        block2: {
            this.theDatabase.stop();
            try {
                FileUtils.forceDelete((File)this.dataDirectory);
            }
            catch (IOException e) {
                if (this.deletionFailureOk) break block2;
                throw e;
            }
        }
    }

    @Test
    void shouldLogOnSuccessfulStartup() throws Throwable {
        this.theDatabase.start();
        this.logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(LifecycleManagingDatabaseService.class).info("Started.")});
    }

    @Test
    void shouldShutdownCleanly() throws Throwable {
        this.theDatabase.start();
        this.theDatabase.stop();
        this.logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(LifecycleManagingDatabaseService.class).info("Stopped.")});
    }

    @Test
    void shouldComplainIfDatabaseLocationIsAlreadyInUse() throws Throwable {
        this.deletionFailureOk = true;
        this.theDatabase.start();
        LifecycleManagingDatabaseService db = this.newDatabase();
        try {
            db.start();
        }
        catch (RuntimeException e) {
            MatcherAssert.assertThat((Object)e.getCause().getCause(), (Matcher)IsInstanceOf.instanceOf(FileLockException.class));
        }
    }
}

