/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.ResourceLock;
import org.mockito.Mockito;
import org.neo4j.configuration.Config;
import org.neo4j.graphdb.facade.GraphDatabaseDependencies;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.server.NeoServer;
import org.neo4j.server.ServerBootstrapper;
import org.neo4j.server.database.CommunityGraphFactory;
import org.neo4j.server.database.GraphFactory;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.SuppressOutputExtension;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
@ExtendWith(value={SuppressOutputExtension.class})
@ResourceLock(value="java.lang.System.out")
class ServerBootstrapperTest {
    @Inject
    private TestDirectory homeDir;
    @Inject
    private SuppressOutput suppress;

    ServerBootstrapperTest() {
    }

    @Test
    void shouldNotThrowNullPointerExceptionIfConfigurationValidationFails() throws Exception {
        ServerBootstrapper serverBootstrapper = new ServerBootstrapper(){

            protected GraphFactory createGraphFactory(Config config) {
                return new CommunityGraphFactory();
            }

            protected NeoServer createNeoServer(GraphFactory graphFactory, Config config, GraphDatabaseDependencies dependencies) {
                return (NeoServer)Mockito.mock(NeoServer.class);
            }
        };
        File dir = Files.createTempDirectory("test-server-bootstrapper", new FileAttribute[0]).toFile();
        dir.deleteOnExit();
        serverBootstrapper.start(dir, Optional.empty(), MapUtil.stringMap((String[])new String[0]));
        MatcherAssert.assertThat((Object)this.suppress.getOutputVoice().lines(), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        serverBootstrapper.stop();
    }
}

