/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.integration;

import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContext;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.snapshot.TestTransactionVersionContextSupplier;
import org.neo4j.snapshot.TestVersionContext;
import org.neo4j.test.server.ExclusiveServerTestBase;
import org.neo4j.test.server.HTTP;

public class SnapshotQueryExecutionIT
extends ExclusiveServerTestBase {
    private TestTransactionVersionContextSupplier testContextSupplier;
    private TestVersionContext testCursorContext;
    private CommunityNeoServer server;

    @Before
    public void setUp() throws Exception {
        this.testContextSupplier = new TestTransactionVersionContextSupplier();
        Dependencies dependencies = new Dependencies();
        dependencies.satisfyDependencies(new Object[]{this.testContextSupplier});
        this.server = CommunityServerBuilder.serverOnRandomPorts().withProperty(GraphDatabaseSettings.snapshot_query.name(), "true").withDependencies((DependencyResolver)dependencies).build();
        this.server.start();
        this.prepareCursorContext();
        SnapshotQueryExecutionIT.createData((GraphDatabaseService)this.server.getDatabaseService().getDatabase());
    }

    private void prepareCursorContext() {
        this.testCursorContext = TestVersionContext.testCursorContext((DatabaseManagementService)this.server.getDatabaseService().getDatabaseManagementService(), (String)this.server.getDatabaseService().getDatabase().databaseName());
        this.testContextSupplier.setCursorContext((VersionContext)this.testCursorContext);
    }

    private static void createData(GraphDatabaseService database) {
        Label label = Label.label((String)"toRetry");
        try (Transaction transaction = database.beginTx();){
            Node node = transaction.createNode(new Label[]{label});
            node.setProperty("c", (Object)"d");
            transaction.commit();
        }
    }

    @After
    public void tearDown() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    @Test
    public void executeQueryWithSingleRetry() {
        HTTP.Response response = this.executeOverHTTP("MATCH (n) RETURN n.c");
        MatcherAssert.assertThat((Object)response.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        Map content = (Map)response.content();
        Assert.assertEquals((Object)"d", ((List)((Map)((List)((Map)((List)content.get("results")).get(0)).get("data")).get(0)).get("row")).get(0));
        Assert.assertEquals((long)1L, (long)this.testCursorContext.getAdditionalAttempts());
    }

    @Test
    public void queryThatModifiesDataAndSeesUnstableSnapshotShouldThrowException() {
        HTTP.Response response = this.executeOverHTTP("MATCH (n:toRetry) CREATE () RETURN n.c");
        Map content = (Map)response.content();
        Assert.assertEquals((Object)"Unable to get clean data snapshot for query 'MATCH (n:toRetry) CREATE () RETURN n.c' that performs updates.", ((Map)((List)content.get("errors")).get(0)).get("message"));
    }

    private HTTP.Response executeOverHTTP(String query) {
        HTTP.Builder httpClientBuilder = HTTP.withBaseUri(this.server.baseUri());
        HTTP.Response transactionStart = httpClientBuilder.POST(SnapshotQueryExecutionIT.txEndpoint());
        MatcherAssert.assertThat((Object)transactionStart.status(), (Matcher)CoreMatchers.equalTo((Object)201));
        return httpClientBuilder.POST(transactionStart.location(), HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': '" + query + "' } ] }"));
    }
}

