/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.dbms;

import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class AuthorizationHeaders {
    private AuthorizationHeaders() {
    }

    public static String[] decode(String authorizationHeader) {
        String[] parts = authorizationHeader.trim().split(" ");
        String tokenSegment = parts[parts.length - 1];
        if (tokenSegment.trim().length() == 0) {
            return null;
        }
        String decoded = AuthorizationHeaders.decodeBase64(tokenSegment);
        if (decoded.length() < 1) {
            return null;
        }
        String[] userAndPassword = decoded.split(":", 2);
        if (userAndPassword.length != 2) {
            return null;
        }
        return userAndPassword;
    }

    private static String decodeBase64(String base64) {
        try {
            byte[] decodedBytes = Base64.getDecoder().decode(base64);
            return new String(decodedBytes, StandardCharsets.UTF_8);
        }
        catch (IllegalArgumentException e) {
            return "";
        }
    }
}

