/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web;

import java.net.URI;
import java.util.Objects;
import javax.ws.rs.core.UriBuilder;

public class XForwardUtil {
    public static final String X_FORWARD_HOST_HEADER_KEY = "X-Forwarded-Host";
    public static final String X_FORWARD_PROTO_HEADER_KEY = "X-Forwarded-Proto";

    private XForwardUtil() {
    }

    public static String externalUri(String internalUri, String xForwardedHost, String xForwardedProto) {
        return XForwardUtil.externalUri(UriBuilder.fromUri((String)internalUri), xForwardedHost, xForwardedProto).toString();
    }

    public static URI externalUri(URI internalUri, String xForwardedHost, String xForwardedProto) {
        return XForwardUtil.externalUri(UriBuilder.fromUri((URI)internalUri), xForwardedHost, xForwardedProto);
    }

    private static URI externalUri(UriBuilder builder, String xForwardedHost, String xForwardedProto) {
        ForwardedHost forwardedHost = new ForwardedHost(xForwardedHost);
        ForwardedProto forwardedProto = new ForwardedProto(xForwardedProto);
        if (forwardedHost.isValid) {
            builder.host(forwardedHost.getHost());
            if (forwardedHost.hasExplicitlySpecifiedPort()) {
                builder.port(forwardedHost.getPort());
            }
        }
        if (forwardedProto.isValid()) {
            builder.scheme(forwardedProto.getScheme());
        }
        return builder.build(new Object[0]);
    }

    private static final class ForwardedProto {
        final String headerValue;

        ForwardedProto(String headerValue) {
            this.headerValue = Objects.requireNonNullElse(headerValue, "");
        }

        boolean isValid() {
            return this.headerValue.toLowerCase().equals("http") || this.headerValue.toLowerCase().equals("https");
        }

        String getScheme() {
            return this.headerValue;
        }
    }

    private static final class ForwardedHost {
        String host;
        int port = -1;
        boolean isValid;

        ForwardedHost(String headerValue) {
            if (headerValue == null) {
                this.isValid = false;
                return;
            }
            String firstHostInXForwardedHostHeader = headerValue.split(",")[0].trim();
            try {
                UriBuilder.fromUri((String)firstHostInXForwardedHostHeader).build(new Object[0]);
            }
            catch (IllegalArgumentException ex) {
                this.isValid = false;
                return;
            }
            String[] strings = firstHostInXForwardedHostHeader.split(":");
            if (strings.length > 0) {
                this.host = strings[0];
                this.isValid = true;
            }
            if (strings.length > 1) {
                this.port = Integer.parseInt(strings[1]);
                this.isValid = true;
            }
            if (strings.length > 2) {
                this.isValid = false;
            }
        }

        boolean hasExplicitlySpecifiedPort() {
            return this.port >= 0;
        }

        String getHost() {
            return this.host;
        }

        int getPort() {
            return this.port;
        }
    }
}

