/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;

public class RedirectorIT
extends AbstractRestFunctionalTestBase {
    @Test
    public void shouldRedirectRootToBrowser() throws Exception {
        HttpRequest request = HttpRequest.newBuilder(RedirectorIT.server().baseUri()).GET().build();
        HttpResponse<Void> response = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.discarding());
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)404)));
    }

    @Test
    public void shouldNotRedirectTheRestOfTheWorld() throws Exception {
        URI uri = URI.create(RedirectorIT.server().baseUri() + "a/different/relative/data/uri/");
        HttpRequest request = HttpRequest.newBuilder(uri).GET().build();
        HttpResponse<Void> response = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.discarding());
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)CoreMatchers.is((Object)404));
    }
}

