/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Answers;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.exceptions.SyntaxException;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.query.QueryExecutionKernelException;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.logging.Log;
import org.neo4j.server.http.cypher.Invocation;
import org.neo4j.server.http.cypher.OutputEventStream;
import org.neo4j.server.http.cypher.RollbackInvocation;
import org.neo4j.server.http.cypher.TransactionHandle;
import org.neo4j.server.http.cypher.TransactionRegistry;
import org.neo4j.server.http.cypher.TransitionalPeriodTransactionMessContainer;
import org.neo4j.server.http.cypher.TransitionalTxManagementKernelTransaction;
import org.neo4j.server.http.cypher.format.api.ConnectionException;
import org.neo4j.server.http.cypher.format.api.InputEventStream;
import org.neo4j.server.http.cypher.format.api.InputFormatException;
import org.neo4j.server.http.cypher.format.api.Statement;
import org.neo4j.server.http.cypher.format.api.TransactionNotificationState;
import org.neo4j.server.http.cypher.format.api.TransactionUriScheme;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;

public class InvocationTest {
    private static final MapValue NO_PARAMS = VirtualValues.EMPTY_MAP;
    private final Log log = (Log)Mockito.mock(Log.class);
    private final Result executionResult = (Result)Mockito.mock(Result.class);
    private final QueryExecutionType queryExecutionType = null;
    private final org.neo4j.cypher.internal.runtime.QueryStatistics queryStatistics = (org.neo4j.cypher.internal.runtime.QueryStatistics)Mockito.mock(org.neo4j.cypher.internal.runtime.QueryStatistics.class);
    private final ExecutionPlanDescription executionPlanDescription = (ExecutionPlanDescription)Mockito.mock(ExecutionPlanDescription.class);
    private final Iterable<Notification> notifications = Collections.emptyList();
    private final List<Result.ResultRow> resultRows = new ArrayList<Result.ResultRow>();
    private final TransitionalTxManagementKernelTransaction transactionContext = (TransitionalTxManagementKernelTransaction)Mockito.mock(TransitionalTxManagementKernelTransaction.class);
    private final TransitionalPeriodTransactionMessContainer kernel = this.mockKernel();
    private final QueryExecutionEngine executionEngine = (QueryExecutionEngine)Mockito.mock(QueryExecutionEngine.class);
    private final TransactionRegistry registry = (TransactionRegistry)Mockito.mock(TransactionRegistry.class);
    private final OutputEventStream outputEventStream = (OutputEventStream)Mockito.mock(OutputEventStream.class);
    private static final TransactionUriScheme uriScheme = new TransactionUriScheme(){

        public URI txUri(long id) {
            return URI.create("transaction/" + id);
        }

        public URI txCommitUri(long id) {
            return URI.create("transaction/" + id + "/commit");
        }

        public URI dbUri() {
            return URI.create("data/");
        }
    };

    @Before
    public void setUp() {
        ((Result)Mockito.doAnswer(invocation -> {
            Object arg0 = invocation.getArgument(0);
            Result.ResultVisitor resultVisitor = (Result.ResultVisitor)arg0;
            for (Result.ResultRow resultRow : this.resultRows) {
                resultVisitor.visit(resultRow);
            }
            return null;
        }).when((Object)this.executionResult)).accept((Result.ResultVisitor)Mockito.any());
        Mockito.when((Object)this.executionResult.getQueryExecutionType()).thenReturn((Object)this.queryExecutionType);
        Mockito.when((Object)this.executionResult.getQueryStatistics()).thenReturn((Object)this.queryStatistics);
        Mockito.when((Object)this.executionResult.getExecutionPlanDescription()).thenReturn((Object)this.executionPlanDescription);
        Mockito.when((Object)this.executionResult.getNotifications()).thenReturn(this.notifications);
    }

    @Test
    public void shouldExecuteStatements() throws Exception {
        TransactionalContext transactionalContext = this.prepareKernelWithQuerySession(this.kernel);
        Mockito.when((Object)this.executionEngine.executeQuery("query", NO_PARAMS, transactionalContext, false)).thenReturn((Object)this.executionResult);
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = this.getTransactionHandle(this.kernel, this.executionEngine, this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, null);
        this.mockDefaultResult();
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(1337L), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        ((QueryExecutionEngine)Mockito.verify((Object)this.executionEngine)).executeQuery("query", NO_PARAMS, transactionalContext, false);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementStart(statement, List.of("c1", "c2", "c3"));
        this.verifyDefaultResultRows(outputOrder);
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementEnd(this.queryExecutionType, (QueryStatistics)this.queryStatistics, this.executionPlanDescription, this.notifications);
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.COMMITTED, uriScheme.txCommitUri(1337L), -1L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    public void shouldSuspendTransactionAndReleaseForOtherRequestsAfterExecutingStatements() throws Exception {
        TransactionalContext transactionalContext = this.prepareKernelWithQuerySession(this.kernel);
        Mockito.when((Object)this.executionEngine.executeQuery("query", NO_PARAMS, transactionalContext, false)).thenReturn((Object)this.executionResult);
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = this.getTransactionHandle(this.kernel, this.executionEngine, this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, null);
        this.mockDefaultResult();
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(1337L), inputEventStream, false);
        invocation.execute(this.outputEventStream);
        InOrder transactionOrder = Mockito.inOrder((Object[])new Object[]{this.transactionContext, this.registry});
        ((TransactionRegistry)transactionOrder.verify((Object)this.registry)).release(1337L, handle);
        ((QueryExecutionEngine)Mockito.verify((Object)this.executionEngine)).executeQuery("query", NO_PARAMS, transactionalContext, false);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementStart(statement, List.of("c1", "c2", "c3"));
        this.verifyDefaultResultRows(outputOrder);
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementEnd(this.queryExecutionType, (QueryStatistics)this.queryStatistics, this.executionPlanDescription, this.notifications);
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.OPEN, uriScheme.txCommitUri(1337L), 0L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    public void shouldResumeTransactionWhenExecutingStatementsOnSecondRequest() throws Exception {
        TransactionalContext transactionalContext = this.prepareKernelWithQuerySession(this.kernel);
        Mockito.when((Object)this.executionEngine.executeQuery("query", NO_PARAMS, transactionalContext, false)).thenReturn((Object)this.executionResult);
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = this.getTransactionHandle(this.kernel, this.executionEngine, this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, null);
        this.mockDefaultResult();
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(1337L), inputEventStream, false);
        invocation.execute(this.outputEventStream);
        Mockito.reset((Object[])new Object[]{this.transactionContext, this.registry, this.executionEngine, this.outputEventStream});
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, null);
        Mockito.when((Object)this.executionEngine.executeQuery("query", NO_PARAMS, transactionalContext, false)).thenReturn((Object)this.executionResult);
        invocation.execute(this.outputEventStream);
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.transactionContext, this.registry, this.executionEngine});
        ((QueryExecutionEngine)order.verify((Object)this.executionEngine)).executeQuery("query", NO_PARAMS, transactionalContext, false);
        ((TransactionRegistry)order.verify((Object)this.registry)).release(1337L, handle);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementStart(statement, List.of("c1", "c2", "c3"));
        this.verifyDefaultResultRows(outputOrder);
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementEnd(this.queryExecutionType, (QueryStatistics)this.queryStatistics, this.executionPlanDescription, this.notifications);
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.OPEN, uriScheme.txCommitUri(1337L), 0L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    public void shouldCommitSinglePeriodicCommitStatement() {
        String queryText = "USING PERIODIC COMMIT CREATE()";
        TransactionalContext transactionalContext = this.prepareKernelWithQuerySession(this.kernel);
        GraphDatabaseFacade facade = (GraphDatabaseFacade)Mockito.mock(GraphDatabaseFacade.class, (Answer)Answers.RETURNS_DEEP_STUBS);
        InternalTransaction transaction = (InternalTransaction)Mockito.mock(InternalTransaction.class);
        Mockito.when((Object)facade.beginTransaction((KernelTransaction.Type)Mockito.eq((Object)KernelTransaction.Type.implicit), (LoginContext)Mockito.any(LoginContext.class), (ClientConnectionInfo)Mockito.any(ClientConnectionInfo.class), Mockito.anyLong(), (TimeUnit)((Object)Mockito.any(TimeUnit.class)))).thenReturn((Object)transaction);
        Mockito.when((Object)transaction.execute((String)Mockito.eq((Object)queryText), (Map)Mockito.any())).thenReturn((Object)this.executionResult);
        Mockito.when((Object)this.executionEngine.isPeriodicCommit(queryText)).thenReturn((Object)true);
        Mockito.when((Object)this.kernel.getDb()).thenReturn((Object)facade);
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = this.getTransactionHandle(this.kernel, this.executionEngine, this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement(queryText, MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, null);
        this.mockDefaultResult();
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(1337L), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementStart(statement, List.of("c1", "c2", "c3"));
        this.verifyDefaultResultRows(outputOrder);
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementEnd(this.queryExecutionType, (QueryStatistics)this.queryStatistics, this.executionPlanDescription, this.notifications);
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.COMMITTED, uriScheme.txCommitUri(1337L), -1L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    public void shouldCommitTransactionAndTellRegistryToForgetItsHandle() throws Exception {
        TransactionalContext transactionalContext = this.prepareKernelWithQuerySession(this.kernel);
        Mockito.when((Object)this.executionEngine.executeQuery("query", NO_PARAMS, transactionalContext, false)).thenReturn((Object)this.executionResult);
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = this.getTransactionHandle(this.kernel, this.executionEngine, this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, null);
        this.mockDefaultResult();
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(1337L), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        InOrder transactionOrder = Mockito.inOrder((Object[])new Object[]{this.transactionContext, this.registry});
        ((TransitionalTxManagementKernelTransaction)transactionOrder.verify((Object)this.transactionContext)).commit();
        ((TransactionRegistry)transactionOrder.verify((Object)this.registry)).forget(1337L);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementStart(statement, List.of("c1", "c2", "c3"));
        this.verifyDefaultResultRows(outputOrder);
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementEnd(this.queryExecutionType, (QueryStatistics)this.queryStatistics, this.executionPlanDescription, this.notifications);
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.COMMITTED, uriScheme.txCommitUri(1337L), -1L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    public void shouldRollbackTransactionAndTellRegistryToForgetItsHandle() {
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = this.getTransactionHandle(this.kernel, this.executionEngine, this.registry);
        RollbackInvocation invocation = new RollbackInvocation(this.log, handle);
        invocation.execute(this.outputEventStream);
        InOrder transactionOrder = Mockito.inOrder((Object[])new Object[]{this.transactionContext, this.registry});
        ((TransitionalTxManagementKernelTransaction)transactionOrder.verify((Object)this.transactionContext)).rollback();
        ((TransactionRegistry)transactionOrder.verify((Object)this.registry)).forget(1337L);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.ROLLED_BACK, null, -1L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    public void shouldCreateTransactionContextOnlyWhenFirstNeeded() throws Exception {
        TransactionalContext transactionalContext = this.prepareKernelWithQuerySession(this.kernel);
        Mockito.when((Object)this.executionEngine.executeQuery("query", NO_PARAMS, transactionalContext, false)).thenReturn((Object)this.executionResult);
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, null);
        this.mockDefaultResult();
        TransactionHandle handle = this.getTransactionHandle(this.kernel, this.executionEngine, this.registry);
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(1337L), inputEventStream, true);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.kernel});
        invocation.execute(this.outputEventStream);
        ((TransitionalPeriodTransactionMessContainer)Mockito.verify((Object)this.kernel)).newTransaction((KernelTransaction.Type)Mockito.any(KernelTransaction.Type.class), (LoginContext)Mockito.any(LoginContext.class), (ClientConnectionInfo)Mockito.eq((Object)ClientConnectionInfo.EMBEDDED_CONNECTION), Mockito.anyLong());
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementStart(statement, List.of("c1", "c2", "c3"));
        this.verifyDefaultResultRows(outputOrder);
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementEnd(this.queryExecutionType, (QueryStatistics)this.queryStatistics, this.executionPlanDescription, this.notifications);
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.COMMITTED, uriScheme.txCommitUri(1337L), -1L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    public void shouldRollbackTransactionIfExecutionErrorOccurs() throws Exception {
        TransactionalContext transactionalContext = this.prepareKernelWithQuerySession(this.kernel);
        Mockito.when((Object)this.executionEngine.executeQuery("query", NO_PARAMS, transactionalContext, false)).thenThrow(new Throwable[]{new IllegalStateException("Something went wrong")});
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = this.getTransactionHandle(this.kernel, this.executionEngine, this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, null);
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(1337L), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        ((QueryExecutionEngine)Mockito.verify((Object)this.executionEngine)).executeQuery("query", NO_PARAMS, transactionalContext, false);
        ((TransitionalTxManagementKernelTransaction)Mockito.verify((Object)this.transactionContext)).rollback();
        ((TransactionRegistry)Mockito.verify((Object)this.registry)).forget(1337L);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeFailure((Status)Status.Statement.ExecutionFailed, "Something went wrong");
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.ROLLED_BACK, uriScheme.txCommitUri(1337L), -1L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    public void shouldHandleCommitError() throws Exception {
        TransactionalContext transactionalContext = this.prepareKernelWithQuerySession(this.kernel);
        Mockito.when((Object)this.executionEngine.executeQuery("query", NO_PARAMS, transactionalContext, false)).thenReturn((Object)this.executionResult);
        ((TransitionalTxManagementKernelTransaction)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalStateException("Something went wrong")}).when((Object)this.transactionContext)).commit();
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = this.getTransactionHandle(this.kernel, this.executionEngine, this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, null);
        this.mockDefaultResult();
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(1337L), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        ((QueryExecutionEngine)Mockito.verify((Object)this.executionEngine)).executeQuery("query", NO_PARAMS, transactionalContext, false);
        ((Log)Mockito.verify((Object)this.log)).error((String)Mockito.eq((Object)"Failed to commit transaction."), (Throwable)Mockito.any(IllegalStateException.class));
        ((TransactionRegistry)Mockito.verify((Object)this.registry)).forget(1337L);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementStart(statement, List.of("c1", "c2", "c3"));
        this.verifyDefaultResultRows(outputOrder);
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementEnd(this.queryExecutionType, (QueryStatistics)this.queryStatistics, this.executionPlanDescription, this.notifications);
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeFailure((Status)Status.Transaction.TransactionCommitFailed, "Something went wrong");
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.UNKNOWN, uriScheme.txCommitUri(1337L), -1L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    public void shouldHandleErrorWhenStartingTransaction() {
        Mockito.when((Object)this.kernel.newTransaction((KernelTransaction.Type)Mockito.any(), (LoginContext)Mockito.any(), (ClientConnectionInfo)Mockito.any(), Mockito.anyLong())).thenThrow(new Throwable[]{new IllegalStateException("Something went wrong")});
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = this.getTransactionHandle(this.kernel, this.executionEngine, this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, null);
        this.mockDefaultResult();
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(1337L), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        ((Log)Mockito.verify((Object)this.log)).error((String)Mockito.eq((Object)"Failed to start transaction"), (Throwable)Mockito.any(IllegalStateException.class));
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeFailure((Status)Status.Transaction.TransactionStartFailed, "Something went wrong");
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.NO_TRANSACTION, uriScheme.txCommitUri(1337L), -1L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    public void shouldHandleAuthorizationErrorWhenStartingTransaction() {
        Mockito.when((Object)this.kernel.newTransaction((KernelTransaction.Type)Mockito.any(), (LoginContext)Mockito.any(), (ClientConnectionInfo)Mockito.any(), Mockito.anyLong())).thenThrow(new Throwable[]{new AuthorizationViolationException("Forbidden")});
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = this.getTransactionHandle(this.kernel, this.executionEngine, this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, null);
        this.mockDefaultResult();
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(1337L), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.log});
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeFailure((Status)Status.Security.Forbidden, "Forbidden");
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.NO_TRANSACTION, uriScheme.txCommitUri(1337L), -1L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    public void shouldHandleCypherSyntaxError() throws Exception {
        String queryText = "matsch (n) return n";
        TransactionalContext transactionalContext = this.prepareKernelWithQuerySession(this.kernel);
        Mockito.when((Object)this.executionEngine.executeQuery(queryText, NO_PARAMS, transactionalContext, false)).thenThrow(new Throwable[]{new QueryExecutionKernelException((Throwable)new SyntaxException("did you mean MATCH?"))});
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = this.getTransactionHandle(this.kernel, this.executionEngine, this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement(queryText, MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, null);
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(1337L), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        ((TransitionalTxManagementKernelTransaction)Mockito.verify((Object)this.transactionContext)).rollback();
        ((TransactionRegistry)Mockito.verify((Object)this.registry)).forget(1337L);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeFailure((Status)Status.Statement.SyntaxError, "did you mean MATCH?");
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.ROLLED_BACK, uriScheme.txCommitUri(1337L), -1L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    public void shouldHandleExecutionEngineThrowingUndeclaredCheckedExceptions() throws Exception {
        TransactionalContext transactionalContext = this.prepareKernelWithQuerySession(this.kernel);
        Mockito.when((Object)this.executionEngine.executeQuery("query", NO_PARAMS, transactionalContext, false)).thenThrow(new Throwable[]{new RuntimeException("BOO")});
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = this.getTransactionHandle(this.kernel, this.executionEngine, this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, null);
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(1337L), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        ((TransitionalTxManagementKernelTransaction)Mockito.verify((Object)this.transactionContext)).rollback();
        ((TransactionRegistry)Mockito.verify((Object)this.registry)).forget(1337L);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeFailure((Status)Status.Statement.ExecutionFailed, "BOO");
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.ROLLED_BACK, uriScheme.txCommitUri(1337L), -1L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    public void shouldHandleRollbackError() throws Exception {
        TransactionalContext transactionalContext = this.prepareKernelWithQuerySession(this.kernel);
        Mockito.when((Object)this.executionEngine.executeQuery("query", NO_PARAMS, transactionalContext, false)).thenThrow(new Throwable[]{new RuntimeException("BOO")});
        ((TransitionalTxManagementKernelTransaction)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalStateException("Something went wrong")}).when((Object)this.transactionContext)).rollback();
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = this.getTransactionHandle(this.kernel, this.executionEngine, this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, null);
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(1337L), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        ((QueryExecutionEngine)Mockito.verify((Object)this.executionEngine)).executeQuery("query", NO_PARAMS, transactionalContext, false);
        ((Log)Mockito.verify((Object)this.log)).error((String)Mockito.eq((Object)"Failed to roll back transaction."), (Throwable)Mockito.any(IllegalStateException.class));
        ((TransactionRegistry)Mockito.verify((Object)this.registry)).forget(1337L);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeFailure((Status)Status.Statement.ExecutionFailed, "BOO");
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeFailure((Status)Status.Transaction.TransactionRollbackFailed, "Something went wrong");
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.UNKNOWN, uriScheme.txCommitUri(1337L), -1L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    public void shouldInterruptTransaction() throws Exception {
        TransactionalContext transactionalContext = this.prepareKernelWithQuerySession(this.kernel);
        Mockito.when((Object)this.executionEngine.executeQuery("query", NO_PARAMS, transactionalContext, false)).thenReturn((Object)this.executionResult);
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = this.getTransactionHandle(this.kernel, this.executionEngine, this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, null);
        this.mockDefaultResult();
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(1337L), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        handle.terminate();
        ((TransitionalTxManagementKernelTransaction)Mockito.verify((Object)this.transactionContext)).terminate();
    }

    @Test
    public void deadlockExceptionHasCorrectStatus() throws Exception {
        TransactionalContext transactionalContext = this.prepareKernelWithQuerySession(this.kernel);
        Mockito.when((Object)this.executionEngine.executeQuery("query", NO_PARAMS, transactionalContext, false)).thenThrow(new Throwable[]{new DeadlockDetectedException("deadlock")});
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = this.getTransactionHandle(this.kernel, this.executionEngine, this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, null);
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(1337L), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        ((TransitionalTxManagementKernelTransaction)Mockito.verify((Object)this.transactionContext)).rollback();
        ((TransactionRegistry)Mockito.verify((Object)this.registry)).forget(1337L);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeFailure((Status)Status.Transaction.DeadlockDetected, "deadlock");
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.ROLLED_BACK, uriScheme.txCommitUri(1337L), -1L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    public void startTransactionWithRequestedTimeout() {
        GraphDatabaseQueryService queryService = (GraphDatabaseQueryService)Mockito.mock(GraphDatabaseQueryService.class);
        TransactionHandle handle = new TransactionHandle(this.kernel, this.executionEngine, queryService, (TransactionRegistry)Mockito.mock(TransactionRegistry.class), uriScheme, true, LoginContext.AUTH_DISABLED, ClientConnectionInfo.EMBEDDED_CONNECTION, 100L);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Mockito.when((Object)inputEventStream.read()).thenReturn(null);
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(1337L), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        ((TransitionalPeriodTransactionMessContainer)Mockito.verify((Object)this.kernel)).newTransaction(KernelTransaction.Type.implicit, LoginContext.AUTH_DISABLED, ClientConnectionInfo.EMBEDDED_CONNECTION, 100L);
    }

    @Test
    public void shouldHandleInputParsingErrorWhenReadingStatements() {
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = this.getTransactionHandle(this.kernel, this.executionEngine, this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Mockito.when((Object)inputEventStream.read()).thenThrow(new Throwable[]{new InputFormatException("Cannot parse input", (Throwable)new IOException("JSON ERROR"))});
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(1337L), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        ((TransitionalTxManagementKernelTransaction)Mockito.verify((Object)this.transactionContext)).rollback();
        ((TransactionRegistry)Mockito.verify((Object)this.registry)).forget(1337L);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeFailure((Status)Status.Request.InvalidFormat, "Cannot parse input");
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.ROLLED_BACK, uriScheme.txCommitUri(1337L), -1L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    public void shouldHandleConnectionErrorWhenReadingStatementsInImplicitTransaction() {
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = this.getTransactionHandle(this.kernel, this.executionEngine, this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Mockito.when((Object)inputEventStream.read()).thenThrow(new Throwable[]{new ConnectionException("Connection error", (Throwable)new IOException("Broken pipe"))});
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(1337L), inputEventStream, true);
        try {
            invocation.execute(this.outputEventStream);
            Assert.fail();
        }
        catch (ConnectionException e) {
            Assert.assertEquals((Object)"Connection error", (Object)e.getMessage());
        }
        ((TransitionalTxManagementKernelTransaction)Mockito.verify((Object)this.transactionContext)).rollback();
        ((TransactionRegistry)Mockito.verify((Object)this.registry)).forget(1337L);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    public void shouldKeepTransactionOpenIfConnectionErrorWhenReadingStatementsInExplicitTransaction() {
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = this.getTransactionHandle(this.kernel, this.executionEngine, this.registry, false);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Mockito.when((Object)inputEventStream.read()).thenThrow(new Throwable[]{new ConnectionException("Connection error", (Throwable)new IOException("Broken pipe"))});
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(1337L), inputEventStream, true);
        try {
            invocation.execute(this.outputEventStream);
            Assert.fail();
        }
        catch (ConnectionException e) {
            Assert.assertEquals((Object)"Connection error", (Object)e.getMessage());
        }
        ((TransitionalTxManagementKernelTransaction)Mockito.verify((Object)this.transactionContext, (VerificationMode)Mockito.never())).rollback();
        ((TransitionalTxManagementKernelTransaction)Mockito.verify((Object)this.transactionContext, (VerificationMode)Mockito.never())).commit();
        ((TransactionRegistry)Mockito.verify((Object)this.registry, (VerificationMode)Mockito.never())).forget(1337L);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    public void shouldHandleConnectionErrorWhenWritingOutputInImplicitTransaction() throws QueryExecutionKernelException {
        TransactionalContext transactionalContext = this.prepareKernelWithQuerySession(this.kernel);
        Mockito.when((Object)this.executionEngine.executeQuery("query", NO_PARAMS, transactionalContext, false)).thenReturn((Object)this.executionResult);
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = this.getTransactionHandle(this.kernel, this.executionEngine, this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, null);
        this.mockDefaultResult();
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(1337L), inputEventStream, true);
        ((OutputEventStream)Mockito.doThrow((Throwable[])new Throwable[]{new ConnectionException("Connection error", (Throwable)new IOException("Broken pipe"))}).when((Object)this.outputEventStream)).writeStatementEnd((QueryExecutionType)Mockito.any(), (QueryStatistics)Mockito.any(), (ExecutionPlanDescription)Mockito.any(), (Iterable)Mockito.any());
        try {
            invocation.execute(this.outputEventStream);
            Assert.fail();
        }
        catch (ConnectionException e) {
            Assert.assertEquals((Object)"Connection error", (Object)e.getMessage());
        }
        ((TransitionalTxManagementKernelTransaction)Mockito.verify((Object)this.transactionContext)).rollback();
        ((TransactionRegistry)Mockito.verify((Object)this.registry)).forget(1337L);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementStart(statement, List.of("c1", "c2", "c3"));
        this.verifyDefaultResultRows(outputOrder);
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementEnd(this.queryExecutionType, (QueryStatistics)this.queryStatistics, this.executionPlanDescription, this.notifications);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    public void shouldKeepTransactionOpenIfConnectionErrorWhenWritingOutputInImplicitTransaction() throws QueryExecutionKernelException {
        TransactionalContext transactionalContext = this.prepareKernelWithQuerySession(this.kernel);
        Mockito.when((Object)this.executionEngine.executeQuery("query", NO_PARAMS, transactionalContext, false)).thenReturn((Object)this.executionResult);
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = this.getTransactionHandle(this.kernel, this.executionEngine, this.registry, false);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, null);
        this.mockDefaultResult();
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(1337L), inputEventStream, false);
        ((OutputEventStream)Mockito.doThrow((Throwable[])new Throwable[]{new ConnectionException("Connection error", (Throwable)new IOException("Broken pipe"))}).when((Object)this.outputEventStream)).writeStatementEnd((QueryExecutionType)Mockito.any(), (QueryStatistics)Mockito.any(), (ExecutionPlanDescription)Mockito.any(), (Iterable)Mockito.any());
        try {
            invocation.execute(this.outputEventStream);
            Assert.fail();
        }
        catch (ConnectionException e) {
            Assert.assertEquals((Object)"Connection error", (Object)e.getMessage());
        }
        ((TransitionalTxManagementKernelTransaction)Mockito.verify((Object)this.transactionContext, (VerificationMode)Mockito.never())).rollback();
        ((TransactionRegistry)Mockito.verify((Object)this.registry, (VerificationMode)Mockito.never())).forget(1337L);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementStart(statement, List.of("c1", "c2", "c3"));
        this.verifyDefaultResultRows(outputOrder);
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementEnd(this.queryExecutionType, (QueryStatistics)this.queryStatistics, this.executionPlanDescription, this.notifications);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    private void mockDefaultResult() {
        Mockito.when((Object)this.executionResult.columns()).thenReturn(List.of("c1", "c2", "c3"));
        this.mockResultRow(Map.of("c1", "v1", "c2", "v2", "c3", "v3"));
        this.mockResultRow(Map.of("c1", "v4", "c2", "v5", "c3", "v6"));
    }

    private void verifyDefaultResultRows(InOrder outputOrder) {
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeRecord((List)Mockito.eq(List.of("c1", "c2", "c3")), (Function)ArgumentMatchers.argThat((ArgumentMatcher)new ValuesMatcher(Map.of("c1", "v1", "c2", "v2", "c3", "v3"))));
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeRecord((List)Mockito.eq(List.of("c1", "c2", "c3")), (Function)ArgumentMatchers.argThat((ArgumentMatcher)new ValuesMatcher(Map.of("c1", "v4", "c2", "v5", "c3", "v6"))));
    }

    private TransactionHandle getTransactionHandle(TransitionalPeriodTransactionMessContainer kernel, QueryExecutionEngine executionEngine, TransactionRegistry registry) {
        return this.getTransactionHandle(kernel, executionEngine, registry, true);
    }

    private TransactionHandle getTransactionHandle(TransitionalPeriodTransactionMessContainer kernel, QueryExecutionEngine executionEngine, TransactionRegistry registry, boolean implicitTransaction) {
        GraphDatabaseQueryService queryService = (GraphDatabaseQueryService)Mockito.mock(GraphDatabaseQueryService.class);
        return new TransactionHandle(kernel, executionEngine, queryService, registry, uriScheme, implicitTransaction, LoginContext.AUTH_DISABLED, ClientConnectionInfo.EMBEDDED_CONNECTION, Mockito.anyLong());
    }

    private TransitionalPeriodTransactionMessContainer mockKernel() {
        TransitionalPeriodTransactionMessContainer kernel = (TransitionalPeriodTransactionMessContainer)Mockito.mock(TransitionalPeriodTransactionMessContainer.class);
        Mockito.when((Object)kernel.newTransaction((KernelTransaction.Type)Mockito.any(KernelTransaction.Type.class), (LoginContext)Mockito.any(LoginContext.class), (ClientConnectionInfo)Mockito.any(ClientConnectionInfo.class), Mockito.anyLong())).thenReturn((Object)this.transactionContext);
        return kernel;
    }

    private TransactionalContext prepareKernelWithQuerySession(TransitionalPeriodTransactionMessContainer kernel) {
        TransactionalContext tc = (TransactionalContext)Mockito.mock(TransactionalContext.class);
        Mockito.when((Object)kernel.create((GraphDatabaseQueryService)Mockito.any(GraphDatabaseQueryService.class), (InternalTransaction)Mockito.any(), (String)Mockito.any(String.class), (Map)Mockito.any(Map.class))).thenReturn((Object)tc);
        return tc;
    }

    private void mockResultRow(Map<String, Object> row) {
        Result.ResultRow resultRow = (Result.ResultRow)Mockito.mock(Result.ResultRow.class);
        row.forEach((key, value) -> Mockito.when((Object)resultRow.get(key)).thenReturn(value));
        this.resultRows.add(resultRow);
    }

    private static class ValuesMatcher
    implements ArgumentMatcher<Function<String, Object>> {
        private final Map<String, Object> values;

        private ValuesMatcher(Map<String, Object> values) {
            this.values = values;
        }

        public boolean matches(Function<String, Object> valueExtractor) {
            return this.values.entrySet().stream().anyMatch(entry -> entry.getValue().equals(valueExtractor.apply((String)entry.getKey())));
        }
    }
}

