/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web.logging;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestName;
import org.junit.rules.TestRule;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.function.ThrowingSupplier;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.NeoServer;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.server.helpers.FunctionalTestHelper;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.server.ExclusiveServerTestBase;

public class HTTPLoggingIT
extends ExclusiveServerTestBase {
    private final ExpectedException exception = ExpectedException.none();
    private final TestDirectory testDirectory = TestDirectory.testDirectory();
    private final TestName testName = new TestName();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.exception).around((TestRule)this.testName).around((TestRule)this.testDirectory);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void givenExplicitlyDisabledServerLoggingConfigurationShouldNotLogAccesses() throws Exception {
        String query = "?implicitlyDisabled" + HTTPLoggingIT.randomString();
        CommunityNeoServer server = this.createServer("false");
        try {
            server.start();
            FunctionalTestHelper functionalTestHelper = new FunctionalTestHelper((NeoServer)server);
            HttpResponse<Void> response = HTTPLoggingIT.queryBaseUri(query, functionalTestHelper);
            Assert.assertThat((Object)response.statusCode(), (Matcher)CoreMatchers.is((Object)200));
            Assert.assertThat((Object)Files.exists(HTTPLoggingIT.httpLogFile(server), new LinkOption[0]), (Matcher)CoreMatchers.is((Object)false));
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void givenExplicitlyEnabledServerLoggingConfigurationShouldLogAccess() throws Exception {
        String query = "?explicitlyEnabled=" + HTTPLoggingIT.randomString();
        CommunityNeoServer server = this.createServer("true");
        try {
            server.start();
            FunctionalTestHelper functionalTestHelper = new FunctionalTestHelper((NeoServer)server);
            HttpResponse<Void> response = HTTPLoggingIT.queryBaseUri(query, functionalTestHelper);
            Assert.assertThat((Object)response.statusCode(), (Matcher)CoreMatchers.is((Object)200));
            org.neo4j.test.assertion.Assert.assertEventually((String)"request appears in log", HTTPLoggingIT.httpLogContent(server), (Matcher)Matchers.containsString((String)query), (long)5L, (TimeUnit)TimeUnit.SECONDS);
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void givenExplicitlyEnabledServerLoggingConfigurationShouldLogWithoutQueryString() throws Exception {
        String path = "/foo/bar/baz";
        CommunityNeoServer server = this.createServer("true");
        try {
            server.start();
            FunctionalTestHelper functionalTestHelper = new FunctionalTestHelper((NeoServer)server);
            HttpResponse<Void> response = HTTPLoggingIT.queryUri(functionalTestHelper.baseUri().resolve(path));
            Assert.assertThat((Object)response.statusCode(), (Matcher)CoreMatchers.is((Object)404));
            org.neo4j.test.assertion.Assert.assertEventually((String)"request appears in log", HTTPLoggingIT.httpLogContent(server), HTTPLoggingIT.containsPathWithoutQueryString(path), (long)5L, (TimeUnit)TimeUnit.SECONDS);
        }
        finally {
            server.stop();
        }
    }

    private CommunityNeoServer createServer(String httpLoggingEnabledValue) throws IOException {
        String directoryPrefix = this.testName.getMethodName();
        File logDirectory = this.testDirectory.directory(directoryPrefix + "-logdir", new String[0]);
        return CommunityServerBuilder.serverOnRandomPorts().withDefaultDatabaseTuning().persistent().withProperty(ServerSettings.http_logging_enabled.name(), httpLoggingEnabledValue).withProperty(GraphDatabaseSettings.logs_directory.name(), logDirectory.getAbsolutePath()).withProperty(BoltConnector.listen_address.name(), ":0").usingDataDir(this.testDirectory.directory(directoryPrefix + "-dbdir", new String[0]).getAbsolutePath()).build();
    }

    private static ThrowingSupplier<String, IOException> httpLogContent(CommunityNeoServer server) {
        Path httpLogFile = HTTPLoggingIT.httpLogFile(server);
        return () -> Files.readString(httpLogFile);
    }

    private static Path httpLogFile(CommunityNeoServer server) {
        Path logDirectory = (Path)server.getConfig().get(GraphDatabaseSettings.logs_directory);
        return logDirectory.resolve("http.log");
    }

    private static String randomString() {
        return UUID.randomUUID().toString();
    }

    private static HttpResponse<Void> queryBaseUri(String query, FunctionalTestHelper functionalTestHelper) throws IOException, InterruptedException {
        return HTTPLoggingIT.queryUri(URI.create(functionalTestHelper.baseUri() + query));
    }

    private static HttpResponse<Void> queryUri(URI uri) throws IOException, InterruptedException {
        HttpRequest httpRequest = HttpRequest.newBuilder(uri).GET().build();
        HttpClient httpClient = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).build();
        return httpClient.send(httpRequest, HttpResponse.BodyHandlers.discarding());
    }

    private static Matcher<String> containsPathWithoutQueryString(String path) {
        return Matchers.both((Matcher)Matchers.containsString((String)path)).and(Matchers.not((Matcher)Matchers.containsString((String)"?")));
    }
}

