/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.neo4j.common.Validator;
import org.neo4j.internal.helpers.Args;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.kernel.impl.util.Converters;

public class ServerCommandLineArgs {
    public static final String CONFIG_DIR_ARG = "config-dir";
    public static final String HOME_DIR_ARG = "home-dir";
    public static final String VERSION_ARG = "version";
    private final Args args;
    private final Map<String, String> configOverrides;

    private ServerCommandLineArgs(Args args, Map<String, String> configOverrides) {
        this.args = args;
        this.configOverrides = configOverrides;
    }

    public static ServerCommandLineArgs parse(String[] argv) {
        Args args = Args.withFlags((String[])new String[]{VERSION_ARG}).parse(argv);
        return new ServerCommandLineArgs(args, ServerCommandLineArgs.parseConfigOverrides(args));
    }

    public Map<String, String> configOverrides() {
        return this.configOverrides;
    }

    public Optional<File> configFile() {
        return Optional.ofNullable(this.args.get(CONFIG_DIR_ARG)).map(dirPath -> new File((String)dirPath, "neo4j.conf"));
    }

    private static Map<String, String> parseConfigOverrides(Args arguments) {
        Collection options = arguments.interpretOptions("c", Converters.optional(), s -> {
            if (s.contains("=")) {
                String[] keyVal = s.split("=", 2);
                return Pair.pair((Object)keyVal[0], (Object)keyVal[1]);
            }
            return Pair.pair((Object)s, (Object)"true");
        }, new Validator[0]);
        Map ret = MapUtil.stringMap((String[])new String[0]);
        options.forEach(pair -> ret.put((String)pair.first(), (String)pair.other()));
        return ret;
    }

    public File homeDir() {
        if (this.args.get(HOME_DIR_ARG) == null) {
            return null;
        }
        return new File(this.args.get(HOME_DIR_ARG));
    }

    public boolean version() {
        return this.args.getBoolean(VERSION_ARG, Boolean.valueOf(false));
    }
}

