/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.format.output.eventsource;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.mockito.Mockito;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.graphdb.Relationship;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.server.http.cypher.format.api.FailureEvent;
import org.neo4j.server.http.cypher.format.api.RecordEvent;
import org.neo4j.server.http.cypher.format.api.StatementEndEvent;
import org.neo4j.server.http.cypher.format.api.StatementStartEvent;
import org.neo4j.server.http.cypher.format.api.TransactionInfoEvent;
import org.neo4j.server.http.cypher.format.api.TransactionNotificationState;
import org.neo4j.server.http.cypher.format.input.json.InputStatement;
import org.neo4j.server.http.cypher.format.output.eventsource.LineDelimitedEventSourceJoltSerializer;
import org.neo4j.server.http.cypher.format.output.json.ResultDataContent;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.test.mockito.mock.GraphMock;
import org.neo4j.test.mockito.mock.Link;
import org.neo4j.test.mockito.mock.Properties;

public abstract class AbstractEventSourceJoltSerializerTest {
    protected void writeStatementStart(LineDelimitedEventSourceJoltSerializer serializer, String ... columns) {
        this.writeStatementStart(serializer, (List<ResultDataContent>)null, columns);
    }

    protected void writeStatementStart(LineDelimitedEventSourceJoltSerializer serializer, List<ResultDataContent> resultDataContents, String ... columns) {
        serializer.writeStatementStart(new StatementStartEvent(null, Arrays.asList(columns)), new InputStatement(null, null, false, resultDataContents));
    }

    protected void writeRecord(LineDelimitedEventSourceJoltSerializer serializer, Map<String, ?> row, String ... columns) {
        serializer.writeRecord(new RecordEvent(Arrays.asList(columns), row::get));
    }

    protected void writeStatementEnd(LineDelimitedEventSourceJoltSerializer serializer) {
        this.writeStatementEnd(serializer, null, Collections.emptyList());
    }

    protected void writeStatementEnd(LineDelimitedEventSourceJoltSerializer serializer, ExecutionPlanDescription planDescription, Iterable<Notification> notifications) {
        QueryExecutionType queryExecutionType = null != planDescription ? QueryExecutionType.profiled((QueryExecutionType.QueryType)QueryExecutionType.QueryType.READ_WRITE) : QueryExecutionType.query((QueryExecutionType.QueryType)QueryExecutionType.QueryType.READ_WRITE);
        serializer.writeStatementEnd(new StatementEndEvent(queryExecutionType, null, planDescription, notifications));
    }

    protected void writeTransactionInfo(LineDelimitedEventSourceJoltSerializer serializer) {
        serializer.writeErrorWrapper();
        serializer.writeTransactionInfo(new TransactionInfoEvent(TransactionNotificationState.NO_TRANSACTION, null, -1L));
    }

    protected void writeTransactionInfo(LineDelimitedEventSourceJoltSerializer serializer, String commitUri) {
        serializer.writeErrorWrapper();
        serializer.writeTransactionInfo(new TransactionInfoEvent(TransactionNotificationState.NO_TRANSACTION, URI.create(commitUri), -1L));
    }

    protected void writeError(LineDelimitedEventSourceJoltSerializer serializer, Status status, String message) {
        serializer.writeFailure(new FailureEvent(status, message));
    }

    protected Path mockPath(Map<String, Object> startNodeProperties, Map<String, Object> relationshipProperties, Map<String, Object> endNodeProperties) {
        Node startNode = GraphMock.node((long)1L, (Properties)Properties.properties(startNodeProperties), (String[])new String[0]);
        Node endNode = GraphMock.node((long)2L, (Properties)Properties.properties(endNodeProperties), (String[])new String[0]);
        Relationship relationship = GraphMock.relationship((long)1L, (Properties)Properties.properties(relationshipProperties), (Node)startNode, (String)"RELATED", (Node)endNode);
        return GraphMock.path((Node)startNode, (Link[])new Link[]{Link.link((Relationship)relationship, (Node)endNode)});
    }

    protected Set<JsonNode> identifiersOf(JsonNode root) {
        HashSet<JsonNode> parentIds = new HashSet<JsonNode>();
        for (JsonNode id : root.get("identifiers")) {
            parentIds.add(id);
        }
        return parentIds;
    }

    protected ExecutionPlanDescription mockedPlanDescription(String operatorType, Set<String> identifiers, Map<String, Object> args, List<ExecutionPlanDescription> children) {
        ExecutionPlanDescription planDescription = (ExecutionPlanDescription)Mockito.mock(ExecutionPlanDescription.class);
        Mockito.when((Object)planDescription.getChildren()).thenReturn(children);
        Mockito.when((Object)planDescription.getName()).thenReturn((Object)operatorType);
        Mockito.when((Object)planDescription.getArguments()).thenReturn(args);
        Mockito.when((Object)planDescription.getIdentifiers()).thenReturn(identifiers);
        return planDescription;
    }

    protected JsonNode wrapWithType(String sigil, Object value) throws JsonParseException {
        return JsonHelper.jsonNode((String)("{\"" + sigil + "\":\"" + value + "\"}"));
    }

    protected JsonNode assertIsPlanRoot(JsonNode result) throws JsonParseException {
        JsonNode plan = result.get("plan");
        Assertions.assertTrue((plan != null && plan.isObject() ? 1 : 0) != 0, (String)"Expected plan to be an object");
        JsonNode root = plan.get("root");
        Assertions.assertTrue((root != null && root.isObject() ? 1 : 0) != 0, (String)"Expected plan to be an object");
        return root;
    }
}

