/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.logging;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class JULBridge
extends Handler {
    private static final String UNKNOWN_LOGGER_NAME = "unknown";
    private final LogProvider logProvider;
    private final ConcurrentMap<String, Log> logs = new ConcurrentHashMap<String, Log>();

    protected JULBridge(LogProvider logProvider) {
        this.logProvider = logProvider;
    }

    public static void resetJUL() {
        LogManager.getLogManager().reset();
    }

    public static void forwardTo(LogProvider logProvider) {
        JULBridge.rootJULLogger().addHandler(new JULBridge(logProvider));
    }

    private static Logger rootJULLogger() {
        return LogManager.getLogManager().getLogger("");
    }

    @Override
    public void publish(LogRecord record) {
        if (record == null) {
            return;
        }
        String message = this.getMessage(record);
        if (message == null) {
            return;
        }
        String context = record.getLoggerName();
        Log log = this.getLog(context != null ? context : UNKNOWN_LOGGER_NAME);
        this.log(log, record.getLevel().intValue(), message, record.getThrown());
    }

    private void log(Log log, int level, String message, Throwable throwable) {
        if (level <= Level.FINE.intValue()) {
            if (throwable == null) {
                log.debug(message);
            } else {
                log.debug(message, throwable);
            }
        } else if (level <= Level.INFO.intValue()) {
            if (throwable == null) {
                log.info(message);
            } else {
                log.info(message, throwable);
            }
        } else if (level <= Level.WARNING.intValue()) {
            if (throwable == null) {
                log.warn(message);
            } else {
                log.warn(message, throwable);
            }
        } else if (throwable == null) {
            log.error(message);
        } else {
            log.error(message, throwable);
        }
    }

    private Log getLog(String name) {
        Log newLog;
        Log log = (Log)this.logs.get(name);
        if (log == null && (log = this.logs.putIfAbsent(name, newLog = this.logProvider.getLog(name))) == null) {
            log = newLog;
        }
        return log;
    }

    private String getMessage(LogRecord record) {
        Object[] params;
        String message = record.getMessage();
        if (message == null) {
            return null;
        }
        ResourceBundle bundle = record.getResourceBundle();
        if (bundle != null) {
            try {
                message = bundle.getString(message);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if ((params = record.getParameters()) != null && params.length > 0) {
            message = MessageFormat.format(message, params);
        }
        return message;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }
}

