/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.file.Path;
import java.time.Clock;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.neo4j.collection.Dependencies;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.ConnectorPortRegister;
import org.neo4j.configuration.connectors.HttpConnector;
import org.neo4j.configuration.connectors.HttpsConnector;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.configuration.ssl.SslPolicyScope;
import org.neo4j.dbms.DatabaseStateService;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.availability.CompositeDatabaseAvailabilityGuard;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.internal.Version;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.LogTimeZone;
import org.neo4j.logging.internal.LogService;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.server.NeoWebServer;
import org.neo4j.server.ServerStartupException;
import org.neo4j.server.bind.ComponentsBinder;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.http.cypher.HttpTransactionManager;
import org.neo4j.server.http.cypher.TransactionRegistry;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.rest.repr.InputFormat;
import org.neo4j.server.rest.repr.InputFormatProvider;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.OutputFormatProvider;
import org.neo4j.server.rest.repr.RepresentationFormatRepository;
import org.neo4j.server.web.RotatingRequestLog;
import org.neo4j.server.web.SimpleUriBuilder;
import org.neo4j.server.web.WebServer;
import org.neo4j.ssl.config.SslPolicyLoader;
import org.neo4j.time.Clocks;

public abstract class AbstractNeoWebServer
extends LifecycleAdapter
implements NeoWebServer {
    private static final long MINIMUM_TIMEOUT = 1000L;
    private static final long ROUNDING_SECOND = 1000L;
    static final String NEO4J_IS_STARTING_MESSAGE = "======== Neo4j " + Version.getNeo4jVersion() + " ========";
    protected final LogProvider userLogProvider;
    private final Log log;
    private final DbmsInfo dbmsInfo;
    private final List<ServerModule> serverModules = new ArrayList<ServerModule>();
    private final SimpleUriBuilder uriBuilder = new SimpleUriBuilder();
    private final List<Pattern> authWhitelist;
    private final DatabaseManagementService databaseManagementService;
    private final Dependencies globalDependencies;
    private final Config config;
    private final LifeSupport life = new LifeSupport();
    private final boolean httpEnabled;
    private final boolean httpsEnabled;
    private SocketAddress httpListenAddress;
    private SocketAddress httpsListenAddress;
    private SocketAddress httpAdvertisedAddress;
    private SocketAddress httpsAdvertisedAddress;
    protected WebServer webServer;
    protected Supplier<AuthManager> authManagerSupplier;
    private Supplier<SslPolicyLoader> sslPolicyFactorySupplier;
    private HttpTransactionManager httpTransactionManager;
    private CompositeDatabaseAvailabilityGuard globalAvailabilityGuard;
    protected ConnectorPortRegister connectorPortRegister;
    private RotatingRequestLog requestLog;

    protected abstract Iterable<ServerModule> createServerModules();

    protected abstract WebServer createWebServer();

    public AbstractNeoWebServer(DatabaseManagementService databaseManagementService, Dependencies globalDependencies, Config config, LogProvider userLogProvider, DbmsInfo dbmsInfo) {
        this.databaseManagementService = databaseManagementService;
        this.globalDependencies = globalDependencies;
        this.config = config;
        this.userLogProvider = userLogProvider;
        this.log = userLogProvider.getLog(this.getClass());
        this.dbmsInfo = dbmsInfo;
        this.log.info(NEO4J_IS_STARTING_MESSAGE);
        AbstractNeoWebServer.verifyConnectorsConfiguration(config);
        this.httpEnabled = (Boolean)config.get(HttpConnector.enabled);
        if (this.httpEnabled) {
            this.httpListenAddress = (SocketAddress)config.get(HttpConnector.listen_address);
            this.httpAdvertisedAddress = (SocketAddress)config.get(HttpConnector.advertised_address);
        }
        this.httpsEnabled = (Boolean)config.get(HttpsConnector.enabled);
        if (this.httpsEnabled) {
            this.httpsListenAddress = (SocketAddress)config.get(HttpsConnector.listen_address);
            this.httpsAdvertisedAddress = (SocketAddress)config.get(HttpsConnector.advertised_address);
        }
        this.authWhitelist = AbstractNeoWebServer.parseAuthWhitelist(config);
        this.authManagerSupplier = globalDependencies.provideDependency(AuthManager.class);
        this.sslPolicyFactorySupplier = globalDependencies.provideDependency(SslPolicyLoader.class);
        this.connectorPortRegister = (ConnectorPortRegister)globalDependencies.resolveDependency(ConnectorPortRegister.class);
        this.httpTransactionManager = this.createHttpTransactionManager();
        this.globalAvailabilityGuard = (CompositeDatabaseAvailabilityGuard)globalDependencies.resolveDependency(CompositeDatabaseAvailabilityGuard.class);
        this.life.add((Lifecycle)new ServerComponentsLifecycleAdapter());
    }

    protected Dependencies getGlobalDependencies() {
        return this.globalDependencies;
    }

    @Override
    public DbmsInfo getDbmsInfo() {
        return this.dbmsInfo;
    }

    public void init() {
        this.life.init();
    }

    public void start() throws ServerStartupException {
        try {
            this.life.start();
        }
        catch (Throwable t) {
            this.life.shutdown();
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)t);
            throw new ServerStartupException(String.format("Starting Neo4j failed: %s", rootCause.getMessage()), rootCause);
        }
    }

    private HttpTransactionManager createHttpTransactionManager() {
        JobScheduler jobScheduler = (JobScheduler)this.globalDependencies.resolveDependency(JobScheduler.class);
        Clock clock = Clocks.systemClock();
        Duration transactionTimeout = this.getTransactionTimeout();
        return new HttpTransactionManager(this.databaseManagementService, jobScheduler, clock, transactionTimeout, this.userLogProvider);
    }

    private Duration getTransactionTimeout() {
        long timeout = ((Duration)this.config.get(ServerSettings.transaction_idle_timeout)).toMillis();
        return Duration.ofMillis(Math.max(timeout, 2000L));
    }

    private void registerModule(ServerModule module) {
        this.serverModules.add(module);
    }

    private void startModules() {
        for (ServerModule module : this.serverModules) {
            module.start();
        }
    }

    private void stopModules() {
        ArrayList<Exception> errors = new ArrayList<Exception>();
        for (ServerModule module : this.serverModules) {
            try {
                module.stop();
            }
            catch (Exception e) {
                errors.add(e);
            }
        }
        if (!errors.isEmpty()) {
            RuntimeException e = new RuntimeException();
            errors.forEach(e::addSuppressed);
            throw e;
        }
    }

    private void clearModules() {
        this.serverModules.clear();
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    protected void configureWebServer() {
        SslPolicyLoader sslPolicyLoader;
        this.webServer.setHttpAddress(this.httpListenAddress);
        this.webServer.setHttpsAddress(this.httpsListenAddress);
        this.webServer.setMaxThreads((Integer)this.config.get(ServerSettings.webserver_max_threads));
        this.webServer.setWadlEnabled((Boolean)this.config.get(ServerSettings.wadl_enabled));
        this.webServer.setComponentsBinder(this.createComponentsBinder());
        if (this.httpsEnabled && (sslPolicyLoader = this.sslPolicyFactorySupplier.get()).hasPolicyForSource(SslPolicyScope.HTTPS)) {
            this.webServer.setSslPolicy(sslPolicyLoader.getPolicy(SslPolicyScope.HTTPS));
        }
    }

    protected void startWebServer() throws Exception {
        try {
            this.setUpHttpLogging();
            this.webServer.start();
            this.registerHttpAddressAfterStartup();
            this.registerHttpsAddressAfterStartup();
            this.log.info("Remote interface available at %s", new Object[]{this.getBaseUri()});
        }
        catch (Exception e) {
            SocketAddress address = this.httpListenAddress != null ? this.httpListenAddress : this.httpsListenAddress;
            this.log.error("Failed to start Neo4j on %s: %s", new Object[]{address, e.getMessage()});
            throw e;
        }
    }

    private void registerHttpAddressAfterStartup() {
        if (this.httpEnabled) {
            InetSocketAddress localHttpAddress = this.webServer.getLocalHttpAddress();
            this.connectorPortRegister.register("http", localHttpAddress);
            if (this.httpAdvertisedAddress.getPort() == 0) {
                this.httpAdvertisedAddress = new SocketAddress(localHttpAddress.getHostString(), localHttpAddress.getPort());
            }
        }
    }

    private void registerHttpsAddressAfterStartup() {
        if (this.httpsEnabled) {
            InetSocketAddress localHttpsAddress = this.webServer.getLocalHttpsAddress();
            this.connectorPortRegister.register("https", localHttpsAddress);
            if (this.httpsAdvertisedAddress.getPort() == 0) {
                this.httpsAdvertisedAddress = new SocketAddress(localHttpsAddress.getHostString(), localHttpsAddress.getPort());
            }
        }
    }

    private void setUpHttpLogging() throws IOException {
        if (!((Boolean)this.getConfig().get(ServerSettings.http_logging_enabled)).booleanValue()) {
            return;
        }
        this.requestLog = new RotatingRequestLog((FileSystemAbstraction)this.globalDependencies.resolveDependency(FileSystemAbstraction.class), (LogTimeZone)this.config.get(GraphDatabaseSettings.db_timezone), ((Path)this.config.get(ServerSettings.http_log_path)).toString(), (Long)this.config.get(ServerSettings.http_logging_rotation_size), (Integer)this.config.get(ServerSettings.http_logging_rotation_keep_number));
        this.webServer.setRequestLog(this.requestLog);
    }

    protected List<Pattern> getUriWhitelist() {
        return this.authWhitelist;
    }

    public void stop() {
        this.shutdownGlobalAvailabilityGuard();
        this.life.stop();
    }

    private void shutdownGlobalAvailabilityGuard() {
        try {
            if (this.globalAvailabilityGuard != null) {
                this.globalAvailabilityGuard.stop();
            }
        }
        catch (Throwable t) {
            this.log.error("Failed to set the global availability guard to shutdown in the process of stopping the Neo4j server", t);
        }
    }

    private void stopWebServer() throws Exception {
        if (this.webServer != null) {
            this.webServer.stop();
        }
        if (this.requestLog != null) {
            this.requestLog.stop();
        }
    }

    @Override
    public TransactionRegistry getTransactionRegistry() {
        return this.httpTransactionManager.getTransactionRegistry();
    }

    @Override
    public URI getBaseUri() {
        return this.httpAdvertisedAddress != null ? this.uriBuilder.buildURI(this.httpAdvertisedAddress, false) : this.uriBuilder.buildURI(this.httpsAdvertisedAddress, true);
    }

    @Override
    public Optional<URI> httpsUri() {
        return Optional.ofNullable(this.httpsAdvertisedAddress).map(address -> this.uriBuilder.buildURI((SocketAddress)address, true));
    }

    public WebServer getWebServer() {
        return this.webServer;
    }

    private ComponentsBinder createComponentsBinder() {
        ComponentsBinder binder = new ComponentsBinder();
        DatabaseStateService databaseStateService = (DatabaseStateService)this.getGlobalDependencies().resolveDependency(DatabaseStateService.class);
        binder.addSingletonBinding(this.databaseManagementService, DatabaseManagementService.class);
        binder.addSingletonBinding(databaseStateService, DatabaseStateService.class);
        binder.addSingletonBinding(this, NeoWebServer.class);
        binder.addSingletonBinding(this.getConfig(), Config.class);
        binder.addSingletonBinding(this.getWebServer(), WebServer.class);
        binder.addSingletonBinding(new RepresentationFormatRepository(), RepresentationFormatRepository.class);
        binder.addLazyBinding(InputFormatProvider.class, InputFormat.class);
        binder.addLazyBinding(OutputFormatProvider.class, OutputFormat.class);
        binder.addSingletonBinding(this.httpTransactionManager, HttpTransactionManager.class);
        binder.addLazyBinding(this.authManagerSupplier, AuthManager.class);
        binder.addSingletonBinding(this.userLogProvider, LogProvider.class);
        binder.addSingletonBinding(this.userLogProvider.getLog(NeoWebServer.class), Log.class);
        return binder;
    }

    private static void verifyConnectorsConfiguration(Config config) {
        boolean httpAndHttpsDisabled;
        boolean bl = httpAndHttpsDisabled = (Boolean)config.get(HttpConnector.enabled) == false && (Boolean)config.get(HttpsConnector.enabled) == false;
        if (httpAndHttpsDisabled) {
            throw new IllegalArgumentException("Either HTTP or HTTPS connector must be configured to run the server");
        }
    }

    private static List<Pattern> parseAuthWhitelist(Config config) {
        return ((List)config.get(ServerSettings.http_auth_allowlist)).stream().map(Pattern::compile).collect(Collectors.toUnmodifiableList());
    }

    private class ServerComponentsLifecycleAdapter
    extends LifecycleAdapter {
        private ServerComponentsLifecycleAdapter() {
        }

        public void init() {
            AbstractNeoWebServer.this.webServer = AbstractNeoWebServer.this.createWebServer();
            for (ServerModule moduleClass : AbstractNeoWebServer.this.createServerModules()) {
                AbstractNeoWebServer.this.registerModule(moduleClass);
            }
        }

        public void start() throws Exception {
            LogService logService = (LogService)AbstractNeoWebServer.this.globalDependencies.resolveDependency(LogService.class);
            Log serverLog = logService.getInternalLog(ServerComponentsLifecycleAdapter.class);
            serverLog.info("Starting web server");
            AbstractNeoWebServer.this.configureWebServer();
            AbstractNeoWebServer.this.startModules();
            AbstractNeoWebServer.this.startWebServer();
            serverLog.info("Web server started.");
        }

        public void stop() throws Exception {
            AbstractNeoWebServer.this.stopWebServer();
            AbstractNeoWebServer.this.stopModules();
            AbstractNeoWebServer.this.clearModules();
        }
    }
}

