/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.server.rest.repr.ExceptionRepresentation;
import org.neo4j.server.rest.repr.MappingSerializer;
import org.neo4j.server.rest.repr.MappingWriter;
import org.neo4j.server.rest.repr.formats.MapWrappingWriter;

class ExceptionRepresentationTest {
    ExceptionRepresentationTest() {
    }

    @Test
    void shouldIncludeCause() throws Exception {
        ExceptionRepresentation rep = new ExceptionRepresentation((Throwable)new RuntimeException("Hoho", new RuntimeException("Haha", new RuntimeException("HAHA!"))));
        JsonNode out = this.serialize(rep);
        Assertions.assertThat((String)out.get("cause").get("message").asText()).isEqualTo("Haha");
        Assertions.assertThat((String)out.get("cause").get("cause").get("message").asText()).isEqualTo("HAHA!");
    }

    @Test
    void shouldRenderErrorsWithNeo4jStatusCode() throws Exception {
        ExceptionRepresentation rep = new ExceptionRepresentation((Throwable)new KernelException((Status)Status.General.UnknownError, "Hello", new Object[0]){});
        JsonNode out = this.serialize(rep);
        Assertions.assertThat((String)out.get("errors").get(0).get("code").asText()).isEqualTo("Neo.DatabaseError.General.UnknownError");
        Assertions.assertThat((String)out.get("errors").get(0).get("message").asText()).isEqualTo("Hello");
    }

    @Test
    void shouldExcludeLegacyFormatIfAsked() throws Exception {
        ExceptionRepresentation rep = new ExceptionRepresentation((Throwable)new KernelException((Status)Status.General.UnknownError, "Hello", new Object[0]){}, false);
        JsonNode out = this.serialize(rep);
        Assertions.assertThat((String)out.get("errors").get(0).get("code").asText()).isEqualTo("Neo.DatabaseError.General.UnknownError");
        Assertions.assertThat((String)out.get("errors").get(0).get("message").asText()).isEqualTo("Hello");
        Assertions.assertThat((boolean)out.has("message")).isEqualTo(false);
    }

    private JsonNode serialize(ExceptionRepresentation rep) throws JsonParseException {
        HashMap output = new HashMap();
        MappingSerializer serializer = new MappingSerializer((MappingWriter)new MapWrappingWriter(output), URI.create(""));
        rep.serialize(serializer);
        return JsonHelper.jsonNode((String)JsonHelper.createJsonFrom(output));
    }
}

