/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.server;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.ws.rs.core.Response;
import org.assertj.core.api.Assertions;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.test.server.InsecureTrustManager;

public final class HTTP {
    private static final Builder BUILDER = new Builder();
    private static final HttpClient CLIENT = HTTP.newClient();

    private HTTP() {
    }

    public static String basicAuthHeader(String username, String password) {
        String usernamePassword = username + ":" + password;
        return "Basic " + Base64.getEncoder().encodeToString(usernamePassword.getBytes());
    }

    public static Builder withBasicAuth(String username, String password) {
        return HTTP.withHeaders("Authorization", HTTP.basicAuthHeader(username, password));
    }

    public static Builder withHeaders(String ... kvPairs) {
        return BUILDER.withHeaders(kvPairs);
    }

    public static Builder withBaseUri(URI baseUri) {
        return BUILDER.withBaseUri(baseUri.toString());
    }

    public static Response POST(String uri) {
        return BUILDER.POST(uri);
    }

    public static Response POST(String uri, Object payload) {
        return BUILDER.POST(uri, payload);
    }

    public static Response POST(String uri, RawPayload payload) {
        return BUILDER.POST(uri, payload);
    }

    public static Response GET(String uri) {
        return BUILDER.GET(uri);
    }

    public static Response request(String method, String uri, Object payload) {
        return BUILDER.request(method, uri, payload);
    }

    public static HttpClient newClient() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{new InsecureTrustManager()}, null);
            return HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NEVER).sslContext(sslContext).build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static HttpResponse<String> sanityCheck(HttpResponse<String> response) {
        String contentEncoding;
        List<String> contentEncodings = response.headers().allValues("Content-Encoding");
        if (contentEncodings != null && (contentEncoding = (String)Iterables.singleOrNull(contentEncodings)) != null) {
            contentEncoding = contentEncoding.toLowerCase();
            Assertions.assertThat((String)contentEncoding).satisfiesAnyOf(s -> Assertions.assertThat((String)s).contains(new CharSequence[]{"gzip"}), s -> Assertions.assertThat((String)s).contains(new CharSequence[]{"defalte"}));
            Assertions.assertThat((String)contentEncoding).doesNotContain(new CharSequence[]{"utf-8"});
        }
        return response;
    }

    public static class RawPayload {
        private final String payload;

        public static RawPayload rawPayload(String payload) {
            return new RawPayload(payload);
        }

        public static RawPayload quotedJson(String json) {
            return new RawPayload(json.replaceAll("'", "\""));
        }

        private RawPayload(String payload) {
            this.payload = payload;
        }

        public String get() {
            return this.payload;
        }
    }

    public static class Response {
        private final HttpResponse<String> response;
        private final String entity;

        public Response(HttpResponse<String> response) {
            this.response = HTTP.sanityCheck(response);
            this.entity = response.statusCode() == Response.Status.NO_CONTENT.getStatusCode() ? "" : response.body();
        }

        public int status() {
            return this.response.statusCode();
        }

        public String location() {
            return this.response.headers().firstValue("Location").orElseThrow(() -> new RuntimeException("The request did not contain a location header.\n" + this));
        }

        public <T> T content() {
            try {
                return (T)JsonHelper.readJson((String)this.entity);
            }
            catch (JsonParseException e) {
                throw new RuntimeException("Unable to deserialize: " + this.entity, e);
            }
        }

        public String rawContent() {
            return this.entity;
        }

        public String stringFromContent(String key) throws JsonParseException {
            return this.get(key).asText();
        }

        public JsonNode get(String fieldName) throws JsonParseException {
            return JsonHelper.jsonNode((String)this.entity).get(fieldName);
        }

        public String header(String name) {
            return this.response.headers().firstValue(name).orElse(null);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("HTTP ").append(this.response.statusCode()).append("\n");
            for (Map.Entry<String, List<String>> headerEntry : this.response.headers().map().entrySet()) {
                for (String headerValue : headerEntry.getValue()) {
                    sb.append(headerEntry.getKey()).append(": ").append(headerValue).append("\n");
                }
            }
            sb.append("\n");
            sb.append(this.entity).append("\n");
            return sb.toString();
        }
    }

    public static class Builder {
        private final Map<String, String> headers;
        private final String baseUri;

        private Builder() {
            this(Collections.emptyMap(), "");
        }

        private Builder(Map<String, String> headers, String baseUri) {
            this.baseUri = baseUri;
            this.headers = Collections.unmodifiableMap(headers);
        }

        public Builder withHeaders(String ... kvPairs) {
            return this.withHeaders(MapUtil.stringMap((String[])kvPairs));
        }

        public Builder withHeaders(Map<String, String> newHeaders) {
            HashMap<String, String> combinedHeaders = new HashMap<String, String>();
            combinedHeaders.putAll(this.headers);
            combinedHeaders.putAll(newHeaders);
            return new Builder(combinedHeaders, this.baseUri);
        }

        public Builder withBaseUri(String baseUri) {
            return new Builder(this.headers, baseUri);
        }

        public Response POST(String uri) {
            return this.request("POST", uri);
        }

        public Response POST(String uri, Object payload) {
            return this.request("POST", uri, payload);
        }

        public Response POST(String uri, RawPayload payload) {
            return this.request("POST", uri, payload);
        }

        public Response DELETE(String uri) {
            return this.request("DELETE", uri);
        }

        public Response GET(String uri) {
            return this.request("GET", uri);
        }

        public Response request(String method, String uri) {
            HttpRequest request = this.requestBuilder(uri).method(method, HttpRequest.BodyPublishers.noBody()).build();
            HttpResponse<String> response = Builder.send(request);
            return new Response(response);
        }

        public Response request(String method, String uri, Object payload) {
            if (payload == null) {
                return this.request(method, uri);
            }
            String jsonPayload = payload instanceof RawPayload ? ((RawPayload)payload).get() : JsonHelper.createJsonFrom((Object)payload);
            HttpRequest request = this.requestBuilder(uri).method(method, HttpRequest.BodyPublishers.ofString(jsonPayload)).setHeader("Content-Type", "application/json").build();
            HttpResponse<String> response = Builder.send(request);
            return new Response(response);
        }

        private URI buildUri(String uri) {
            URI unprefixedUri = URI.create(uri);
            if (unprefixedUri.isAbsolute()) {
                return unprefixedUri;
            }
            return URI.create(this.baseUri + uri);
        }

        private HttpRequest.Builder requestBuilder(String uri) {
            HttpRequest.Builder builder = HttpRequest.newBuilder(this.buildUri(uri));
            for (Map.Entry<String, String> headerEntry : this.headers.entrySet()) {
                builder = builder.setHeader(headerEntry.getKey(), headerEntry.getValue());
            }
            return builder;
        }

        private static HttpResponse<String> send(HttpRequest request) {
            try {
                return Builder.getStringHttpResponse(request);
            }
            catch (Exception e) {
                if (e.getMessage().contains("HTTP/1.1 header parser received no bytes")) {
                    try {
                        return Builder.getStringHttpResponse(request);
                    }
                    catch (Exception e2) {
                        throw new RuntimeException(e2);
                    }
                }
                throw new RuntimeException(e);
            }
        }

        private static HttpResponse<String> getStringHttpResponse(HttpRequest request) throws InterruptedException, ExecutionException, TimeoutException {
            return CLIENT.sendAsync(request, HttpResponse.BodyHandlers.ofString()).get(4L, TimeUnit.MINUTES);
        }
    }
}

