/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.server.web.JettyThreadCalculator;

class JettyThreadCalculatorTest {
    JettyThreadCalculatorTest() {
    }

    @Test
    void shouldHaveCorrectAmountOfThreads() {
        JettyThreadCalculator jtc = new JettyThreadCalculator(1);
        Assertions.assertEquals((int)1, (int)jtc.getAcceptors(), (String)"Wrong acceptor value for 1 core");
        Assertions.assertEquals((int)1, (int)jtc.getSelectors(), (String)"Wrong selector value for 1 core");
        Assertions.assertEquals((int)12, (int)jtc.getMaxThreads(), (String)"Wrong maxThreads value for 1 core");
        Assertions.assertEquals((int)6, (int)jtc.getMinThreads(), (String)"Wrong minThreads value for 1 core");
        Assertions.assertEquals((int)480000, (int)jtc.getMaxCapacity(), (String)"Wrong capacity value for 1 core");
        jtc = new JettyThreadCalculator(4);
        Assertions.assertEquals((int)1, (int)jtc.getAcceptors(), (String)"Wrong acceptor value for 4 cores");
        Assertions.assertEquals((int)2, (int)jtc.getSelectors(), (String)"Wrong selector value for 4 cores");
        Assertions.assertEquals((int)14, (int)jtc.getMaxThreads(), (String)"Wrong maxThreads value for 4 cores");
        Assertions.assertEquals((int)8, (int)jtc.getMinThreads(), (String)"Wrong minThreads value for 4 cores");
        Assertions.assertEquals((int)480000, (int)jtc.getMaxCapacity(), (String)"Wrong capacity value for 4 cores");
        jtc = new JettyThreadCalculator(16);
        Assertions.assertEquals((int)2, (int)jtc.getAcceptors(), (String)"Wrong acceptor value for 16 cores");
        Assertions.assertEquals((int)3, (int)jtc.getSelectors(), (String)"Wrong selector value for 16 cores");
        Assertions.assertEquals((int)21, (int)jtc.getMaxThreads(), (String)"Wrong maxThreads value for 16 cores");
        Assertions.assertEquals((int)14, (int)jtc.getMinThreads(), (String)"Wrong minThreads value for 16 cores");
        Assertions.assertEquals((int)660000, (int)jtc.getMaxCapacity(), (String)"Wrong capacity value for 16 cores");
        jtc = new JettyThreadCalculator(64);
        Assertions.assertEquals((int)4, (int)jtc.getAcceptors(), (String)"Wrong acceptor value for 64 cores");
        Assertions.assertEquals((int)8, (int)jtc.getSelectors(), (String)"Wrong selector value for 64 cores");
        Assertions.assertEquals((int)76, (int)jtc.getMaxThreads(), (String)"Wrong maxThreads value for 64 cores");
        Assertions.assertEquals((int)36, (int)jtc.getMinThreads(), (String)"Wrong minThreads value for 64 cores");
        Assertions.assertEquals((int)3120000, (int)jtc.getMaxCapacity(), (String)"Wrong capacity value for 64 cores");
        jtc = new JettyThreadCalculator(44738);
        Assertions.assertEquals((int)2982, (int)jtc.getAcceptors(), (String)"Wrong acceptor value for max cores");
        Assertions.assertEquals((int)5965, (int)jtc.getSelectors(), (String)"Wrong selector value for max cores");
        Assertions.assertEquals((int)53685, (int)jtc.getMaxThreads(), (String)"Wrong maxThreads value for max cores");
        Assertions.assertEquals((int)26841, (int)jtc.getMinThreads(), (String)"Wrong minThreads value for max cores");
        Assertions.assertEquals((int)2147460000, (int)jtc.getMaxCapacity(), (String)"Wrong capacity value for max cores");
    }

    @Test
    void shouldNotAllowLessThanOneThread() {
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> new JettyThreadCalculator(0));
        Assertions.assertEquals((Object)"Max threads can't be less than 1", (Object)exception.getMessage());
    }

    @Test
    void shouldNotAllowMoreThanMaxValue() {
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> new JettyThreadCalculator(44739));
        Assertions.assertEquals((Object)String.format("Max threads can't exceed %d", 44738), (Object)exception.getMessage());
    }
}

