/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher;

import java.time.Clock;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.logging.LogProvider;
import org.neo4j.memory.MemoryPool;
import org.neo4j.server.http.cypher.InvalidConcurrentTransactionAccess;
import org.neo4j.server.http.cypher.InvalidTransactionId;
import org.neo4j.server.http.cypher.TransactionHandle;
import org.neo4j.server.http.cypher.TransactionHandleRegistry;
import org.neo4j.server.http.cypher.TransactionLifecycleException;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;

class TransactionHandleRegistryTest {
    TransactionHandleRegistryTest() {
    }

    @Test
    void shouldGenerateTransactionId() {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        MemoryPool memoryPool = (MemoryPool)Mockito.mock(MemoryPool.class);
        TransactionHandleRegistry registry = new TransactionHandleRegistry((Clock)Clocks.fakeClock(), Duration.ofMillis(0L), (LogProvider)logProvider, memoryPool);
        TransactionHandle handle = (TransactionHandle)Mockito.mock(TransactionHandle.class);
        long id1 = registry.begin(handle);
        long id2 = registry.begin(handle);
        org.junit.jupiter.api.Assertions.assertNotEquals((long)id1, (long)id2);
        LogAssertions.assertThat((AssertableLogProvider)logProvider).doesNotHaveAnyLogs();
        ((MemoryPool)Mockito.verify((Object)memoryPool, (VerificationMode)Mockito.times((int)2))).reserveHeap(TransactionHandleRegistry.ACTIVE_TRANSACTION_SHALLOW_SIZE);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{memoryPool});
    }

    @Test
    void shouldStoreSuspendedTransaction() throws Exception {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        MemoryPool memoryPool = (MemoryPool)Mockito.mock(MemoryPool.class);
        TransactionHandleRegistry registry = new TransactionHandleRegistry((Clock)Clocks.fakeClock(), Duration.ofMillis(0L), (LogProvider)logProvider, memoryPool);
        TransactionHandle handle = (TransactionHandle)Mockito.mock(TransactionHandle.class);
        long id = registry.begin(handle);
        registry.release(id, handle);
        TransactionHandle acquiredHandle = registry.acquire(id);
        org.junit.jupiter.api.Assertions.assertSame((Object)handle, (Object)acquiredHandle);
        LogAssertions.assertThat((AssertableLogProvider)logProvider).doesNotHaveAnyLogs();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{memoryPool});
        ((MemoryPool)inOrder.verify((Object)memoryPool)).reserveHeap(TransactionHandleRegistry.ACTIVE_TRANSACTION_SHALLOW_SIZE);
        ((MemoryPool)inOrder.verify((Object)memoryPool)).reserveHeap(TransactionHandleRegistry.SUSPENDED_TRANSACTION_SHALLOW_SIZE);
        ((MemoryPool)inOrder.verify((Object)memoryPool)).releaseHeap(TransactionHandleRegistry.SUSPENDED_TRANSACTION_SHALLOW_SIZE);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{memoryPool});
    }

    @Test
    void acquiringATransactionThatHasAlreadyBeenAcquiredShouldThrowInvalidConcurrentTransactionAccess() throws Exception {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        MemoryPool memoryPool = (MemoryPool)Mockito.mock(MemoryPool.class);
        TransactionHandleRegistry registry = new TransactionHandleRegistry((Clock)Clocks.fakeClock(), Duration.ofMillis(0L), (LogProvider)logProvider, memoryPool);
        TransactionHandle handle = (TransactionHandle)Mockito.mock(TransactionHandle.class);
        long id = registry.begin(handle);
        registry.release(id, handle);
        registry.acquire(id);
        org.junit.jupiter.api.Assertions.assertThrows(InvalidConcurrentTransactionAccess.class, () -> registry.acquire(id));
        LogAssertions.assertThat((AssertableLogProvider)logProvider).doesNotHaveAnyLogs();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{memoryPool});
        ((MemoryPool)inOrder.verify((Object)memoryPool)).reserveHeap(TransactionHandleRegistry.ACTIVE_TRANSACTION_SHALLOW_SIZE);
        ((MemoryPool)inOrder.verify((Object)memoryPool)).reserveHeap(TransactionHandleRegistry.SUSPENDED_TRANSACTION_SHALLOW_SIZE);
        ((MemoryPool)inOrder.verify((Object)memoryPool)).releaseHeap(TransactionHandleRegistry.SUSPENDED_TRANSACTION_SHALLOW_SIZE);
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    void acquiringANonExistentTransactionShouldThrowErrorInvalidTransactionId() {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        MemoryPool memoryPool = (MemoryPool)Mockito.mock(MemoryPool.class);
        TransactionHandleRegistry registry = new TransactionHandleRegistry((Clock)Clocks.fakeClock(), Duration.ofMillis(0L), (LogProvider)logProvider, memoryPool);
        long madeUpTransactionId = 1337L;
        org.junit.jupiter.api.Assertions.assertThrows(InvalidTransactionId.class, () -> registry.acquire(madeUpTransactionId));
        LogAssertions.assertThat((AssertableLogProvider)logProvider).doesNotHaveAnyLogs();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{memoryPool});
    }

    @Test
    void transactionsShouldBeEvictedWhenUnusedLongerThanTimeout() throws Exception {
        FakeClock clock = Clocks.fakeClock();
        AssertableLogProvider logProvider = new AssertableLogProvider();
        MemoryPool memoryPool = (MemoryPool)Mockito.mock(MemoryPool.class);
        TransactionHandleRegistry registry = new TransactionHandleRegistry((Clock)clock, Duration.ofMillis(0L), (LogProvider)logProvider, memoryPool);
        TransactionHandle oldTx = (TransactionHandle)Mockito.mock(TransactionHandle.class);
        TransactionHandle newTx = (TransactionHandle)Mockito.mock(TransactionHandle.class);
        TransactionHandle handle = (TransactionHandle)Mockito.mock(TransactionHandle.class);
        long txId1 = registry.begin(handle);
        long txId2 = registry.begin(handle);
        registry.release(txId1, oldTx);
        clock.forward(1L, TimeUnit.MINUTES);
        registry.release(txId2, newTx);
        registry.rollbackSuspendedTransactionsIdleSince(clock.millis() - 1000L);
        Assertions.assertThat((Object)registry.acquire(txId2)).isEqualTo((Object)newTx);
        org.junit.jupiter.api.Assertions.assertThrows(InvalidTransactionId.class, () -> registry.acquire(txId1));
        LogAssertions.assertThat((AssertableLogProvider)logProvider).forClass(TransactionHandleRegistry.class).forLevel(AssertableLogProvider.Level.INFO).containsMessages(new String[]{"Transaction with id 1 has been automatically rolled back due to transaction timeout."});
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{memoryPool});
        ((MemoryPool)inOrder.verify((Object)memoryPool, Mockito.times((int)2))).reserveHeap(TransactionHandleRegistry.ACTIVE_TRANSACTION_SHALLOW_SIZE);
        ((MemoryPool)inOrder.verify((Object)memoryPool, Mockito.times((int)2))).reserveHeap(TransactionHandleRegistry.SUSPENDED_TRANSACTION_SHALLOW_SIZE);
        ((MemoryPool)inOrder.verify((Object)memoryPool)).releaseHeap(TransactionHandleRegistry.ACTIVE_TRANSACTION_SHALLOW_SIZE);
        ((MemoryPool)inOrder.verify((Object)memoryPool)).releaseHeap(TransactionHandleRegistry.SUSPENDED_TRANSACTION_SHALLOW_SIZE);
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    void expiryTimeShouldBeSetToCurrentTimePlusTimeout() throws Exception {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        FakeClock clock = Clocks.fakeClock();
        MemoryPool memoryPool = (MemoryPool)Mockito.mock(MemoryPool.class);
        int timeoutLength = 123;
        TransactionHandleRegistry registry = new TransactionHandleRegistry((Clock)clock, Duration.ofMillis(timeoutLength), (LogProvider)logProvider, memoryPool);
        TransactionHandle handle = (TransactionHandle)Mockito.mock(TransactionHandle.class);
        long id = registry.begin(handle);
        long timesOutAt = registry.release(id, handle);
        Assertions.assertThat((long)timesOutAt).isEqualTo(clock.millis() + (long)timeoutLength);
        clock.forward(1337L, TimeUnit.MILLISECONDS);
        registry.acquire(id);
        timesOutAt = registry.release(id, handle);
        Assertions.assertThat((long)timesOutAt).isEqualTo(clock.millis() + (long)timeoutLength);
    }

    @Test
    void shouldProvideInterruptHandlerForActiveTransaction() throws TransactionLifecycleException {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        FakeClock clock = Clocks.fakeClock();
        MemoryPool memoryPool = (MemoryPool)Mockito.mock(MemoryPool.class);
        int timeoutLength = 123;
        TransactionHandleRegistry registry = new TransactionHandleRegistry((Clock)clock, Duration.ofMillis(timeoutLength), (LogProvider)logProvider, memoryPool);
        TransactionHandle handle = (TransactionHandle)Mockito.mock(TransactionHandle.class);
        long id = registry.begin(handle);
        registry.terminate(id);
        ((TransactionHandle)Mockito.verify((Object)handle)).terminate();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{handle});
        ((MemoryPool)Mockito.verify((Object)memoryPool)).reserveHeap(TransactionHandleRegistry.ACTIVE_TRANSACTION_SHALLOW_SIZE);
        ((MemoryPool)Mockito.verify((Object)memoryPool)).releaseHeap(TransactionHandleRegistry.ACTIVE_TRANSACTION_SHALLOW_SIZE);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{memoryPool});
    }

    @Test
    void shouldProvideInterruptHandlerForSuspendedTransaction() throws TransactionLifecycleException {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        FakeClock clock = Clocks.fakeClock();
        MemoryPool memoryPool = (MemoryPool)Mockito.mock(MemoryPool.class);
        int timeoutLength = 123;
        TransactionHandleRegistry registry = new TransactionHandleRegistry((Clock)clock, Duration.ofMillis(timeoutLength), (LogProvider)logProvider, memoryPool);
        TransactionHandle handle = (TransactionHandle)Mockito.mock(TransactionHandle.class);
        long id = registry.begin(handle);
        registry.release(id, handle);
        registry.terminate(id);
        ((TransactionHandle)Mockito.verify((Object)handle)).terminate();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{handle});
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{memoryPool});
        ((MemoryPool)inOrder.verify((Object)memoryPool)).reserveHeap(TransactionHandleRegistry.ACTIVE_TRANSACTION_SHALLOW_SIZE);
        ((MemoryPool)inOrder.verify((Object)memoryPool)).reserveHeap(TransactionHandleRegistry.SUSPENDED_TRANSACTION_SHALLOW_SIZE);
        ((MemoryPool)inOrder.verify((Object)memoryPool)).releaseHeap(TransactionHandleRegistry.SUSPENDED_TRANSACTION_SHALLOW_SIZE);
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    void gettingInterruptHandlerForUnknownIdShouldThrowErrorInvalidTransactionId() {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        FakeClock clock = Clocks.fakeClock();
        MemoryPool memoryPool = (MemoryPool)Mockito.mock(MemoryPool.class);
        int timeoutLength = 123;
        TransactionHandleRegistry registry = new TransactionHandleRegistry((Clock)clock, Duration.ofMillis(timeoutLength), (LogProvider)logProvider, memoryPool);
        org.junit.jupiter.api.Assertions.assertThrows(InvalidTransactionId.class, () -> registry.terminate(456L));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{memoryPool});
    }
}

