/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher;

import java.time.Clock;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.neo4j.bolt.dbapi.BoltGraphDatabaseManagementServiceSPI;
import org.neo4j.bolt.transaction.TransactionManager;
import org.neo4j.common.DependencyResolver;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.api.DatabaseNotFoundException;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.LogProvider;
import org.neo4j.memory.MemoryPool;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.server.http.cypher.TransactionFacade;
import org.neo4j.server.http.cypher.TransactionHandleRegistry;

public class HttpTransactionManager {
    private final TransactionHandleRegistry transactionRegistry;
    private final DatabaseManagementService managementService;
    private final JobScheduler jobScheduler;
    private final TransactionManager transactionManager;
    private final BoltGraphDatabaseManagementServiceSPI boltSPI;
    private final LogProvider userLogProvider;
    private final MemoryPool memoryPool;
    private final AuthManager authManager;
    private final Clock clock;
    private final boolean readByDefault;

    public HttpTransactionManager(DatabaseManagementService managementService, MemoryPool memoryPool, JobScheduler jobScheduler, Clock clock, Duration transactionTimeout, LogProvider userLogProvider, TransactionManager transactionManager, BoltGraphDatabaseManagementServiceSPI boltSPI, AuthManager authManager, boolean readByDefault) {
        this.managementService = managementService;
        this.jobScheduler = jobScheduler;
        this.transactionManager = transactionManager;
        this.boltSPI = boltSPI;
        this.userLogProvider = userLogProvider;
        this.memoryPool = memoryPool;
        this.authManager = authManager;
        this.clock = clock;
        this.readByDefault = readByDefault;
        this.transactionRegistry = new TransactionHandleRegistry(clock, transactionTimeout, userLogProvider, memoryPool);
        this.scheduleTransactionTimeout(transactionTimeout);
    }

    public Optional<GraphDatabaseAPI> getGraphDatabaseAPI(String databaseName) {
        Optional<GraphDatabaseAPI> database;
        try {
            database = Optional.of((GraphDatabaseAPI)this.managementService.database(databaseName));
        }
        catch (DatabaseNotFoundException e) {
            database = Optional.empty();
        }
        return database;
    }

    public TransactionHandleRegistry getTransactionHandleRegistry() {
        return this.transactionRegistry;
    }

    public TransactionFacade createTransactionFacade(GraphDatabaseAPI databaseAPI, MemoryTracker memoryTracker, String databaseName) {
        DependencyResolver dependencyResolver = databaseAPI.getDependencyResolver();
        memoryTracker.allocateHeap(TransactionFacade.SHALLOW_SIZE);
        return new TransactionFacade(databaseName, (QueryExecutionEngine)dependencyResolver.resolveDependency(QueryExecutionEngine.class), this.transactionRegistry, this.transactionManager, this.userLogProvider, this.boltSPI, this.authManager, this.readByDefault);
    }

    private void scheduleTransactionTimeout(Duration timeout) {
        long timeoutMillis = timeout.toMillis();
        long runEvery = Math.round((double)timeoutMillis / 2.0);
        this.jobScheduler.scheduleRecurring(Group.SERVER_TRANSACTION_TIMEOUT, JobMonitoringParams.systemJob((String)"Timeout of HTTP transactions"), () -> {
            long maxAge = this.clock.millis() - timeoutMillis;
            this.transactionRegistry.rollbackSuspendedTransactionsIdleSince(maxAge);
        }, runEvery, TimeUnit.MILLISECONDS);
    }
}

