/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher;

import io.netty.channel.Channel;
import io.netty.channel.embedded.EmbeddedChannel;
import java.net.URI;
import java.time.Clock;
import java.time.Duration;
import java.util.Collections;
import java.util.UUID;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.dbapi.BoltGraphDatabaseManagementServiceSPI;
import org.neo4j.bolt.runtime.statemachine.BoltStateMachine;
import org.neo4j.bolt.runtime.statemachine.BoltStateMachineSPI;
import org.neo4j.bolt.runtime.statemachine.MutableConnectionState;
import org.neo4j.bolt.runtime.statemachine.StatementMetadata;
import org.neo4j.bolt.runtime.statemachine.StatementProcessorReleaseManager;
import org.neo4j.bolt.runtime.statemachine.TransactionStateMachineSPIProvider;
import org.neo4j.bolt.runtime.statemachine.impl.BoltStateMachineContextImpl;
import org.neo4j.bolt.runtime.statemachine.impl.BoltStateMachineSPIImpl;
import org.neo4j.bolt.runtime.statemachine.impl.StatementProcessorProvider;
import org.neo4j.bolt.security.auth.Authentication;
import org.neo4j.bolt.security.auth.BasicAuthentication;
import org.neo4j.bolt.transaction.CleanUpTransactionContext;
import org.neo4j.bolt.transaction.InitializeContext;
import org.neo4j.bolt.transaction.ProgramResultReference;
import org.neo4j.bolt.transaction.TransactionManager;
import org.neo4j.bolt.transaction.TransactionNotFoundException;
import org.neo4j.bolt.transport.pipeline.ChannelProtector;
import org.neo4j.bolt.v41.messaging.RoutingContext;
import org.neo4j.bolt.v43.BoltStateMachineV43;
import org.neo4j.bolt.v44.runtime.TransactionStateMachineSPIProviderV44;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.database.DefaultDatabaseResolver;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.SimpleLogService;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.server.http.cypher.TransactionRegistry;
import org.neo4j.server.http.cypher.TransactionTerminationHandle;
import org.neo4j.server.http.cypher.format.api.Statement;
import org.neo4j.server.http.cypher.format.api.TransactionUriScheme;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.values.virtual.MapValue;

public class TransactionHandle
implements TransactionTerminationHandle {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(TransactionHandle.class);
    private final String databaseName;
    private final QueryExecutionEngine engine;
    private final TransactionRegistry registry;
    private final TransactionUriScheme uriScheme;
    private final TransactionManager transactionManager;
    private final KernelTransaction.Type type;
    private final Duration customTransactionTimeout;
    private final long id;
    private long expirationTimestamp = -1L;
    private final LogProvider userLogProvider;
    private final BoltGraphDatabaseManagementServiceSPI boltSPI;
    private String txManagerTxId;
    LoginContext loginContext;
    private final ClientConnectionInfo clientConnectionInfo;
    MemoryTracker memoryTracker;
    AuthManager authManager;
    private final SystemNanoClock clock;
    private final boolean readByDefault;

    TransactionHandle(String databaseName, QueryExecutionEngine engine, TransactionRegistry registry, TransactionUriScheme uriScheme, boolean implicitTransaction, LoginContext loginContext, ClientConnectionInfo clientConnectionInfo, long customTransactionTimeoutMillis, TransactionManager transactionManager, LogProvider logProvider, BoltGraphDatabaseManagementServiceSPI boltSPI, MemoryTracker memoryTracker, AuthManager authManager, SystemNanoClock clock, boolean readByDefault) {
        this.databaseName = databaseName;
        this.engine = engine;
        this.registry = registry;
        this.uriScheme = uriScheme;
        this.type = implicitTransaction ? KernelTransaction.Type.IMPLICIT : KernelTransaction.Type.EXPLICIT;
        this.customTransactionTimeout = customTransactionTimeoutMillis != 0L ? Duration.ofMillis(customTransactionTimeoutMillis) : null;
        this.id = registry.begin(this);
        this.transactionManager = transactionManager;
        this.userLogProvider = logProvider;
        this.boltSPI = boltSPI;
        this.loginContext = loginContext;
        this.clientConnectionInfo = clientConnectionInfo;
        this.memoryTracker = memoryTracker;
        this.authManager = authManager;
        this.clock = clock;
        this.readByDefault = readByDefault;
        this.setUpStatementProcessor();
    }

    URI uri() {
        return this.uriScheme.txUri(this.id);
    }

    boolean isImplicit() {
        return this.type == KernelTransaction.Type.IMPLICIT;
    }

    long getExpirationTimestamp() {
        return this.expirationTimestamp;
    }

    long getId() {
        return this.id;
    }

    @Override
    public boolean terminate() {
        this.transactionManager.interrupt(this.txManagerTxId);
        return true;
    }

    boolean isPeriodicCommit(String statement) {
        return this.engine.isPeriodicCommit(statement);
    }

    void ensureActiveTransaction() throws KernelException {
        if (this.txManagerTxId == null) {
            this.beginTransaction();
        }
    }

    StatementMetadata executeStatement(Statement statement, boolean periodicCommit) throws KernelException, TransactionNotFoundException {
        if (periodicCommit) {
            ProgramResultReference programResultReference = this.transactionManager.runProgram(UUID.randomUUID().toString(), this.loginContext, this.databaseName, statement.getStatement(), ValueUtils.asParameterMapValue(statement.getParameters()), Collections.emptyList(), this.readByDefault, Collections.emptyMap(), this.customTransactionTimeout, Long.toString(this.id));
            this.txManagerTxId = programResultReference.transactionId();
            return programResultReference.statementMetadata();
        }
        return this.transactionManager.runQuery(this.txManagerTxId, statement.getStatement(), ValueUtils.asParameterMapValue(statement.getParameters()));
    }

    void forceRollback() throws TransactionNotFoundException {
        this.transactionManager.rollback(this.txManagerTxId);
    }

    void suspendTransaction() {
        this.expirationTimestamp = this.registry.release(this.id, this);
    }

    void commit() throws KernelException, TransactionNotFoundException {
        try {
            this.transactionManager.commit(this.txManagerTxId);
        }
        finally {
            this.transactionManager.cleanUp(new CleanUpTransactionContext(this.txManagerTxId));
            this.registry.forget(this.id);
        }
    }

    void rollback() {
        try {
            this.transactionManager.rollback(this.txManagerTxId);
        }
        catch (TransactionNotFoundException transactionNotFoundException) {
        }
        finally {
            this.registry.forget(this.id);
            this.transactionManager.cleanUp(new CleanUpTransactionContext(Long.toString(this.id)));
        }
    }

    boolean hasTransactionContext() {
        return this.txManagerTxId != null;
    }

    void closeTransactionForPeriodicCommit() throws TransactionNotFoundException {
        this.transactionManager.rollback(this.txManagerTxId);
    }

    void reopenAfterPeriodicCommit() throws KernelException {
        this.beginTransaction();
    }

    private void setUpStatementProcessor() {
        DummyBoltChannel boltChannel = new DummyBoltChannel(Long.toString(this.id), this.clientConnectionInfo);
        TransactionStateMachineSPIProviderV44 transactionStateMachineSPIProvider = new TransactionStateMachineSPIProviderV44(this.boltSPI, (BoltChannel)boltChannel, this.clock, this.memoryTracker);
        BoltStateMachineSPIImpl boltStateMachineSPI = new BoltStateMachineSPIImpl((LogService)new SimpleLogService(this.userLogProvider), (Authentication)new BasicAuthentication(this.authManager), (TransactionStateMachineSPIProvider)transactionStateMachineSPIProvider, (BoltChannel)boltChannel);
        BoltStateMachineV43 boltStateMachine = new BoltStateMachineV43((BoltStateMachineSPI)boltStateMachineSPI, (BoltChannel)boltChannel, (Clock)this.clock, this.fixedHttpDatabaseResolver(), MapValue.EMPTY, this.memoryTracker, this.transactionManager);
        BoltStateMachineContextImpl statementProcessorReleaseManager = new BoltStateMachineContextImpl((BoltStateMachine)boltStateMachine, (BoltChannel)boltChannel, (BoltStateMachineSPI)boltStateMachineSPI, new MutableConnectionState(), (Clock)this.clock, this.fixedHttpDatabaseResolver(), this.memoryTracker, this.transactionManager);
        StatementProcessorProvider statementProcessorProvider = new StatementProcessorProvider((TransactionStateMachineSPIProvider)transactionStateMachineSPIProvider, (Clock)this.clock, (StatementProcessorReleaseManager)statementProcessorReleaseManager, new RoutingContext(true, Collections.emptyMap()), this.memoryTracker);
        this.transactionManager.initialize(new InitializeContext(Long.toString(this.getId()), statementProcessorProvider));
    }

    private DefaultDatabaseResolver fixedHttpDatabaseResolver() {
        return new DefaultDatabaseResolver(){

            public String defaultDatabase(String ignored) {
                return TransactionHandle.this.databaseName;
            }

            public void clearCache() {
            }
        };
    }

    public void beginTransaction() throws KernelException {
        this.txManagerTxId = this.transactionManager.begin(this.loginContext, this.databaseName, Collections.emptyList(), this.readByDefault, Collections.emptyMap(), this.customTransactionTimeout, Long.toString(this.id));
    }

    public TransactionManager transactionManager() {
        return this.transactionManager;
    }

    public String getTxManagerTxId() {
        return this.txManagerTxId;
    }

    private class DummyBoltChannel
    extends BoltChannel {
        private final ClientConnectionInfo info;

        DummyBoltChannel(String id, ClientConnectionInfo info) {
            super(id, info.protocol(), (Channel)new EmbeddedChannel(), ChannelProtector.NULL);
            this.info = info;
        }

        public ClientConnectionInfo info() {
            return this.info;
        }
    }
}

