/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.discovery;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.core.Variant;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.connectors.ConnectorPortRegister;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.helpers.HostnamePort;
import org.neo4j.server.config.AuthConfigProvider;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.rest.discovery.CommunityDiscoverableURIs;
import org.neo4j.server.rest.discovery.DiscoveryService;
import org.neo4j.server.rest.discovery.ServerVersionAndEdition;
import org.neo4j.server.rest.repr.CommunityAuthConfigProvider;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationBasedMessageBodyWriter;

public class DiscoveryServiceTest {
    private final ConnectorPortRegister portRegistry = (ConnectorPortRegister)Mockito.mock(ConnectorPortRegister.class);
    private URI baseUri;
    private URI dbUri;
    private Consumer<ConnectorPortRegister> portRegistryOverrider;
    private Consumer<Config.Builder> configOverrider;
    private String expectedDatabaseUri;
    private String expectedBoltUri;
    private RepresentationBasedMessageBodyWriter outputFormat;

    private static Stream<Arguments> argumentsProvider() {
        ArrayList<Arguments> cases = new ArrayList<Arguments>();
        cases.add(Arguments.of((Object[])new Object[]{"http://localhost:7474", "http://localhost:7474", null, null, "bolt://localhost:7687"}));
        cases.add(Arguments.of((Object[])new Object[]{"https://localhost:7473", "https://localhost:7473", null, null, "bolt://localhost:7687"}));
        cases.add(Arguments.of((Object[])new Object[]{"http://www.example.com", "http://www.example.com", null, null, "bolt://www.example.com:7687"}));
        cases.add(Arguments.of((Object[])new Object[]{"http://localhost:7474 - 0.0.0.0", "http://localhost:7474", null, DiscoveryServiceTest.overrideWithDefaultListenAddress("0.0.0.0"), "bolt://localhost:7687"}));
        cases.add(Arguments.of((Object[])new Object[]{"https://localhost:7473 - 0.0.0.0", "https://localhost:7473", null, DiscoveryServiceTest.overrideWithDefaultListenAddress("0.0.0.0"), "bolt://localhost:7687"}));
        cases.add(Arguments.of((Object[])new Object[]{"http://www.example.com - 0.0.0.0", "http://www.example.com", null, DiscoveryServiceTest.overrideWithDefaultListenAddress("0.0.0.0"), "bolt://www.example.com:7687"}));
        cases.add(Arguments.of((Object[])new Object[]{"http://localhost:7474 - ::", "http://localhost:7474", null, DiscoveryServiceTest.overrideWithDefaultListenAddress("::"), "bolt://localhost:7687"}));
        cases.add(Arguments.of((Object[])new Object[]{"https://localhost:7473 - ::", "https://localhost:7473", null, DiscoveryServiceTest.overrideWithDefaultListenAddress("::"), "bolt://localhost:7687"}));
        cases.add(Arguments.of((Object[])new Object[]{"http://www.example.com - ::", "http://www.example.com", null, DiscoveryServiceTest.overrideWithDefaultListenAddress("::"), "bolt://www.example.com:7687"}));
        cases.add(Arguments.of((Object[])new Object[]{"http://localhost:7474 - [::]:8888", "http://localhost:7474", null, DiscoveryServiceTest.combineConfigOverriders(DiscoveryServiceTest.overrideWithDefaultListenAddress("::"), DiscoveryServiceTest.overrideWithListenAddress("::", 8888)), "bolt://localhost:8888"}));
        cases.add(Arguments.of((Object[])new Object[]{"https://localhost:7473 - [::]:8888", "https://localhost:7473", null, DiscoveryServiceTest.combineConfigOverriders(DiscoveryServiceTest.overrideWithDefaultListenAddress("::"), DiscoveryServiceTest.overrideWithListenAddress("::", 8888)), "bolt://localhost:8888"}));
        cases.add(Arguments.of((Object[])new Object[]{"http://www.example.com - [::]:8888", "http://www.example.com", null, DiscoveryServiceTest.combineConfigOverriders(DiscoveryServiceTest.overrideWithDefaultListenAddress("::"), DiscoveryServiceTest.overrideWithListenAddress("::", 8888)), "bolt://www.example.com:8888"}));
        cases.add(Arguments.of((Object[])new Object[]{"http://www.example.com (advertised 1)", "http://www.example.com", null, DiscoveryServiceTest.overrideWithAdvertisedAddress("www.example.com", 8898), "bolt://www.example.com:8898"}));
        cases.add(Arguments.of((Object[])new Object[]{"http://www.example.com (advertised 2)", "http://www.example.com", null, DiscoveryServiceTest.overrideWithAdvertisedAddress("www2.example.com", 7576), "bolt://www2.example.com:7576"}));
        cases.add(Arguments.of((Object[])new Object[]{"http://www.example.com (advertised 3)", "http://www.example.com", DiscoveryServiceTest.register("bolt", "localhost", 9999), DiscoveryServiceTest.overrideWithAdvertisedAddress("www2.example.com", 0), "bolt://www2.example.com:9999"}));
        cases.add(Arguments.of((Object[])new Object[]{"http://www.example.com (discoverable 1)", "http://www.example.com", null, DiscoveryServiceTest.overrideWithDiscoverable("bolt://www.notanexample.com:7777"), "bolt://www.notanexample.com:7777"}));
        cases.add(Arguments.of((Object[])new Object[]{"http://www.example.com (discoverable 2)", "http://www.example.com", null, DiscoveryServiceTest.overrideWithDiscoverable("something://www.notanexample.com:7777"), "something://www.notanexample.com:7777"}));
        cases.add(Arguments.of((Object[])new Object[]{"http://www.example.com (discoverable and advertised 1)", "http://www.example.com", null, DiscoveryServiceTest.combineConfigOverriders(DiscoveryServiceTest.overrideWithDiscoverable("bolt://www.notanexample.com:7777"), DiscoveryServiceTest.overrideWithAdvertisedAddress("www.notanexample2.com", 8888)), "bolt://www.notanexample.com:7777"}));
        cases.add(Arguments.of((Object[])new Object[]{"http://www.example.com (discoverable and advertised 2)", "http://www.example.com", null, DiscoveryServiceTest.combineConfigOverriders(DiscoveryServiceTest.overrideWithAdvertisedAddress("www.notanexample2.com", 8888), DiscoveryServiceTest.overrideWithDiscoverable("bolt://www.notanexample.com:7777")), "bolt://www.notanexample.com:7777"}));
        return cases.stream();
    }

    public void init(String description, String baseUri, Consumer<ConnectorPortRegister> portRegistryOverrider, Consumer<Config.Builder> configOverrider, String expectedBoltUri) throws URISyntaxException {
        this.baseUri = new URI(baseUri);
        this.dbUri = new URI("/db");
        this.portRegistryOverrider = portRegistryOverrider;
        this.configOverrider = configOverrider;
        this.expectedDatabaseUri = this.baseUri.resolve(this.dbUri).toString();
        this.expectedBoltUri = expectedBoltUri;
        if (portRegistryOverrider != null) {
            portRegistryOverrider.accept(this.portRegistry);
        } else {
            Mockito.when((Object)this.portRegistry.getLocalAddress("bolt")).thenReturn((Object)new HostnamePort("localhost", 7687));
        }
        DependencyResolver dependencyResolver = (DependencyResolver)Mockito.mock(DependencyResolver.class);
        Mockito.when((Object)((ConnectorPortRegister)dependencyResolver.resolveDependency(ConnectorPortRegister.class))).thenReturn((Object)this.portRegistry);
        this.outputFormat = new RepresentationBasedMessageBodyWriter(DiscoveryServiceTest.uriInfo(this.baseUri));
    }

    private Config mockConfig() {
        Config.Builder builder = Config.newBuilder().set(GraphDatabaseSettings.auth_enabled, (Object)false).set(BoltConnector.enabled, (Object)true).set(ServerSettings.db_api_path, (Object)this.dbUri);
        if (this.configOverrider != null) {
            this.configOverrider.accept(builder);
        }
        return builder.build();
    }

    private DiscoveryService testDiscoveryService() {
        Config config = this.mockConfig();
        return new DiscoveryService(config, CommunityDiscoverableURIs.communityDiscoverableURIs((Config)config, (ConnectorPortRegister)this.portRegistry, null), (ServerVersionAndEdition)Mockito.mock(ServerVersionAndEdition.class), (AuthConfigProvider)new CommunityAuthConfigProvider());
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldReturnValidJSON(String description, String baseUri, Consumer<ConnectorPortRegister> portRegistryOverrider, Consumer<Config.Builder> configOverrider, String expectedBoltUri) throws Exception {
        this.init(description, baseUri, portRegistryOverrider, configOverrider, expectedBoltUri);
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.selectVariant(ArgumentMatchers.anyList())).thenReturn((Object)((Variant)Variant.mediaTypes((MediaType[])new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).build().get(0)));
        Response response = this.testDiscoveryService().get(request, DiscoveryServiceTest.uriInfo(this.baseUri));
        String json = this.getJsonString(response);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)json);
        Assertions.assertThat((int)json.length()).isGreaterThan(0);
        Assertions.assertThat((String)json).isNotEqualTo((Object)"\"\"");
        Assertions.assertThat((String)json).isNotEqualTo((Object)"null");
    }

    private static UriInfo uriInfo(URI baseUri) {
        UriInfo uriInfo = (UriInfo)Mockito.mock(UriInfo.class);
        Mockito.when((Object)uriInfo.getBaseUri()).thenReturn((Object)baseUri);
        return uriInfo;
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldReturnBoltDirectURI(String description, String baseUri, Consumer<ConnectorPortRegister> portRegistryOverrider, Consumer<Config.Builder> configOverrider, String expectedBoltUri) throws Exception {
        this.init(description, baseUri, portRegistryOverrider, configOverrider, expectedBoltUri);
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.selectVariant(ArgumentMatchers.anyList())).thenReturn((Object)((Variant)Variant.mediaTypes((MediaType[])new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).build().get(0)));
        Response response = this.testDiscoveryService().get(request, DiscoveryServiceTest.uriInfo(this.baseUri));
        String json = this.getJsonString(response);
        Assertions.assertThat((String)json).contains(new CharSequence[]{"\"bolt_direct\" : \"" + expectedBoltUri});
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldReturnTxURI(String description, String baseUri, Consumer<ConnectorPortRegister> portRegistryOverrider, Consumer<Config.Builder> configOverrider, String expectedBoltUri) throws Exception {
        this.init(description, baseUri, portRegistryOverrider, configOverrider, expectedBoltUri);
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.selectVariant(ArgumentMatchers.anyList())).thenReturn((Object)((Variant)Variant.mediaTypes((MediaType[])new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).build().get(0)));
        Response response = this.testDiscoveryService().get(request, DiscoveryServiceTest.uriInfo(this.baseUri));
        String json = this.getJsonString(response);
        Assertions.assertThat((String)json).contains(new CharSequence[]{"\"transaction\" : \"" + this.expectedDatabaseUri + "/"});
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldNotReturnManagementURI(String description, String baseUri, Consumer<ConnectorPortRegister> portRegistryOverrider, Consumer<Config.Builder> configOverrider, String expectedBoltUri) throws Exception {
        this.init(description, baseUri, portRegistryOverrider, configOverrider, expectedBoltUri);
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.selectVariant(ArgumentMatchers.anyList())).thenReturn((Object)((Variant)Variant.mediaTypes((MediaType[])new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).build().get(0)));
        Response response = this.testDiscoveryService().get(request, DiscoveryServiceTest.uriInfo(this.baseUri));
        String json = this.getJsonString(response);
        Assertions.assertThat((String)json).doesNotContain(new CharSequence[]{"\"management\""});
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"argumentsProvider"})
    public void shouldReturnRedirectToAbsoluteAPIUsingOutputFormat(String description, String baseUri, Consumer<ConnectorPortRegister> portRegistryOverrider, Consumer<Config.Builder> configOverrider, String expectedBoltUri) throws Exception {
        this.init(description, baseUri, portRegistryOverrider, configOverrider, expectedBoltUri);
        Config config = Config.defaults((Setting)ServerSettings.browser_path, (Object)URI.create("/browser/"));
        baseUri = "http://www.example.com:5435";
        DiscoveryService ds = new DiscoveryService(config, CommunityDiscoverableURIs.communityDiscoverableURIs((Config)config, null, null), (ServerVersionAndEdition)Mockito.mock(ServerVersionAndEdition.class), (AuthConfigProvider)Mockito.mock(AuthConfigProvider.class));
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.selectVariant(ArgumentMatchers.anyList())).thenReturn((Object)((Variant)Variant.mediaTypes((MediaType[])new MediaType[]{MediaType.TEXT_HTML_TYPE}).build().get(0)));
        Response response = ds.get(request, DiscoveryServiceTest.uriInfo(new URI(baseUri)));
        Assertions.assertThat((Object)response.getMetadata().getFirst((Object)"Location")).isEqualTo((Object)new URI("http://www.example.com:5435/browser/"));
    }

    private String getJsonString(Response response) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.outputFormat.writeTo((Representation)response.getEntity(), Representation.class, null, null, MediaType.APPLICATION_JSON_TYPE, null, (OutputStream)out);
        return out.toString(StandardCharsets.UTF_8);
    }

    private static Consumer<ConnectorPortRegister> register(String connector, String host, int port) {
        return register -> Mockito.when((Object)register.getLocalAddress(connector)).thenReturn((Object)new HostnamePort(host, port));
    }

    private static Consumer<Config.Builder> overrideWithAdvertisedAddress(String host, int port) {
        return builder -> builder.set(BoltConnector.advertised_address, (Object)new SocketAddress(host, port));
    }

    private static Consumer<Config.Builder> overrideWithListenAddress(String host, int port) {
        return builder -> {
            builder.set(BoltConnector.listen_address, (Object)new SocketAddress(host, port));
            builder.setDefault(BoltConnector.advertised_address, (Object)new SocketAddress(port));
        };
    }

    private static Consumer<Config.Builder> overrideWithDefaultListenAddress(String host) {
        return builder -> builder.set(GraphDatabaseSettings.default_listen_address, (Object)new SocketAddress(host));
    }

    private static Consumer<Config.Builder> overrideWithDiscoverable(String uri) {
        return builder -> builder.set(ServerSettings.bolt_discoverable_address, (Object)URI.create(uri));
    }

    @SafeVarargs
    private static Consumer<Config.Builder> combineConfigOverriders(Consumer<Config.Builder> ... overriders) {
        return config -> {
            for (Consumer overrider : overriders) {
                overrider.accept(config);
            }
        };
    }
}

