/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher;

import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.neo4j.configuration.Config;
import org.neo4j.logging.Log;
import org.neo4j.memory.MemoryPool;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.http.cypher.AbstractCypherResource;
import org.neo4j.server.http.cypher.HttpTransactionManager;
import org.neo4j.time.SystemNanoClock;

@Path(value="/{databaseName}/tx")
public class CypherResource
extends AbstractCypherResource {
    public static final String NAME = "transaction";
    private static final String DB_PATH_PARAM_NAME = "databaseName";
    private static final String TRANSACTION_PATH_FRAGMENT = "tx";
    static final String DB_TRANSACTION_PATH = "/{databaseName}/tx";

    public CypherResource(@Context HttpTransactionManager httpTransactionManager, @Context UriInfo uriInfo, @Context MemoryPool memoryPool, @Context Log log, @Context HttpHeaders headers, @Context HttpServletRequest request, @PathParam(value="databaseName") String databaseName, @Context SystemNanoClock clock) {
        super(httpTransactionManager, uriInfo, memoryPool, log, databaseName, clock);
    }

    @Override
    protected URI dbUri(UriInfo uriInfo, String databaseName) {
        UriBuilder builder = uriInfo.getBaseUriBuilder().path(databaseName);
        return builder.build(new Object[0]);
    }

    @Override
    protected URI cypherUri(UriInfo uriInfo, String databaseName) {
        UriBuilder builder = uriInfo.getBaseUriBuilder().path(databaseName);
        return builder.path(TRANSACTION_PATH_FRAGMENT).build(new Object[0]);
    }

    public static String absoluteDatabaseTransactionPath(Config config) {
        return ((URI)config.get(ServerSettings.db_api_path)).getPath() + DB_TRANSACTION_PATH;
    }
}

