/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.entity;

import java.util.function.Function;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.IntValue;
import org.neo4j.values.virtual.MapValue;

public class HttpQueryStatistics
implements QueryStatistics {
    private final int createdNodes;
    private final int deletedNodes;
    private final int createdRelationships;
    private final int deletedRelationships;
    private final int setProperties;
    private final int addedLabels;
    private final int removedLabels;
    private final int addedIndexes;
    private final int removedIndexes;
    private final int addedConstraints;
    private final int removedConstraints;
    private final int systemUpdates;
    private final boolean containsUpdates;
    private final boolean containsSystemUpdates;

    private HttpQueryStatistics(int createdNodes, int deletedNodes, int createdRelationships, int deletedRelationships, int setProperties, int addedLabels, int removedLabels, int addedIndexes, int removedIndexes, int addedConstraints, int removedConstraints, int systemUpdates, boolean containsUpdates, boolean containsSystemUpdates) {
        this.createdNodes = createdNodes;
        this.deletedNodes = deletedNodes;
        this.createdRelationships = createdRelationships;
        this.deletedRelationships = deletedRelationships;
        this.setProperties = setProperties;
        this.addedLabels = addedLabels;
        this.removedLabels = removedLabels;
        this.addedIndexes = addedIndexes;
        this.removedIndexes = removedIndexes;
        this.addedConstraints = addedConstraints;
        this.removedConstraints = removedConstraints;
        this.systemUpdates = systemUpdates;
        this.containsUpdates = containsUpdates;
        this.containsSystemUpdates = containsSystemUpdates;
    }

    public static QueryStatistics fromAnyValue(AnyValue anyValue) {
        if (anyValue == null) {
            return QueryStatistics.EMPTY;
        }
        MapValue queryStatsMap = (MapValue)anyValue;
        return new HttpQueryStatistics(HttpQueryStatistics.extractIntIfPresent(queryStatsMap, "nodes-created"), HttpQueryStatistics.extractIntIfPresent(queryStatsMap, "nodes-deleted"), HttpQueryStatistics.extractIntIfPresent(queryStatsMap, "relationships-created"), HttpQueryStatistics.extractIntIfPresent(queryStatsMap, "relationships-deleted"), HttpQueryStatistics.extractIntIfPresent(queryStatsMap, "properties-set"), HttpQueryStatistics.extractIntIfPresent(queryStatsMap, "labels-added"), HttpQueryStatistics.extractIntIfPresent(queryStatsMap, "labels-removed"), HttpQueryStatistics.extractIntIfPresent(queryStatsMap, "indexes-added"), HttpQueryStatistics.extractIntIfPresent(queryStatsMap, "indexes-removed"), HttpQueryStatistics.extractIntIfPresent(queryStatsMap, "constraints-added"), HttpQueryStatistics.extractIntIfPresent(queryStatsMap, "constraints-removed"), HttpQueryStatistics.extractIntIfPresent(queryStatsMap, "system-updates"), HttpQueryStatistics.extractBooleanIfPresent(queryStatsMap, "contains-updates"), HttpQueryStatistics.extractBooleanIfPresent(queryStatsMap, "contains-system-updates"));
    }

    public int getNodesCreated() {
        return this.createdNodes;
    }

    public int getNodesDeleted() {
        return this.deletedNodes;
    }

    public int getRelationshipsCreated() {
        return this.createdRelationships;
    }

    public int getRelationshipsDeleted() {
        return this.deletedRelationships;
    }

    public int getPropertiesSet() {
        return this.setProperties;
    }

    public int getLabelsAdded() {
        return this.addedLabels;
    }

    public int getLabelsRemoved() {
        return this.removedLabels;
    }

    public int getIndexesAdded() {
        return this.addedIndexes;
    }

    public int getIndexesRemoved() {
        return this.removedIndexes;
    }

    public int getConstraintsAdded() {
        return this.addedConstraints;
    }

    public int getConstraintsRemoved() {
        return this.removedConstraints;
    }

    public int getSystemUpdates() {
        return this.systemUpdates;
    }

    public boolean containsUpdates() {
        return this.containsUpdates;
    }

    public boolean containsSystemUpdates() {
        return this.containsSystemUpdates;
    }

    private static <T> T extractIfPresent(MapValue queryStatsMap, String queryStatLabel, T defaultValue, Function<AnyValue, T> mapperFunction) {
        if (queryStatsMap.containsKey(queryStatLabel)) {
            return mapperFunction.apply(queryStatsMap.get(queryStatLabel));
        }
        return defaultValue;
    }

    private static int extractIntIfPresent(MapValue queryStatsMap, String queryStatLabel) {
        return HttpQueryStatistics.extractIfPresent(queryStatsMap, queryStatLabel, 0, v -> ((IntValue)v).value());
    }

    private static boolean extractBooleanIfPresent(MapValue queryStatsMap, String queryStatLabel) {
        return HttpQueryStatistics.extractIfPresent(queryStatsMap, queryStatLabel, false, v -> ((BooleanValue)v).booleanValue());
    }
}

