/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.error;

import java.util.Collections;
import java.util.List;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.server.rest.Neo4jError;

public class Neo4jHttpException
extends RuntimeException {
    private final int httpStatus;
    private final List<Neo4jError> neo4jErrors;

    public Neo4jHttpException(int httpStatus, List<Neo4jError> neo4jErrors) {
        this.httpStatus = httpStatus;
        this.neo4jErrors = neo4jErrors;
    }

    public Neo4jHttpException(int httpStatus, Status status, Throwable cause) {
        this.httpStatus = httpStatus;
        Neo4jError neo4jError = new Neo4jError(status, cause);
        this.neo4jErrors = Collections.singletonList(neo4jError);
    }

    public Neo4jHttpException(int httpStatus, Status status, String message) {
        this.httpStatus = httpStatus;
        Neo4jError neo4jError = new Neo4jError(status, message);
        this.neo4jErrors = Collections.singletonList(neo4jError);
    }

    public int getHttpStatus() {
        return this.httpStatus;
    }

    public List<Neo4jError> getNeo4jErrors() {
        return this.neo4jErrors;
    }
}

