/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr.formats;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.ws.rs.core.MediaType;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.repr.ListWriter;
import org.neo4j.server.rest.repr.MappingWriter;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.formats.ListWrappingWriter;
import org.neo4j.server.rest.repr.formats.MapWrappingWriter;

public class JsonFormat
extends RepresentationFormat {
    public JsonFormat() {
        super(MediaType.APPLICATION_JSON_TYPE);
    }

    protected ListWriter serializeList(String type) {
        return new ListWrappingWriter(new ArrayList<Object>());
    }

    protected String complete(ListWriter serializer) {
        return JsonHelper.createJsonFrom(((ListWrappingWriter)serializer).data);
    }

    protected MappingWriter serializeMapping(String type) {
        return new MapWrappingWriter(new LinkedHashMap<String, Object>());
    }

    protected String complete(MappingWriter serializer) {
        return JsonHelper.createJsonFrom(((MapWrappingWriter)serializer).data);
    }

    protected String serializeValue(String type, Object value) {
        return JsonHelper.createJsonFrom(value);
    }
}

