/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher;

import java.security.Principal;
import java.time.Clock;
import java.time.Duration;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.bolt.dbapi.BoltGraphDatabaseManagementServiceSPI;
import org.neo4j.bolt.transaction.TransactionManager;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.database.DefaultDatabaseResolver;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.memory.MemoryPool;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.server.http.cypher.HttpTransactionManager;
import org.neo4j.server.http.cypher.LegacyTransactionService;
import org.neo4j.time.Clocks;

class LegacyTransactionServiceTest {
    private HttpServletRequest request;
    private DefaultDatabaseResolver databaseResolver;
    private HttpTransactionManager httpTransactionManager;
    private UriInfo uriInfo;
    private Log log;

    LegacyTransactionServiceTest() {
    }

    @BeforeEach
    void prepareDependencies() {
        this.request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        this.databaseResolver = (DefaultDatabaseResolver)Mockito.mock(DefaultDatabaseResolver.class);
        this.httpTransactionManager = (HttpTransactionManager)Mockito.spy((Object)new HttpTransactionManager(null, (MemoryPool)Mockito.mock(MemoryPool.class), (JobScheduler)Mockito.mock(JobScheduler.class), Clock.systemUTC(), Duration.ofMinutes(2L), (LogProvider)Mockito.mock(LogProvider.class), (TransactionManager)Mockito.mock(TransactionManager.class), (BoltGraphDatabaseManagementServiceSPI)Mockito.mock(BoltGraphDatabaseManagementServiceSPI.class), (AuthManager)Mockito.mock(AuthManager.class), true));
        this.uriInfo = (UriInfo)Mockito.mock(UriInfo.class);
        this.log = (Log)Mockito.mock(Log.class);
        ((UriInfo)Mockito.doReturn((Object)UriBuilder.fromUri((String)"http://localhost:7474/db/data/transaction")).when((Object)this.uriInfo)).getBaseUriBuilder();
        ((HttpTransactionManager)Mockito.doReturn(Optional.empty()).when((Object)this.httpTransactionManager)).getGraphDatabaseAPI(ArgumentMatchers.anyString());
    }

    @ParameterizedTest
    @CsvSource(value={"neo4j, andy, greg"})
    void shouldSwitchDefaultDatabaseBasedOnAuthenticatedUser(String user) {
        Principal userPrincipalA = (Principal)Mockito.mock(Principal.class);
        Mockito.when((Object)userPrincipalA.getName()).thenReturn((Object)user);
        Mockito.when((Object)this.request.getUserPrincipal()).thenReturn((Object)userPrincipalA);
        Mockito.when((Object)this.databaseResolver.defaultDatabase(ArgumentMatchers.anyString())).thenReturn((Object)"neo4j");
        Mockito.when((Object)this.databaseResolver.defaultDatabase(user)).thenReturn((Object)("db-" + user));
        LegacyTransactionService transactionService = new LegacyTransactionService(this.request, this.databaseResolver, this.httpTransactionManager, this.uriInfo, (MemoryPool)Mockito.mock(MemoryPool.class), this.log, Clocks.nanoClock());
        transactionService.rollbackTransaction(42L);
        ((DefaultDatabaseResolver)Mockito.verify((Object)this.databaseResolver)).defaultDatabase(user);
        ((HttpTransactionManager)Mockito.verify((Object)this.httpTransactionManager)).getGraphDatabaseAPI("db-" + user);
    }
}

