/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher;

import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.bolt.protocol.common.connector.tx.TransactionOwner;
import org.neo4j.bolt.protocol.common.fsm.response.ResponseHandler;
import org.neo4j.bolt.protocol.common.message.AccessMode;
import org.neo4j.bolt.testing.mock.MockResult;
import org.neo4j.bolt.testing.mock.StatementMockFactory;
import org.neo4j.bolt.tx.Transaction;
import org.neo4j.bolt.tx.TransactionManager;
import org.neo4j.bolt.tx.TransactionType;
import org.neo4j.bolt.tx.error.TransactionException;
import org.neo4j.bolt.tx.error.statement.StatementExecutionException;
import org.neo4j.exceptions.SyntaxException;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.query.NotificationConfiguration;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.MemoryPool;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.server.http.cypher.Invocation;
import org.neo4j.server.http.cypher.OutputEventStream;
import org.neo4j.server.http.cypher.RollbackInvocation;
import org.neo4j.server.http.cypher.TransactionHandle;
import org.neo4j.server.http.cypher.TransactionRegistry;
import org.neo4j.server.http.cypher.format.api.ConnectionException;
import org.neo4j.server.http.cypher.format.api.InputEventStream;
import org.neo4j.server.http.cypher.format.api.InputFormatException;
import org.neo4j.server.http.cypher.format.api.Statement;
import org.neo4j.server.http.cypher.format.api.TransactionNotificationState;
import org.neo4j.server.http.cypher.format.api.TransactionUriScheme;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;

class InvocationTest {
    private static final Statement NULL_STATEMENT = null;
    private static final String TX_ID = "123";
    private static final String SERIALIZED_BOOKMARK = "BOOKMARK!";
    private final InternalLog log = (InternalLog)Mockito.mock(InternalLog.class);
    private final TransactionManager transactionManager = (TransactionManager)Mockito.mock(TransactionManager.class);
    private final Transaction transaction = (Transaction)Mockito.mock(Transaction.class);
    private org.neo4j.bolt.tx.statement.Statement statement;
    private final InternalLogProvider logProvider = (InternalLogProvider)Mockito.mock(InternalLogProvider.class);
    private final InternalTransaction internalTransaction = (InternalTransaction)Mockito.mock(InternalTransaction.class);
    private final TransactionRegistry registry = (TransactionRegistry)Mockito.mock(TransactionRegistry.class);
    private final OutputEventStream outputEventStream = (OutputEventStream)Mockito.mock(OutputEventStream.class);
    private final MemoryTracker memoryTracker = (MemoryTracker)Mockito.mock(MemoryTracker.class);
    private final AuthManager authManager = (AuthManager)Mockito.mock(AuthManager.class);
    private final String[] DEFAULT_FIELD_NAMES = new String[]{"c1", "c2", "c3"};
    private static final TransactionUriScheme uriScheme = new TransactionUriScheme(){

        public URI txUri(long id) {
            return URI.create("transaction/" + id);
        }

        public URI txCommitUri(long id) {
            return URI.create("transaction/" + id + "/commit");
        }

        public URI dbUri() {
            return URI.create("data/");
        }
    };

    InvocationTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.statement = this.generateStatementMock();
        Mockito.when((Object)this.transaction.id()).thenReturn((Object)TX_ID);
        Mockito.when((Object)this.transactionManager.create((TransactionType)Mockito.any(TransactionType.class), (TransactionOwner)Mockito.any(TransactionOwner.class), ArgumentMatchers.anyString(), (AccessMode)Mockito.any(AccessMode.class), ArgumentMatchers.anyList(), (Duration)ArgumentMatchers.nullable(Duration.class), ArgumentMatchers.anyMap(), (NotificationConfiguration)ArgumentMatchers.nullable(NotificationConfiguration.class))).thenReturn((Object)this.transaction);
        Mockito.when((Object)this.transaction.run(ArgumentMatchers.anyString(), (MapValue)Mockito.eq((Object)MapValue.EMPTY))).thenReturn((Object)this.statement);
        Mockito.when((Object)this.transaction.commit()).thenReturn((Object)SERIALIZED_BOOKMARK);
    }

    @Test
    void shouldExecuteStatements() throws Throwable {
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)123L);
        TransactionHandle handle = this.getTransactionHandle(this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, (Object[])new Statement[]{NULL_STATEMENT});
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(Long.parseLong(TX_ID)), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        InOrder txManagerOrder = Mockito.inOrder((Object[])new Object[]{this.transactionManager, this.transaction, this.statement, this.registry});
        ((TransactionRegistry)txManagerOrder.verify((Object)this.registry)).begin(handle);
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).create(TransactionType.IMPLICIT, (TransactionOwner)handle, "neo4j", AccessMode.READ, Collections.emptyList(), null, Collections.emptyMap(), null);
        ((Transaction)txManagerOrder.verify((Object)this.transaction)).run("query", MapValue.EMPTY);
        ((org.neo4j.bolt.tx.statement.Statement)txManagerOrder.verify((Object)this.statement)).consume((ResponseHandler)Mockito.any(ResponseHandler.class), Mockito.anyLong());
        ((Transaction)txManagerOrder.verify((Object)this.transaction)).commit();
        ((TransactionRegistry)txManagerOrder.verify((Object)this.registry)).forget(123L);
        ((Transaction)txManagerOrder.verify((Object)this.transaction)).close();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.transactionManager});
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementStart(statement, List.of("c1", "c2", "c3"));
        this.verifyDefaultResultRows(outputOrder);
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementEnd((QueryExecutionType)Mockito.any(), (QueryStatistics)Mockito.any(), (ExecutionPlanDescription)Mockito.any(), (Iterable)Mockito.any());
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.COMMITTED, uriScheme.txCommitUri(123L), -1L, SERIALIZED_BOOKMARK);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldSuspendTransactionAndReleaseForOtherRequestsAfterExecutingStatements() throws Throwable {
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)123L);
        TransactionHandle handle = this.getTransactionHandle(this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, (Object[])new Statement[]{NULL_STATEMENT});
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(123L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, false);
        invocation.execute(this.outputEventStream);
        InOrder transactionOrder = Mockito.inOrder((Object[])new Object[]{this.registry});
        ((TransactionRegistry)transactionOrder.verify((Object)this.registry)).release(123L, handle);
        InOrder txManagerOrder = Mockito.inOrder((Object[])new Object[]{this.transactionManager, this.transaction, this.statement});
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).create(TransactionType.IMPLICIT, (TransactionOwner)handle, "neo4j", AccessMode.READ, Collections.emptyList(), null, Collections.emptyMap(), null);
        ((Transaction)txManagerOrder.verify((Object)this.transaction)).run("query", MapValue.EMPTY);
        ((org.neo4j.bolt.tx.statement.Statement)txManagerOrder.verify((Object)this.statement)).consume((ResponseHandler)Mockito.any(ResponseHandler.class), Mockito.anyLong());
        txManagerOrder.verifyNoMoreInteractions();
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementStart(statement, List.of("c1", "c2", "c3"));
        this.verifyDefaultResultRows(outputOrder);
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementEnd((QueryExecutionType)Mockito.any(), (QueryStatistics)Mockito.any(), (ExecutionPlanDescription)Mockito.any(), (Iterable)Mockito.any());
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.OPEN, uriScheme.txCommitUri(123L), 0L, null);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldResumeTransactionWhenExecutingStatementsOnSecondRequest() throws Throwable {
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)123L);
        TransactionHandle handle = this.getTransactionHandle(this.registry);
        org.neo4j.bolt.tx.statement.Statement statement1 = this.generateStatementMock();
        org.neo4j.bolt.tx.statement.Statement statement2 = this.generateStatementMock();
        Mockito.when((Object)this.transaction.run((String)Mockito.eq((Object)"queryA"), (MapValue)Mockito.eq((Object)MapValue.EMPTY))).thenReturn((Object)statement1);
        Mockito.when((Object)this.transaction.run((String)Mockito.eq((Object)"queryB"), (MapValue)Mockito.eq((Object)MapValue.EMPTY))).thenReturn((Object)statement2);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statementA = new Statement("queryA", MapUtil.map((Object[])new Object[0]));
        Statement statementB = new Statement("queryB", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statementA, (Object[])new Statement[]{NULL_STATEMENT});
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(123L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, false);
        InOrder txManagerOrder = Mockito.inOrder((Object[])new Object[]{this.transactionManager, this.transaction, statement1, statement2, this.registry});
        invocation.execute(this.outputEventStream);
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).create(TransactionType.IMPLICIT, (TransactionOwner)handle, "neo4j", AccessMode.READ, Collections.emptyList(), null, Collections.emptyMap(), null);
        ((Transaction)txManagerOrder.verify((Object)this.transaction)).run("queryA", MapValue.EMPTY);
        ((org.neo4j.bolt.tx.statement.Statement)txManagerOrder.verify((Object)statement1)).consume((ResponseHandler)Mockito.any(ResponseHandler.class), Mockito.anyLong());
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementStart(statementA, List.of("c1", "c2", "c3"));
        this.verifyDefaultResultRows(outputOrder);
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementEnd((QueryExecutionType)Mockito.any(), (QueryStatistics)Mockito.any(), (ExecutionPlanDescription)Mockito.any(), (Iterable)Mockito.any());
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.OPEN, uriScheme.txCommitUri(123L), 0L, null);
        ((TransactionRegistry)txManagerOrder.verify((Object)this.registry)).release(123L, handle);
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statementB, (Object[])new Statement[]{NULL_STATEMENT});
        invocation.execute(this.outputEventStream);
        ((Transaction)txManagerOrder.verify((Object)this.transaction)).run("queryB", MapValue.EMPTY);
        ((org.neo4j.bolt.tx.statement.Statement)txManagerOrder.verify((Object)statement2)).consume((ResponseHandler)Mockito.any(ResponseHandler.class), Mockito.anyLong());
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementStart(statementB, List.of("c1", "c2", "c3"));
        this.verifyDefaultResultRows(outputOrder);
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementEnd((QueryExecutionType)Mockito.any(), (QueryStatistics)Mockito.any(), (ExecutionPlanDescription)Mockito.any(), (Iterable)Mockito.any());
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.OPEN, uriScheme.txCommitUri(123L), 0L, null);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldCommitTransactionAndTellRegistryToForgetItsHandle() throws Throwable {
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)123L);
        TransactionHandle handle = this.getTransactionHandle(this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, (Object[])new Statement[]{NULL_STATEMENT});
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(123L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        InOrder transactionOrder = Mockito.inOrder((Object[])new Object[]{this.internalTransaction, this.registry});
        ((TransactionRegistry)transactionOrder.verify((Object)this.registry)).forget(123L);
        InOrder txManagerOrder = Mockito.inOrder((Object[])new Object[]{this.transactionManager, this.transaction, this.statement});
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).create(TransactionType.IMPLICIT, (TransactionOwner)handle, "neo4j", AccessMode.READ, Collections.emptyList(), null, Collections.emptyMap(), null);
        ((Transaction)txManagerOrder.verify((Object)this.transaction)).run("query", MapValue.EMPTY);
        ((Transaction)txManagerOrder.verify((Object)this.transaction)).commit();
        ((Transaction)txManagerOrder.verify((Object)this.transaction)).close();
        txManagerOrder.verifyNoMoreInteractions();
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementStart(statement, List.of("c1", "c2", "c3"));
        this.verifyDefaultResultRows(outputOrder);
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementEnd((QueryExecutionType)Mockito.any(), (QueryStatistics)Mockito.any(), (ExecutionPlanDescription)Mockito.any(), (Iterable)Mockito.any());
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.COMMITTED, uriScheme.txCommitUri(123L), -1L, SERIALIZED_BOOKMARK);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldRollbackTransactionAndTellRegistryToForgetItsHandle() throws Exception {
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)123L);
        TransactionHandle handle = this.getTransactionHandle(this.registry);
        RollbackInvocation invocation = new RollbackInvocation(this.log, handle);
        invocation.execute(this.outputEventStream);
        InOrder transactionOrder = Mockito.inOrder((Object[])new Object[]{this.transaction, this.registry});
        ((Transaction)transactionOrder.verify((Object)this.transaction)).rollback();
        ((TransactionRegistry)transactionOrder.verify((Object)this.registry)).forget(123L);
        ((Transaction)transactionOrder.verify((Object)this.transaction)).close();
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.ROLLED_BACK, null, -1L, null);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldCreateTransactionContextOnlyWhenFirstNeeded() throws Throwable {
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)123L);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, (Object[])new Statement[]{NULL_STATEMENT});
        TransactionHandle handle = this.getTransactionHandle(this.registry);
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(123L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        InOrder txManagerOrder = Mockito.inOrder((Object[])new Object[]{this.transactionManager, this.transaction, this.statement});
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).create(TransactionType.IMPLICIT, (TransactionOwner)handle, "neo4j", AccessMode.READ, Collections.emptyList(), null, Collections.emptyMap(), null);
        ((Transaction)txManagerOrder.verify((Object)this.transaction)).run("query", MapValue.EMPTY);
        ((org.neo4j.bolt.tx.statement.Statement)txManagerOrder.verify((Object)this.statement)).consume((ResponseHandler)Mockito.any(ResponseHandler.class), Mockito.anyLong());
        ((Transaction)txManagerOrder.verify((Object)this.transaction)).commit();
        ((Transaction)txManagerOrder.verify((Object)this.transaction)).close();
        txManagerOrder.verifyNoMoreInteractions();
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementStart(statement, List.of("c1", "c2", "c3"));
        this.verifyDefaultResultRows(outputOrder);
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementEnd((QueryExecutionType)Mockito.any(), (QueryStatistics)Mockito.any(), (ExecutionPlanDescription)Mockito.any(), (Iterable)Mockito.any());
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.COMMITTED, uriScheme.txCommitUri(123L), -1L, SERIALIZED_BOOKMARK);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldRollbackTransactionIfExecutionErrorOccurs() throws Exception {
        Mockito.when((Object)this.transaction.run("query", MapValue.EMPTY)).thenThrow(new Throwable[]{new StatementExecutionException()});
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)123L);
        TransactionHandle handle = this.getTransactionHandle(this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, (Object[])new Statement[]{NULL_STATEMENT});
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(123L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        InOrder txManagerOrder = Mockito.inOrder((Object[])new Object[]{this.transactionManager, this.transaction, this.statement});
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).create(TransactionType.IMPLICIT, (TransactionOwner)handle, "neo4j", AccessMode.READ, Collections.emptyList(), null, Collections.emptyMap(), null);
        ((Transaction)txManagerOrder.verify((Object)this.transaction)).run("query", MapValue.EMPTY);
        ((Transaction)txManagerOrder.verify((Object)this.transaction)).rollback();
        ((Transaction)txManagerOrder.verify((Object)this.transaction)).close();
        txManagerOrder.verifyNoMoreInteractions();
        ((TransactionRegistry)Mockito.verify((Object)this.registry)).forget(123L);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeFailure((Status)Status.Statement.ExecutionFailed, null);
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.ROLLED_BACK, uriScheme.txCommitUri(123L), -1L, null);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldHandleCommitError() throws Throwable {
        TransactionException commitError = (TransactionException)Mockito.mock(TransactionException.class);
        Mockito.when((Object)commitError.getMessage()).thenReturn((Object)"Something went wrong!");
        Mockito.when((Object)this.transaction.commit()).thenThrow(new Throwable[]{commitError});
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)123L);
        TransactionHandle handle = this.getTransactionHandle(this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, (Object[])new Statement[]{NULL_STATEMENT});
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(123L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        ((InternalLog)Mockito.verify((Object)this.log)).error((String)Mockito.eq((Object)"Failed to commit transaction."), (Throwable)Mockito.any(TransactionException.class));
        ((TransactionRegistry)Mockito.verify((Object)this.registry)).forget(123L);
        InOrder txManagerOrder = Mockito.inOrder((Object[])new Object[]{this.transactionManager, this.transaction, this.statement});
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).create(TransactionType.IMPLICIT, (TransactionOwner)handle, "neo4j", AccessMode.READ, Collections.emptyList(), null, Collections.emptyMap(), null);
        ((Transaction)txManagerOrder.verify((Object)this.transaction)).run("query", MapValue.EMPTY);
        ((org.neo4j.bolt.tx.statement.Statement)txManagerOrder.verify((Object)this.statement)).consume((ResponseHandler)Mockito.any(ResponseHandler.class), Mockito.anyLong());
        ((Transaction)txManagerOrder.verify((Object)this.transaction)).commit();
        ((Transaction)txManagerOrder.verify((Object)this.transaction)).close();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.transactionManager});
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementStart(statement, List.of("c1", "c2", "c3"));
        this.verifyDefaultResultRows(outputOrder);
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementEnd((QueryExecutionType)Mockito.any(), (QueryStatistics)Mockito.any(), (ExecutionPlanDescription)Mockito.any(), (Iterable)Mockito.any());
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeFailure((Status)Mockito.any(), (String)Mockito.any());
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.UNKNOWN, uriScheme.txCommitUri(123L), -1L, null);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldHandleErrorWhenStartingTransaction() throws Throwable {
        Mockito.when((Object)this.transactionManager.create((TransactionType)Mockito.any(TransactionType.class), (TransactionOwner)Mockito.any(TransactionOwner.class), ArgumentMatchers.anyString(), (AccessMode)Mockito.any(AccessMode.class), ArgumentMatchers.anyList(), (Duration)ArgumentMatchers.nullable(Duration.class), ArgumentMatchers.anyMap(), (NotificationConfiguration)ArgumentMatchers.nullable(NotificationConfiguration.class))).thenThrow(new Throwable[]{(Throwable)Mockito.mock(TransactionException.class)});
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)123L);
        TransactionHandle handle = this.getTransactionHandle(this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, (Object[])new Statement[]{NULL_STATEMENT});
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(123L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        ((InternalLog)Mockito.verify((Object)this.log)).error((String)Mockito.eq((Object)"Failed to start transaction"), (Throwable)Mockito.any(TransactionException.class));
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeFailure((Status)Mockito.any(), (String)Mockito.any());
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.NO_TRANSACTION, uriScheme.txCommitUri(123L), -1L, null);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldHandleAuthorizationErrorWhenStartingTransaction() throws Throwable {
        Mockito.when((Object)this.transactionManager.create((TransactionType)Mockito.any(TransactionType.class), (TransactionOwner)Mockito.any(TransactionOwner.class), ArgumentMatchers.anyString(), (AccessMode)Mockito.any(AccessMode.class), ArgumentMatchers.anyList(), (Duration)ArgumentMatchers.nullable(Duration.class), ArgumentMatchers.anyMap(), (NotificationConfiguration)ArgumentMatchers.nullable(NotificationConfiguration.class))).thenThrow(new Throwable[]{new AuthorizationViolationException("Forbidden")});
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = this.getTransactionHandle(this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, (Object[])new Statement[]{NULL_STATEMENT});
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(1337L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.log});
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeFailure((Status)Status.Security.Forbidden, "Forbidden");
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.NO_TRANSACTION, uriScheme.txCommitUri(1337L), -1L, null);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldHandleCypherSyntaxError() throws Exception {
        String queryText = "matsch (n) return n";
        Mockito.when((Object)this.transaction.run(queryText, MapValue.EMPTY)).thenThrow(new Throwable[]{new RuntimeException((Throwable)new SyntaxException("did you mean MATCH?"))});
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)123L);
        TransactionHandle handle = this.getTransactionHandle(this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement(queryText, MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, (Object[])new Statement[]{NULL_STATEMENT});
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(123L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        ((TransactionRegistry)Mockito.verify((Object)this.registry)).forget(123L);
        InOrder txManagerOrder = Mockito.inOrder((Object[])new Object[]{this.transactionManager, this.transaction, this.statement});
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).create(TransactionType.IMPLICIT, (TransactionOwner)handle, "neo4j", AccessMode.READ, Collections.emptyList(), null, Collections.emptyMap(), null);
        ((Transaction)txManagerOrder.verify((Object)this.transaction)).run(queryText, MapValue.EMPTY);
        ((Transaction)txManagerOrder.verify((Object)this.transaction)).rollback();
        ((Transaction)txManagerOrder.verify((Object)this.transaction)).close();
        txManagerOrder.verifyNoMoreInteractions();
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeFailure((Status)Status.Statement.SyntaxError, "did you mean MATCH?");
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.ROLLED_BACK, uriScheme.txCommitUri(123L), -1L, null);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldHandleExecutionEngineThrowingUndeclaredCheckedExceptions() throws Exception {
        Mockito.when((Object)this.transaction.run("query", MapValue.EMPTY)).thenThrow(new Throwable[]{new RuntimeException("BOO")});
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)123L);
        TransactionHandle handle = this.getTransactionHandle(this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, (Object[])new Statement[]{NULL_STATEMENT});
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(123L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        ((TransactionRegistry)Mockito.verify((Object)this.registry)).forget(123L);
        InOrder txManagerOrder = Mockito.inOrder((Object[])new Object[]{this.transactionManager, this.transaction, this.statement});
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).create(TransactionType.IMPLICIT, (TransactionOwner)handle, "neo4j", AccessMode.READ, Collections.emptyList(), null, Collections.emptyMap(), null);
        ((Transaction)txManagerOrder.verify((Object)this.transaction)).run("query", MapValue.EMPTY);
        ((Transaction)txManagerOrder.verify((Object)this.transaction)).rollback();
        ((Transaction)txManagerOrder.verify((Object)this.transaction)).close();
        txManagerOrder.verifyNoMoreInteractions();
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeFailure((Status)Status.Statement.ExecutionFailed, "BOO");
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.ROLLED_BACK, uriScheme.txCommitUri(123L), -1L, null);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldHandleRollbackError() throws Exception {
        ((Transaction)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("BOO")}).when((Object)this.transaction)).run("query", MapValue.EMPTY);
        ((Transaction)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalStateException("Something went wrong")}).when((Object)this.transaction)).rollback();
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)123L);
        TransactionHandle handle = this.getTransactionHandle(this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, (Object[])new Statement[]{NULL_STATEMENT});
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(123L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        ((InternalLog)Mockito.verify((Object)this.log)).error((String)Mockito.eq((Object)"Failed to roll back transaction."), (Throwable)Mockito.any(IllegalStateException.class));
        ((TransactionRegistry)Mockito.verify((Object)this.registry)).forget(123L);
        InOrder txManagerOrder = Mockito.inOrder((Object[])new Object[]{this.transactionManager, this.transaction});
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).create(TransactionType.IMPLICIT, (TransactionOwner)handle, "neo4j", AccessMode.READ, Collections.emptyList(), null, Collections.emptyMap(), null);
        ((Transaction)txManagerOrder.verify((Object)this.transaction)).run("query", MapValue.EMPTY);
        ((Transaction)txManagerOrder.verify((Object)this.transaction)).rollback();
        ((Transaction)txManagerOrder.verify((Object)this.transaction)).close();
        txManagerOrder.verifyNoMoreInteractions();
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeFailure((Status)Status.Statement.ExecutionFailed, "BOO");
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeFailure((Status)Status.Transaction.TransactionRollbackFailed, "Something went wrong");
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.UNKNOWN, uriScheme.txCommitUri(123L), -1L, null);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldInterruptTransaction() throws Throwable {
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)123L);
        TransactionHandle handle = this.getTransactionHandle(this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, (Object[])new Statement[]{NULL_STATEMENT});
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(123L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        handle.terminate();
        ((Transaction)Mockito.verify((Object)this.transaction)).interrupt();
    }

    @Test
    void deadlockExceptionHasCorrectStatus() throws Throwable {
        Mockito.when((Object)this.transaction.run("query", MapValue.EMPTY)).thenThrow(new Throwable[]{new DeadlockDetectedException("deadlock")});
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)123L);
        TransactionHandle handle = this.getTransactionHandle(this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, (Object[])new Statement[]{NULL_STATEMENT});
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(123L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        ((TransactionRegistry)Mockito.verify((Object)this.registry)).forget(123L);
        InOrder txManagerOrder = Mockito.inOrder((Object[])new Object[]{this.transactionManager, this.transaction});
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).create(TransactionType.IMPLICIT, (TransactionOwner)handle, "neo4j", AccessMode.READ, Collections.emptyList(), null, Collections.emptyMap(), null);
        ((Transaction)txManagerOrder.verify((Object)this.transaction)).run("query", MapValue.EMPTY);
        ((Transaction)txManagerOrder.verify((Object)this.transaction)).rollback();
        ((Transaction)txManagerOrder.verify((Object)this.transaction)).close();
        txManagerOrder.verifyNoMoreInteractions();
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeFailure((Status)Status.Transaction.DeadlockDetected, "deadlock");
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.ROLLED_BACK, uriScheme.txCommitUri(123L), -1L, null);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void startTransactionWithRequestedTimeout() throws Exception {
        TransactionManager txManager = (TransactionManager)Mockito.mock(TransactionManager.class);
        TransactionHandle handle = new TransactionHandle("neo4j", (TransactionRegistry)Mockito.mock(TransactionRegistry.class), uriScheme, true, LoginContext.AUTH_DISABLED, (ClientConnectionInfo)Mockito.mock(ClientConnectionInfo.class), 100L, txManager, (InternalLogProvider)Mockito.mock(InternalLogProvider.class), (MemoryTracker)Mockito.mock(MemoryTracker.class), (AuthManager)Mockito.mock(AuthManager.class), true, Collections.emptyList());
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Mockito.when((Object)inputEventStream.read()).thenReturn(null);
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(123L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        ((TransactionManager)Mockito.verify((Object)txManager)).create(TransactionType.IMPLICIT, (TransactionOwner)handle, "neo4j", AccessMode.READ, Collections.emptyList(), Duration.ofMillis(100L), Collections.emptyMap(), null);
    }

    @Test
    void shouldHandleInputParsingErrorWhenReadingStatements() throws Exception {
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)123L);
        TransactionHandle handle = this.getTransactionHandle(this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Mockito.when((Object)inputEventStream.read()).thenThrow(new Throwable[]{new InputFormatException("Cannot parse input", (Throwable)new IOException("JSON ERROR"))});
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(123L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        ((Transaction)Mockito.verify((Object)this.transaction)).rollback();
        ((Transaction)Mockito.verify((Object)this.transaction)).close();
        ((TransactionRegistry)Mockito.verify((Object)this.registry)).forget(123L);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeFailure((Status)Status.Request.InvalidFormat, "Cannot parse input");
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.ROLLED_BACK, uriScheme.txCommitUri(123L), -1L, null);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldHandleConnectionErrorWhenReadingStatementsInImplicitTransaction() throws Exception {
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)123L);
        TransactionHandle handle = this.getTransactionHandle(this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Mockito.when((Object)inputEventStream.read()).thenThrow(new Throwable[]{new ConnectionException("Connection error", (Throwable)new IOException("Broken pipe"))});
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(123L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        RuntimeException e = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> invocation.execute(this.outputEventStream));
        Assertions.assertTrue((boolean)e.getMessage().contains("Connection error"));
        ((Transaction)Mockito.verify((Object)this.transaction)).rollback();
        ((Transaction)Mockito.verify((Object)this.transaction)).close();
        ((TransactionRegistry)Mockito.verify((Object)this.registry)).forget(123L);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldKeepTransactionOpenIfConnectionErrorWhenReadingStatementsInExplicitTransaction() throws Exception {
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = this.getTransactionHandle(this.registry, false, true);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Mockito.when((Object)inputEventStream.read()).thenThrow(new Throwable[]{new ConnectionException("Connection error", (Throwable)new IOException("Broken pipe"))});
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(1337L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        RuntimeException e = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> invocation.execute(this.outputEventStream));
        Assertions.assertTrue((boolean)e.getMessage().contains("Connection error"));
        ((Transaction)Mockito.verify((Object)this.transaction, (VerificationMode)Mockito.never())).rollback();
        ((Transaction)Mockito.verify((Object)this.transaction, (VerificationMode)Mockito.never())).commit();
        ((Transaction)Mockito.verify((Object)this.transaction, (VerificationMode)Mockito.never())).close();
        ((TransactionRegistry)Mockito.verify((Object)this.registry, (VerificationMode)Mockito.never())).forget(1337L);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldHandleConnectionErrorWhenWritingOutputInImplicitTransaction() throws Throwable {
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = this.getTransactionHandle(this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, (Object[])new Statement[]{NULL_STATEMENT});
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(1337L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        ((OutputEventStream)Mockito.doThrow((Throwable[])new Throwable[]{new ConnectionException("Connection error", (Throwable)new IOException("Broken pipe"))}).when((Object)this.outputEventStream)).writeStatementEnd((QueryExecutionType)Mockito.any(), (QueryStatistics)Mockito.any(), (ExecutionPlanDescription)Mockito.any(), (Iterable)Mockito.any());
        RuntimeException e = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> invocation.execute(this.outputEventStream));
        Assertions.assertTrue((boolean)e.getMessage().contains("Connection error"));
        ((Transaction)Mockito.verify((Object)this.transaction)).rollback();
        ((Transaction)Mockito.verify((Object)this.transaction)).close();
        ((TransactionRegistry)Mockito.verify((Object)this.registry)).forget(1337L);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementStart(statement, List.of("c1", "c2", "c3"));
        this.verifyDefaultResultRows(outputOrder);
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementEnd((QueryExecutionType)Mockito.any(), (QueryStatistics)Mockito.any(), (ExecutionPlanDescription)Mockito.any(), (Iterable)Mockito.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldKeepTransactionOpenIfConnectionErrorWhenWritingOutputInImplicitTransaction() throws Throwable {
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = this.getTransactionHandle(this.registry, false, true);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, (Object[])new Statement[]{NULL_STATEMENT});
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(1337L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, false);
        ((OutputEventStream)Mockito.doThrow((Throwable[])new Throwable[]{new ConnectionException("Connection error", (Throwable)new IOException("Broken pipe"))}).when((Object)this.outputEventStream)).writeStatementEnd((QueryExecutionType)Mockito.any(), (QueryStatistics)Mockito.any(), (ExecutionPlanDescription)Mockito.any(), (Iterable)Mockito.any());
        RuntimeException e = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> invocation.execute(this.outputEventStream));
        Assertions.assertTrue((boolean)e.getMessage().contains("Connection error"));
        ((Transaction)Mockito.verify((Object)this.transaction, (VerificationMode)Mockito.never())).rollback();
        ((Transaction)Mockito.verify((Object)this.transaction, (VerificationMode)Mockito.never())).close();
        ((TransactionRegistry)Mockito.verify((Object)this.registry, (VerificationMode)Mockito.never())).forget(1337L);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementStart(statement, List.of("c1", "c2", "c3"));
        this.verifyDefaultResultRows(outputOrder);
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementEnd((QueryExecutionType)Mockito.any(), (QueryStatistics)Mockito.any(), (ExecutionPlanDescription)Mockito.any(), (Iterable)Mockito.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldAllocateAndFreeMemory() throws Throwable {
        TransactionHandle handle = this.getTransactionHandle(this.registry, false, true);
        MemoryPool memoryPool = (MemoryPool)Mockito.mock(MemoryPool.class);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)new Statement("query", MapUtil.map((Object[])new Object[0])), (Object[])new Statement[]{NULL_STATEMENT});
        Invocation invocation = new Invocation((InternalLog)Mockito.mock(InternalLog.class), handle, uriScheme.txCommitUri(1337L), memoryPool, inputEventStream, true);
        invocation.execute(this.outputEventStream);
        ((MemoryPool)Mockito.verify((Object)memoryPool, (VerificationMode)Mockito.times((int)2))).reserveHeap(Statement.SHALLOW_SIZE);
        ((MemoryPool)Mockito.verify((Object)memoryPool, (VerificationMode)Mockito.times((int)2))).releaseHeap(Statement.SHALLOW_SIZE);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{memoryPool});
    }

    @Test
    void shouldFreeMemoryOnException() throws Throwable {
        TransactionHandle handle = this.getTransactionHandle(this.registry, false, true);
        MemoryPool memoryPool = (MemoryPool)Mockito.mock(MemoryPool.class);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)new Statement("query", MapUtil.map((Object[])new Object[0])), (Object[])new Statement[]{NULL_STATEMENT});
        ((OutputEventStream)Mockito.doThrow((Throwable[])new Throwable[]{new ConnectionException("Something broke", (Throwable)new IOException("Oh no"))}).when((Object)this.outputEventStream)).writeStatementEnd((QueryExecutionType)Mockito.any(), (QueryStatistics)Mockito.any(), (ExecutionPlanDescription)Mockito.any(), (Iterable)Mockito.any());
        Invocation invocation = new Invocation((InternalLog)Mockito.mock(InternalLog.class), handle, uriScheme.txCommitUri(1337L), memoryPool, inputEventStream, true);
        Assertions.assertThrows(RuntimeException.class, () -> invocation.execute(this.outputEventStream));
        ((MemoryPool)Mockito.verify((Object)memoryPool)).reserveHeap(Statement.SHALLOW_SIZE);
        ((MemoryPool)Mockito.verify((Object)memoryPool)).releaseHeap(Statement.SHALLOW_SIZE);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{memoryPool});
    }

    @Test
    void shouldExecuteStatementsWithWriteTransaction() throws Throwable {
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)123L);
        TransactionHandle handle = this.getTransactionHandle(this.registry, true, false);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, (Object[])new Statement[]{NULL_STATEMENT});
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(Long.parseLong(TX_ID)), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        InOrder txManagerOrder = Mockito.inOrder((Object[])new Object[]{this.transactionManager, this.transaction, this.statement});
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).create(TransactionType.IMPLICIT, (TransactionOwner)handle, "neo4j", AccessMode.WRITE, Collections.emptyList(), null, Collections.emptyMap(), null);
        ((Transaction)txManagerOrder.verify((Object)this.transaction)).run("query", MapValue.EMPTY);
        ((org.neo4j.bolt.tx.statement.Statement)txManagerOrder.verify((Object)this.statement)).consume((ResponseHandler)Mockito.any(ResponseHandler.class), Mockito.anyLong());
        ((Transaction)txManagerOrder.verify((Object)this.transaction)).commit();
        ((Transaction)txManagerOrder.verify((Object)this.transaction)).close();
        txManagerOrder.verifyNoMoreInteractions();
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementStart(statement, List.of("c1", "c2", "c3"));
        this.verifyDefaultResultRows(outputOrder);
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementEnd((QueryExecutionType)Mockito.any(), (QueryStatistics)Mockito.any(), (ExecutionPlanDescription)Mockito.any(), (Iterable)Mockito.any());
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.COMMITTED, uriScheme.txCommitUri(123L), -1L, SERIALIZED_BOOKMARK);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    private void verifyDefaultResultRows(InOrder outputOrder) {
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeRecord((List)Mockito.eq(List.of("c1", "c2", "c3")), (Function)ArgumentMatchers.argThat((ArgumentMatcher)new ValuesMatcher(Map.of("c1", "v1", "c2", "v2", "c3", "v3"))));
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeRecord((List)Mockito.eq(List.of("c1", "c2", "c3")), (Function)ArgumentMatchers.argThat((ArgumentMatcher)new ValuesMatcher(Map.of("c1", "v4", "c2", "v5", "c3", "v6"))));
    }

    private TransactionHandle getTransactionHandle(TransactionRegistry registry) {
        return this.getTransactionHandle(registry, true, true);
    }

    private TransactionHandle getTransactionHandle(TransactionRegistry registry, boolean implicitTransaction, boolean readOnly) {
        return new TransactionHandle("neo4j", registry, uriScheme, implicitTransaction, LoginContext.AUTH_DISABLED, (ClientConnectionInfo)Mockito.mock(ClientConnectionInfo.class), Mockito.anyLong(), this.transactionManager, this.logProvider, this.memoryTracker, this.authManager, readOnly, Collections.emptyList());
    }

    private org.neo4j.bolt.tx.statement.Statement generateStatementMock() {
        return (org.neo4j.bolt.tx.statement.Statement)StatementMockFactory.newFactory().withResults(MockResult.newInstance(factory -> factory.withField(new String[]{"c1", "c2", "c3"}).withRecord(new AnyValue[]{Values.stringValue((String)"v1"), Values.stringValue((String)"v2"), Values.stringValue((String)"v3")}).withRecord(new AnyValue[]{Values.stringValue((String)"v4"), Values.stringValue((String)"v5"), Values.stringValue((String)"v6")}).withMetadata("type", (AnyValue)Values.stringValue((String)"w")).withMetadata("db", (AnyValue)Values.stringValue((String)"neo4j")))).build();
    }

    private static class ValuesMatcher
    implements ArgumentMatcher<Function<String, Object>> {
        private final Map<String, Object> values;

        private ValuesMatcher(Map<String, Object> values) {
            this.values = values;
        }

        public boolean matches(Function<String, Object> valueExtractor) {
            return this.values.entrySet().stream().anyMatch(entry -> entry.getValue().equals(valueExtractor.apply((String)entry.getKey())));
        }
    }
}

