/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.format.output.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.graphdb.InputPosition;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.impl.notification.NotificationCodeWithDescription;
import org.neo4j.graphdb.impl.notification.NotificationImplementation;
import org.neo4j.graphdb.spatial.CRS;
import org.neo4j.graphdb.spatial.Coordinate;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.server.http.cypher.TransitionalTxManagementKernelTransaction;
import org.neo4j.server.http.cypher.entity.HttpNode;
import org.neo4j.server.http.cypher.entity.HttpRelationship;
import org.neo4j.server.http.cypher.format.api.FailureEvent;
import org.neo4j.server.http.cypher.format.api.RecordEvent;
import org.neo4j.server.http.cypher.format.api.StatementEndEvent;
import org.neo4j.server.http.cypher.format.api.StatementStartEvent;
import org.neo4j.server.http.cypher.format.api.TransactionInfoEvent;
import org.neo4j.server.http.cypher.format.api.TransactionNotificationState;
import org.neo4j.server.http.cypher.format.common.Neo4jJsonCodec;
import org.neo4j.server.http.cypher.format.input.json.InputStatement;
import org.neo4j.server.http.cypher.format.output.json.ExecutionResultSerializer;
import org.neo4j.server.http.cypher.format.output.json.ResultDataContent;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.test.mockito.mock.GraphMock;
import org.neo4j.test.mockito.mock.Link;
import org.neo4j.test.mockito.mock.SpatialMocks;

class ExecutionResultSerializerTest {
    private static final Map<String, Object> NO_ARGS = Collections.emptyMap();
    private static final Set<String> NO_IDS = Collections.emptySet();
    private static final List<ExecutionPlanDescription> NO_PLANS = Collections.emptyList();
    private static final JsonFactory JSON_FACTORY = new JsonFactory().disable(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM);
    private final ByteArrayOutputStream output = new ByteArrayOutputStream();
    private ExecutionResultSerializer serializer;
    private InternalTransaction internalTransaction;

    ExecutionResultSerializerTest() {
    }

    @BeforeEach
    void init() {
        TransitionalTxManagementKernelTransaction context = (TransitionalTxManagementKernelTransaction)Mockito.mock(TransitionalTxManagementKernelTransaction.class);
        this.internalTransaction = (InternalTransaction)Mockito.mock(InternalTransaction.class);
        KernelTransactionImplementation kernelTransaction = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        Mockito.when((Object)this.internalTransaction.kernelTransaction()).thenReturn((Object)kernelTransaction);
        Mockito.when((Object)context.getInternalTransaction()).thenReturn((Object)this.internalTransaction);
        this.serializer = ExecutionResultSerializerTest.getSerializerWith(this.output);
    }

    @Test
    void shouldSerializeResponseWithCommitUriOnly() {
        this.serializer.writeTransactionInfo(new TransactionInfoEvent(TransactionNotificationState.NO_TRANSACTION, URI.create("commit/uri/1"), -1L, null));
        String result = this.output.toString(StandardCharsets.UTF_8);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"{\"results\":[],\"errors\":[],\"commit\":\"commit/uri/1\"}", (Object)result);
    }

    @Test
    void shouldSerializeBookmarkOnCommittedNotificationState() {
        this.serializer.writeTransactionInfo(new TransactionInfoEvent(TransactionNotificationState.COMMITTED, URI.create("commit/uri/1"), -1L, "I AM BOOKMARK!"));
        String result = this.output.toString(StandardCharsets.UTF_8);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"{\"results\":[],\"errors\":[],\"commit\":\"commit/uri/1\",\"lastBookmarks\":[\"I AM BOOKMARK!\"]}", (Object)result);
    }

    @Test
    void shouldNotSerializeBookmarkOnNonCommittedNotificationStates() {
        this.serializer.writeTransactionInfo(new TransactionInfoEvent(TransactionNotificationState.NO_TRANSACTION, URI.create("commit/uri/1"), -1L, "NOT SEEN!"));
        String result = this.output.toString(StandardCharsets.UTF_8);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"{\"results\":[],\"errors\":[],\"commit\":\"commit/uri/1\"}", (Object)result);
    }

    @Test
    void shouldSerializeResponseWithCommitUriAndResults() {
        Map<String, String> row = Map.of("column1", "value1", "column2", "value2");
        ExecutionResultSerializerTest.writeStatementStart(this.serializer, "column1", "column2");
        ExecutionResultSerializerTest.writeRecord(this.serializer, row, "column1", "column2");
        ExecutionResultSerializerTest.writeStatementEnd(this.serializer);
        this.serializer.writeTransactionInfo(new TransactionInfoEvent(TransactionNotificationState.NO_TRANSACTION, URI.create("commit/uri/1"), -1L, null));
        String result = this.output.toString(StandardCharsets.UTF_8);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"{\"results\":[{\"columns\":[\"column1\",\"column2\"],\"data\":[{\"row\":[\"value1\",\"value2\"],\"meta\":[null,null]}]}],\"errors\":[],\"commit\":\"commit/uri/1\"}", (Object)result);
    }

    @Test
    void shouldSerializeResponseWithResultsOnly() {
        Map<String, String> row = Map.of("column1", "value1", "column2", "value2");
        ExecutionResultSerializerTest.writeStatementStart(this.serializer, "column1", "column2");
        ExecutionResultSerializerTest.writeRecord(this.serializer, row, "column1", "column2");
        ExecutionResultSerializerTest.writeStatementEnd(this.serializer);
        ExecutionResultSerializerTest.writeTransactionInfo(this.serializer);
        String result = this.output.toString(StandardCharsets.UTF_8);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"{\"results\":[{\"columns\":[\"column1\",\"column2\"],\"data\":[{\"row\":[\"value1\",\"value2\"],\"meta\":[null,null]}]}],\"errors\":[]}", (Object)result);
    }

    @Test
    void shouldSerializeResponseWithCommitUriAndResultsAndErrors() {
        Map<String, String> row = Map.of("column1", "value1", "column2", "value2");
        ExecutionResultSerializerTest.writeStatementStart(this.serializer, "column1", "column2");
        ExecutionResultSerializerTest.writeRecord(this.serializer, row, "column1", "column2");
        ExecutionResultSerializerTest.writeStatementEnd(this.serializer);
        ExecutionResultSerializerTest.writeError(this.serializer, (Status)Status.Request.InvalidFormat, "cause1");
        ExecutionResultSerializerTest.writeTransactionInfo(this.serializer, "commit/uri/1");
        String result = this.output.toString(StandardCharsets.UTF_8);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"{\"results\":[{\"columns\":[\"column1\",\"column2\"],\"data\":[{\"row\":[\"value1\",\"value2\"],\"meta\":[null,null]}]}],\"errors\":[{\"code\":\"Neo.ClientError.Request.InvalidFormat\",\"message\":\"cause1\"}],\"commit\":\"commit/uri/1\"}", (Object)result);
    }

    @Test
    void shouldSerializeResponseWithResultsAndErrors() {
        Map<String, String> row = Map.of("column1", "value1", "column2", "value2");
        ExecutionResultSerializerTest.writeStatementStart(this.serializer, "column1", "column2");
        ExecutionResultSerializerTest.writeRecord(this.serializer, row, "column1", "column2");
        ExecutionResultSerializerTest.writeStatementEnd(this.serializer);
        ExecutionResultSerializerTest.writeError(this.serializer, (Status)Status.Request.InvalidFormat, "cause1");
        ExecutionResultSerializerTest.writeTransactionInfo(this.serializer);
        String result = this.output.toString(StandardCharsets.UTF_8);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"{\"results\":[{\"columns\":[\"column1\",\"column2\"],\"data\":[{\"row\":[\"value1\",\"value2\"],\"meta\":[null,null]}]}],\"errors\":[{\"code\":\"Neo.ClientError.Request.InvalidFormat\",\"message\":\"cause1\"}]}", (Object)result);
    }

    @Test
    void shouldSerializeResponseWithCommitUriAndErrors() {
        ExecutionResultSerializerTest.writeError(this.serializer, (Status)Status.Request.InvalidFormat, "cause1");
        ExecutionResultSerializerTest.writeTransactionInfo(this.serializer, "commit/uri/1");
        String result = this.output.toString(StandardCharsets.UTF_8);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"{\"results\":[],\"errors\":[{\"code\":\"Neo.ClientError.Request.InvalidFormat\",\"message\":\"cause1\"}],\"commit\":\"commit/uri/1\"}", (Object)result);
    }

    @Test
    void shouldSerializeResponseWithErrorsOnly() {
        ExecutionResultSerializerTest.writeError(this.serializer, (Status)Status.Request.InvalidFormat, "cause1");
        ExecutionResultSerializerTest.writeTransactionInfo(this.serializer);
        String result = this.output.toString(StandardCharsets.UTF_8);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"{\"results\":[],\"errors\":[{\"code\":\"Neo.ClientError.Request.InvalidFormat\",\"message\":\"cause1\"}]}", (Object)result);
    }

    @Test
    void shouldSerializeResponseWithNoCommitUriResultsOrErrors() {
        ExecutionResultSerializerTest.writeTransactionInfo(this.serializer);
        String result = this.output.toString(StandardCharsets.UTF_8);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"{\"results\":[],\"errors\":[]}", (Object)result);
    }

    @Test
    void shouldSerializeResponseWithMultipleResultRows() {
        Map<String, String> row1 = Map.of("column1", "value1", "column2", "value2");
        Map<String, String> row2 = Map.of("column1", "value3", "column2", "value4");
        ExecutionResultSerializerTest.writeStatementStart(this.serializer, "column1", "column2");
        ExecutionResultSerializerTest.writeRecord(this.serializer, row1, "column1", "column2");
        ExecutionResultSerializerTest.writeRecord(this.serializer, row2, "column1", "column2");
        ExecutionResultSerializerTest.writeStatementEnd(this.serializer);
        ExecutionResultSerializerTest.writeTransactionInfo(this.serializer);
        String result = this.output.toString(StandardCharsets.UTF_8);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"{\"results\":[{\"columns\":[\"column1\",\"column2\"],\"data\":[{\"row\":[\"value1\",\"value2\"],\"meta\":[null,null]},{\"row\":[\"value3\",\"value4\"],\"meta\":[null,null]}]}],\"errors\":[]}", (Object)result);
    }

    @Test
    void shouldSerializeResponseWithMultipleResults() {
        Map<String, String> row1 = Map.of("column1", "value1", "column2", "value2");
        Map<String, String> row2 = Map.of("column3", "value3", "column4", "value4");
        ExecutionResultSerializerTest.writeStatementStart(this.serializer, "column1", "column2");
        ExecutionResultSerializerTest.writeRecord(this.serializer, row1, "column1", "column2");
        ExecutionResultSerializerTest.writeStatementEnd(this.serializer);
        ExecutionResultSerializerTest.writeStatementStart(this.serializer, "column3", "column4");
        ExecutionResultSerializerTest.writeRecord(this.serializer, row2, "column3", "column4");
        ExecutionResultSerializerTest.writeStatementEnd(this.serializer);
        ExecutionResultSerializerTest.writeTransactionInfo(this.serializer);
        String result = this.output.toString(StandardCharsets.UTF_8);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"{\"results\":[{\"columns\":[\"column1\",\"column2\"],\"data\":[{\"row\":[\"value1\",\"value2\"],\"meta\":[null,null]}]},{\"columns\":[\"column3\",\"column4\"],\"data\":[{\"row\":[\"value3\",\"value4\"],\"meta\":[null,null]}]}],\"errors\":[]}", (Object)result);
    }

    @Test
    void shouldSerializeNodeAsMapOfProperties() throws JsonParseException {
        HttpNode node = new HttpNode("1", 1L, Collections.emptyList(), Map.of("a", 12, "b", true, "c", new int[]{1, 0, 1, 2}, "d", new byte[]{1, 0, 1, 2}, "e", new String[]{"a", "b", "\u00e4\u00e4\u00f6"}), false);
        Map<String, HttpNode> record = Map.of("node", node);
        Mockito.when((Object)this.internalTransaction.getNodeById(1L)).thenReturn((Object)node);
        ExecutionResultSerializerTest.writeStatementStart(this.serializer, "node");
        ExecutionResultSerializerTest.writeRecord(this.serializer, record, "node");
        ExecutionResultSerializerTest.writeStatementEnd(this.serializer);
        ExecutionResultSerializerTest.writeTransactionInfo(this.serializer);
        String result = this.output.toString(StandardCharsets.UTF_8);
        JsonNode json = JsonHelper.jsonNode((String)result);
        JsonNode results = json.get("results").get(0);
        JsonNode row = results.get("data").get(0).get("row").get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)row, (Object)JsonHelper.jsonNode((String)"{\"b\":true,\"c\":[1,0,1,2],\"d\":[1,0,1,2],\"e\":[\"a\",\"b\",\"\u00e4\u00e4\u00f6\"],\"a\":12}"));
        JsonNode meta = results.get("data").get(0).get("meta");
        org.junit.jupiter.api.Assertions.assertEquals((Object)meta, (Object)JsonHelper.jsonNode((String)"[{\"id\":1,\"elementId\":\"1\",\"type\":\"node\",\"deleted\":false}]"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldHandleTransactionHandleStateCorrectly() throws Exception {
        Function<Integer, Node> selectNode = i -> new HttpNode("1", 1L, Collections.emptyList(), Map.of("i", i), false);
        Function<Integer, Callable> callableProvider = selectNode.andThen(node -> () -> {
            TransitionalTxManagementKernelTransaction localContext = (TransitionalTxManagementKernelTransaction)Mockito.mock(TransitionalTxManagementKernelTransaction.class);
            InternalTransaction localInternalTransaction = (InternalTransaction)Mockito.mock(InternalTransaction.class);
            KernelTransactionImplementation localKernelTransaction = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
            Mockito.when((Object)localInternalTransaction.getNodeById(1L)).thenReturn(node);
            Mockito.when((Object)localInternalTransaction.kernelTransaction()).thenReturn((Object)localKernelTransaction);
            Mockito.when((Object)localContext.getInternalTransaction()).thenReturn((Object)localInternalTransaction);
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            ExecutionResultSerializer serializer = ExecutionResultSerializerTest.getSerializerWith(output);
            ExecutionResultSerializerTest.writeStatementStart(serializer, "node");
            ExecutionResultSerializerTest.writeRecord(serializer, Collections.singletonMap("node", node), "node");
            ExecutionResultSerializerTest.writeStatementEnd(serializer);
            ExecutionResultSerializerTest.writeTransactionInfo(serializer);
            return output.toString(StandardCharsets.UTF_8);
        });
        int numberOfRequests = 10;
        ExecutorService executor = Executors.newCachedThreadPool();
        List calledRequests = executor.invokeAll(IntStream.range(0, numberOfRequests).boxed().map(callableProvider).collect(Collectors.toList()));
        try {
            int i2 = 0;
            for (Future request : calledRequests) {
                String expectedResult = "{\"results\":[{\"columns\":[\"node\"],\"data\":[{\"row\":[{\"i\":" + i2 + "}],\"meta\":[{\"id\":1,\"elementId\":\"1\",\"type\":\"node\",\"deleted\":false}]}]}],\"errors\":[]}";
                try {
                    String result = (String)request.get();
                    org.junit.jupiter.api.Assertions.assertEquals((Object)expectedResult, (Object)result);
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                    org.junit.jupiter.api.Assertions.fail((String)("At least one request failed " + e.getMessage()));
                }
                ++i2;
            }
        }
        finally {
            executor.shutdown();
        }
    }

    @Test
    void shouldSerializeNestedEntities() {
        HttpNode a = new HttpNode("1", 1L, List.of(), Map.of("foo", 12), false);
        HttpNode b = new HttpNode("2", 2L, List.of(), Map.of("bar", false), false);
        HttpRelationship r = new HttpRelationship("1", 1L, "1", 1L, "2", 2L, "FRAZZLE", Map.of("baz", "quux"), false, (ignoredA, ignoredB) -> Optional.empty());
        Map<String, TreeMap<String, Path>> row = Map.of("nested", new TreeMap<String, Path>(Map.of("node", a, "edge", r, "path", GraphMock.path((Node)a, (Link[])new Link[]{GraphMock.link((Relationship)r, (Node)b)}))));
        ExecutionResultSerializerTest.writeStatementStart(this.serializer, "nested");
        ExecutionResultSerializerTest.writeRecord(this.serializer, row, "nested");
        ExecutionResultSerializerTest.writeStatementEnd(this.serializer);
        ExecutionResultSerializerTest.writeTransactionInfo(this.serializer);
        String result = this.output.toString(StandardCharsets.UTF_8);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"{\"results\":[{\"columns\":[\"nested\"],\"data\":[{\"row\":[{\"edge\":{\"baz\":\"quux\"},\"node\":{\"foo\":12},\"path\":[{\"foo\":12},{\"baz\":\"quux\"},{\"bar\":false}]}],\"meta\":[{\"id\":1,\"elementId\":\"1\",\"type\":\"relationship\",\"deleted\":false},{\"id\":1,\"elementId\":\"1\",\"type\":\"node\",\"deleted\":false},[{\"id\":1,\"elementId\":\"1\",\"type\":\"node\",\"deleted\":false},{\"id\":1,\"elementId\":\"1\",\"type\":\"relationship\",\"deleted\":false},{\"id\":2,\"elementId\":\"2\",\"type\":\"node\",\"deleted\":false}]]}]}],\"errors\":[]}", (Object)result);
    }

    @Test
    void shouldSerializePathAsListOfMapsOfProperties() {
        Path path = ExecutionResultSerializerTest.mockPathWithHttpEntities(Map.of("key1", "value1"), Map.of("key2", "value2"), Map.of("key3", "value3"));
        Map<String, Path> row = Map.of("path", path);
        ExecutionResultSerializerTest.writeStatementStart(this.serializer, "path");
        ExecutionResultSerializerTest.writeRecord(this.serializer, row, "path");
        ExecutionResultSerializerTest.writeStatementEnd(this.serializer);
        ExecutionResultSerializerTest.writeTransactionInfo(this.serializer);
        String result = this.output.toString(StandardCharsets.UTF_8);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"{\"results\":[{\"columns\":[\"path\"],\"data\":[{\"row\":[[{\"key1\":\"value1\"},{\"key2\":\"value2\"},{\"key3\":\"value3\"}]],\"meta\":[[{\"id\":1,\"elementId\":\"1\",\"type\":\"node\",\"deleted\":false},{\"id\":1,\"elementId\":\"1\",\"type\":\"relationship\",\"deleted\":false},{\"id\":2,\"elementId\":\"2\",\"type\":\"node\",\"deleted\":false}]]}]}],\"errors\":[]}", (Object)result);
    }

    @Test
    void shouldSerializePointsAsListOfMapsOfProperties() {
        Map<String, SpatialMocks.MockPoint> row1 = Map.of("geom", SpatialMocks.mockPoint((double)12.3, (double)45.6, (CRS)SpatialMocks.mockWGS84()));
        Map<String, SpatialMocks.MockPoint> row2 = Map.of("geom", SpatialMocks.mockPoint((double)123.0, (double)456.0, (CRS)SpatialMocks.mockCartesian()));
        Map<String, SpatialMocks.MockPoint3D> row3 = Map.of("geom", SpatialMocks.mockPoint((double)12.3, (double)45.6, (double)78.9, (CRS)SpatialMocks.mockWGS84_3D()));
        Map<String, SpatialMocks.MockPoint3D> row4 = Map.of("geom", SpatialMocks.mockPoint((double)123.0, (double)456.0, (double)789.0, (CRS)SpatialMocks.mockCartesian_3D()));
        ExecutionResultSerializerTest.writeStatementStart(this.serializer, "geom");
        ExecutionResultSerializerTest.writeRecord(this.serializer, row1, "geom");
        ExecutionResultSerializerTest.writeRecord(this.serializer, row2, "geom");
        ExecutionResultSerializerTest.writeRecord(this.serializer, row3, "geom");
        ExecutionResultSerializerTest.writeRecord(this.serializer, row4, "geom");
        ExecutionResultSerializerTest.writeStatementEnd(this.serializer);
        ExecutionResultSerializerTest.writeTransactionInfo(this.serializer);
        String result = this.output.toString(StandardCharsets.UTF_8);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"{\"results\":[{\"columns\":[\"geom\"],\"data\":[{\"row\":[{\"type\":\"Point\",\"coordinates\":[12.3,45.6],\"crs\":{\"srid\":4326,\"name\":\"WGS-84\",\"type\":\"link\",\"properties\":{\"href\":\"https://spatialreference.org/ref/epsg/4326/ogcwkt/\",\"type\":\"ogcwkt\"}}}],\"meta\":[{\"type\":\"point\"}]},{\"row\":[{\"type\":\"Point\",\"coordinates\":[123.0,456.0],\"crs\":{\"srid\":7203,\"name\":\"cartesian\",\"type\":\"link\",\"properties\":{\"href\":\"https://spatialreference.org/ref/sr-org/7203/ogcwkt/\",\"type\":\"ogcwkt\"}}}],\"meta\":[{\"type\":\"point\"}]},{\"row\":[{\"type\":\"Point\",\"coordinates\":[12.3,45.6,78.9],\"crs\":{\"srid\":4979,\"name\":\"WGS-84-3D\",\"type\":\"link\",\"properties\":{\"href\":\"https://spatialreference.org/ref/epsg/4979/ogcwkt/\",\"type\":\"ogcwkt\"}}}],\"meta\":[{\"type\":\"point\"}]},{\"row\":[{\"type\":\"Point\",\"coordinates\":[123.0,456.0,789.0],\"crs\":{\"srid\":9157,\"name\":\"cartesian-3D\",\"type\":\"link\",\"properties\":{\"href\":\"https://spatialreference.org/ref/sr-org/9157/ogcwkt/\",\"type\":\"ogcwkt\"}}}],\"meta\":[{\"type\":\"point\"}]}]}],\"errors\":[]}", (Object)result);
    }

    @Test
    void shouldSerializeTemporalAsListOfMapsOfProperties() {
        Map<String, LocalDate> row1 = Map.of("temporal", LocalDate.of(2018, 3, 12));
        Map<String, ZonedDateTime> row2 = Map.of("temporal", ZonedDateTime.of(2018, 3, 12, 13, 2, 10, 10, ZoneId.of("UTC+1")));
        Map<String, OffsetTime> row3 = Map.of("temporal", OffsetTime.of(12, 2, 4, 71, ZoneOffset.UTC));
        Map<String, LocalDateTime> row4 = Map.of("temporal", LocalDateTime.of(2018, 3, 12, 13, 2, 10, 10));
        Map<String, LocalTime> row5 = Map.of("temporal", LocalTime.of(13, 2, 10, 10));
        Map<String, Duration> row6 = Map.of("temporal", Duration.of(12L, ChronoUnit.HOURS));
        ExecutionResultSerializerTest.writeStatementStart(this.serializer, "temporal");
        ExecutionResultSerializerTest.writeRecord(this.serializer, row1, "temporal");
        ExecutionResultSerializerTest.writeRecord(this.serializer, row2, "temporal");
        ExecutionResultSerializerTest.writeRecord(this.serializer, row3, "temporal");
        ExecutionResultSerializerTest.writeRecord(this.serializer, row4, "temporal");
        ExecutionResultSerializerTest.writeRecord(this.serializer, row5, "temporal");
        ExecutionResultSerializerTest.writeRecord(this.serializer, row6, "temporal");
        ExecutionResultSerializerTest.writeStatementEnd(this.serializer);
        this.serializer.writeTransactionInfo(new TransactionInfoEvent(TransactionNotificationState.NO_TRANSACTION, null, -1L, null));
        String result = this.output.toString(StandardCharsets.UTF_8);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"{\"results\":[{\"columns\":[\"temporal\"],\"data\":[{\"row\":[\"2018-03-12\"],\"meta\":[{\"type\":\"date\"}]},{\"row\":[\"2018-03-12T13:02:10.000000010+01:00[UTC+01:00]\"],\"meta\":[{\"type\":\"datetime\"}]},{\"row\":[\"12:02:04.000000071Z\"],\"meta\":[{\"type\":\"time\"}]},{\"row\":[\"2018-03-12T13:02:10.000000010\"],\"meta\":[{\"type\":\"localdatetime\"}]},{\"row\":[\"13:02:10.000000010\"],\"meta\":[{\"type\":\"localtime\"}]},{\"row\":[\"PT12H\"],\"meta\":[{\"type\":\"duration\"}]}]}],\"errors\":[]}", (Object)result);
    }

    @Test
    void shouldErrorWhenSerializingUnknownGeometryType() {
        List<Coordinate> points = List.of(new Coordinate(new double[]{1.0, 2.0}), new Coordinate(new double[]{2.0, 3.0}));
        Map<String, SpatialMocks.MockGeometry> row = Map.of("geom", SpatialMocks.mockGeometry((String)"LineString", points, (CRS)SpatialMocks.mockCartesian()));
        RuntimeException e = (RuntimeException)org.junit.jupiter.api.Assertions.assertThrows(RuntimeException.class, () -> {
            ExecutionResultSerializerTest.writeStatementStart(this.serializer, "geom");
            ExecutionResultSerializerTest.writeRecord(this.serializer, row, "geom");
        });
        ExecutionResultSerializerTest.writeError(this.serializer, (Status)Status.Statement.ExecutionFailed, e.getMessage());
        ExecutionResultSerializerTest.writeTransactionInfo(this.serializer);
        String result = this.output.toString(StandardCharsets.UTF_8);
        Assertions.assertThat((String)result).startsWith((CharSequence)"{\"results\":[{\"columns\":[\"geom\"],\"data\":[{\"row\":[{\"type\":\"LineString\",\"coordinates\":[[1.0,2.0],[2.0,3.0]],\"crs\":{\"srid\":7203,\"name\":\"cartesian\",\"type\":\"link\",\"properties\":{\"href\":\"https://spatialreference.org/ref/sr-org/7203/ogcwkt/\",\"type\":\"ogcwkt\"}}}],\"meta\":[]}]}],\"errors\":[{\"code\":\"Neo.DatabaseError.Statement.ExecutionFailed\",\"message\":\"Unsupported Geometry type: type=MockGeometry, value=LineString\"");
    }

    @Test
    void shouldProduceWellFormedJsonEvenIfResultIteratorThrowsExceptionOnNext() {
        Map<String, String> row = Map.of("column1", "value1", "column2", "value2");
        RecordEvent recordEvent = (RecordEvent)Mockito.mock(RecordEvent.class);
        Mockito.when((Object)recordEvent.getValue((String)ArgumentMatchers.any())).thenThrow(new Throwable[]{new RuntimeException("Stuff went wrong!")});
        Mockito.when((Object)recordEvent.getColumns()).thenReturn(List.of("column1", "column2"));
        RuntimeException e = (RuntimeException)org.junit.jupiter.api.Assertions.assertThrows(RuntimeException.class, () -> {
            ExecutionResultSerializerTest.writeStatementStart(this.serializer, "column1", "column2");
            ExecutionResultSerializerTest.writeRecord(this.serializer, row, "column1", "column2");
            this.serializer.writeRecord(recordEvent);
        });
        ExecutionResultSerializerTest.writeError(this.serializer, (Status)Status.Statement.ExecutionFailed, e.getMessage());
        ExecutionResultSerializerTest.writeTransactionInfo(this.serializer);
        String result = this.output.toString(StandardCharsets.UTF_8);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"{\"results\":[{\"columns\":[\"column1\",\"column2\"],\"data\":[{\"row\":[\"value1\",\"value2\"],\"meta\":[null,null]},{\"row\":[],\"meta\":[]}]}],\"errors\":[{\"code\":\"Neo.DatabaseError.Statement.ExecutionFailed\",\"message\":\"Stuff went wrong!\"}]}", (Object)result);
    }

    @Test
    void shouldProduceResultStreamWithGraphEntries() {
        Node[] node = new Node[]{new HttpNode("0", 0L, List.of(Label.label((String)"Node")), Map.of("name", "node0"), false), new HttpNode("1", 1L, Collections.emptyList(), Map.of("name", "node1"), false), new HttpNode("2", 2L, List.of(Label.label((String)"This"), Label.label((String)"That")), Map.of("name", "node2"), false), new HttpNode("3", 3L, List.of(Label.label((String)"Other")), Map.of("name", "node3"), false)};
        Relationship[] rel = new Relationship[]{new HttpRelationship("0", 0L, "0", 0L, "1", 1L, "KNOWS", Map.of("name", "rel0"), false, (i, b) -> Optional.of(node[Math.toIntExact(i)])), new HttpRelationship("1", 1L, "2", 2L, "3", 3L, "LOVES", Map.of("name", "rel1"), false, (i, b) -> Optional.of(node[Math.toIntExact(i)]))};
        Mockito.when((Object)this.internalTransaction.getRelationshipById(ArgumentMatchers.anyLong())).thenAnswer(invocation -> rel[((Number)invocation.getArgument(0, Number.class)).intValue()]);
        Mockito.when((Object)this.internalTransaction.getNodeById(ArgumentMatchers.anyLong())).thenAnswer(invocation -> node[((Number)invocation.getArgument(0, Number.class)).intValue()]);
        Map<String, Relationship> resultRow1 = Map.of("node", node[0], "rel", rel[0]);
        Map<String, Relationship> resultRow2 = Map.of("node", node[2], "rel", rel[1]);
        ExecutionResultSerializerTest.writeStatementStart(this.serializer, List.of(ResultDataContent.row, ResultDataContent.graph), "node", "rel");
        ExecutionResultSerializerTest.writeRecord(this.serializer, resultRow1, "node", "rel");
        ExecutionResultSerializerTest.writeRecord(this.serializer, resultRow2, "node", "rel");
        ExecutionResultSerializerTest.writeStatementEnd(this.serializer);
        ExecutionResultSerializerTest.writeTransactionInfo(this.serializer);
        String result = this.output.toString(StandardCharsets.UTF_8);
        String node0 = "{\"id\":\"0\",\"elementId\":\"0\",\"labels\":[\"Node\"],\"properties\":{\"name\":\"node0\"}}";
        String node1 = "{\"id\":\"1\",\"elementId\":\"1\",\"labels\":[],\"properties\":{\"name\":\"node1\"}}";
        String node2 = "{\"id\":\"2\",\"elementId\":\"2\",\"labels\":[\"This\",\"That\"],\"properties\":{\"name\":\"node2\"}}";
        String node3 = "{\"id\":\"3\",\"elementId\":\"3\",\"labels\":[\"Other\"],\"properties\":{\"name\":\"node3\"}}";
        String rel0 = "\"relationships\":[{\"id\":\"0\",\"elementId\":\"0\",\"type\":\"KNOWS\",\"startNode\":\"0\",\"startNodeElementId\":\"0\",\"endNode\":\"1\",\"endNodeElementId\":\"1\",\"properties\":{\"name\":\"rel0\"}}]}";
        String rel1 = "\"relationships\":[{\"id\":\"1\",\"elementId\":\"1\",\"type\":\"LOVES\",\"startNode\":\"2\",\"startNodeElementId\":\"2\",\"endNode\":\"3\",\"endNodeElementId\":\"3\",\"properties\":{\"name\":\"rel1\"}}]}";
        String row0 = "{\"row\":[{\"name\":\"node0\"},{\"name\":\"rel0\"}],\"meta\":[{\"id\":0,\"elementId\":\"0\",\"type\":\"node\",\"deleted\":false},{\"id\":0,\"elementId\":\"0\",\"type\":\"relationship\",\"deleted\":false}],\"graph\":{\"nodes\":[";
        String row1 = "{\"row\":[{\"name\":\"node2\"},{\"name\":\"rel1\"}],\"meta\":[{\"id\":2,\"elementId\":\"2\",\"type\":\"node\",\"deleted\":false},{\"id\":1,\"elementId\":\"1\",\"type\":\"relationship\",\"deleted\":false}],\"graph\":{\"nodes\":[";
        int n0 = result.indexOf(node0);
        int n1 = result.indexOf(node1);
        int n2 = result.indexOf(node2);
        int n3 = result.indexOf(node3);
        int r0 = result.indexOf(rel0);
        int r1 = result.indexOf(rel1);
        int row0Index = result.indexOf(row0);
        int row1Index = result.indexOf(row1);
        org.junit.jupiter.api.Assertions.assertTrue((row0Index > 0 ? 1 : 0) != 0, (String)"result should contain row0");
        org.junit.jupiter.api.Assertions.assertTrue((row1Index > row0Index ? 1 : 0) != 0, (String)"result should contain row1 after row0");
        org.junit.jupiter.api.Assertions.assertTrue((n0 > row0Index ? 1 : 0) != 0, (String)"result should contain node0 after row0");
        org.junit.jupiter.api.Assertions.assertTrue((n1 > row0Index ? 1 : 0) != 0, (String)"result should contain node1 after row0");
        org.junit.jupiter.api.Assertions.assertTrue((n2 > row1Index ? 1 : 0) != 0, (String)"result should contain node2 after row1");
        org.junit.jupiter.api.Assertions.assertTrue((n3 > row1Index ? 1 : 0) != 0, (String)"result should contain node3 after row1");
        org.junit.jupiter.api.Assertions.assertTrue((r0 > n0 && r0 > n1 ? 1 : 0) != 0, (String)"result should contain rel0 after node0 and node1");
        org.junit.jupiter.api.Assertions.assertTrue((r1 > n2 && r1 > n3 ? 1 : 0) != 0, (String)"result should contain rel1 after node2 and node3");
    }

    @Test
    void shouldProduceResultStreamWithLegacyRestFormat() throws Exception {
        Node[] node = new Node[]{new HttpNode("0", 0L, Collections.emptyList(), Map.of("name", "node0"), false), new HttpNode("1", 1L, Collections.emptyList(), Map.of("name", "node1"), false), new HttpNode("2", 2L, Collections.emptyList(), Map.of("name", "node2"), false)};
        Relationship[] rel = new Relationship[]{new HttpRelationship("0", 0L, "0", 0L, "1", 1L, "KNOWS", Map.of("name", "rel0"), false, (ignoredA, ignoredB) -> Optional.empty()), new HttpRelationship("1", 1L, "2", 2L, "1", 1L, "LOVES", Map.of("name", "rel1"), false, (ignoredA, ignoredB) -> Optional.empty())};
        Path path = GraphMock.path((Node)node[0], (Link[])new Link[]{GraphMock.link((Relationship)rel[0], (Node)node[1]), GraphMock.link((Relationship)rel[1], (Node)node[2])});
        this.serializer = ExecutionResultSerializerTest.getSerializerWith(this.output, "http://base.uri/");
        Map<String, Map<String, Relationship>> resultRow = Map.of("node", node[0], "rel", rel[0], "path", path, "map", Map.of("n1", node[1], "r1", rel[1]));
        ExecutionResultSerializerTest.writeStatementStart(this.serializer, Collections.singletonList(ResultDataContent.rest), "node", "rel", "path", "map");
        ExecutionResultSerializerTest.writeRecord(this.serializer, resultRow, "node", "rel", "path", "map");
        ExecutionResultSerializerTest.writeStatementEnd(this.serializer);
        ExecutionResultSerializerTest.writeTransactionInfo(this.serializer);
        String result = this.output.toString(StandardCharsets.UTF_8);
        JsonNode json = JsonHelper.jsonNode((String)result);
        HashMap<String, Integer> columns = new HashMap<String, Integer>();
        int col = 0;
        JsonNode results = json.get("results").get(0);
        for (JsonNode column : results.get("columns")) {
            columns.put(column.asText(), col++);
        }
        JsonNode row = results.get("data").get(0).get("rest");
        JsonNode jsonNode = row.get(((Integer)columns.get("node")).intValue());
        JsonNode jsonRel = row.get(((Integer)columns.get("rel")).intValue());
        JsonNode jsonPath = row.get(((Integer)columns.get("path")).intValue());
        JsonNode jsonMap = row.get(((Integer)columns.get("map")).intValue());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"http://base.uri/node/0", (Object)jsonNode.get("self").asText());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"http://base.uri/relationship/0", (Object)jsonRel.get("self").asText());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)jsonPath.get("length").asInt());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"http://base.uri/node/0", (Object)jsonPath.get("start").asText());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"http://base.uri/node/2", (Object)jsonPath.get("end").asText());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"http://base.uri/node/1", (Object)jsonMap.get("n1").get("self").asText());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"http://base.uri/relationship/1", (Object)jsonMap.get("r1").get("self").asText());
    }

    @Test
    void shouldProduceResultStreamWithLegacyRestFormatAndNestedMaps() throws Exception {
        this.serializer = ExecutionResultSerializerTest.getSerializerWith(this.output, "http://base.uri/");
        Map<String, Map<String, Map<String, List<Map<String, String>>>>> resultRow = Map.of("map", Map.of("one", Map.of("two", List.of("wait for it...", Map.of("three", "GO!")))));
        ExecutionResultSerializerTest.writeStatementStart(this.serializer, Collections.singletonList(ResultDataContent.rest), "map");
        ExecutionResultSerializerTest.writeRecord(this.serializer, resultRow, "map");
        ExecutionResultSerializerTest.writeStatementEnd(this.serializer);
        ExecutionResultSerializerTest.writeTransactionInfo(this.serializer);
        String result = this.output.toString(StandardCharsets.UTF_8);
        JsonNode json = JsonHelper.jsonNode((String)result);
        HashMap<String, Integer> columns = new HashMap<String, Integer>();
        int col = 0;
        JsonNode results = json.get("results").get(0);
        for (JsonNode column : results.get("columns")) {
            columns.put(column.asText(), col++);
        }
        JsonNode row = results.get("data").get(0).get("rest");
        JsonNode jsonMap = row.get(((Integer)columns.get("map")).intValue());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"wait for it...", (Object)jsonMap.get("one").get("two").get(0).asText());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"GO!", (Object)jsonMap.get("one").get("two").get(1).get("three").asText());
    }

    @Test
    void shouldSerializePlanWithoutChildButAllKindsOfSupportedArguments() throws Exception {
        this.serializer = ExecutionResultSerializerTest.getSerializerWith(this.output, "http://base.uri/");
        String operatorType = "Ich habe einen Plan";
        Map<String, Object> args = Map.of("string", "A String", "bool", true, "number", 1, "double", 2.3, "listOfInts", List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)), "listOfListOfInts", List.of(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3))));
        ExecutionPlanDescription planDescription = ExecutionResultSerializerTest.mockedPlanDescription(operatorType, NO_IDS, args, NO_PLANS);
        ExecutionResultSerializerTest.writeStatementStart(this.serializer, Collections.singletonList(ResultDataContent.rest), new String[0]);
        ExecutionResultSerializerTest.writeRecord(this.serializer, Collections.emptyMap(), new String[0]);
        ExecutionResultSerializerTest.writeStatementEnd(this.serializer, planDescription, Collections.emptyList());
        ExecutionResultSerializerTest.writeTransactionInfo(this.serializer);
        String resultString = this.output.toString(StandardCharsets.UTF_8);
        ExecutionResultSerializerTest.assertIsPlanRoot(resultString);
        Map<String, ?> rootMap = ExecutionResultSerializerTest.planRootMap(resultString);
        org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new String[]{"operatorType", "identifiers", "children", "string", "bool", "number", "double", "listOfInts", "listOfListOfInts"}), rootMap.keySet());
        org.junit.jupiter.api.Assertions.assertEquals((Object)operatorType, rootMap.get("operatorType"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)args.get("string"), rootMap.get("string"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)args.get("bool"), rootMap.get("bool"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)args.get("number"), rootMap.get("number"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)args.get("double"), rootMap.get("double"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)args.get("listOfInts"), rootMap.get("listOfInts"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)args.get("listOfListOfInts"), rootMap.get("listOfListOfInts"));
    }

    @Test
    void shouldSerializePlanWithoutChildButWithIdentifiers() throws Exception {
        this.serializer = ExecutionResultSerializerTest.getSerializerWith(this.output, "http://base.uri/");
        String operatorType = "Ich habe einen Plan";
        String id1 = "id1";
        String id2 = "id2";
        String id3 = "id3";
        ExecutionPlanDescription planDescription = ExecutionResultSerializerTest.mockedPlanDescription(operatorType, Iterators.asSet((Object[])new String[]{id1, id2, id3}), NO_ARGS, NO_PLANS);
        ExecutionResultSerializerTest.writeStatementStart(this.serializer, Collections.singletonList(ResultDataContent.rest), new String[0]);
        ExecutionResultSerializerTest.writeRecord(this.serializer, Collections.emptyMap(), new String[0]);
        ExecutionResultSerializerTest.writeStatementEnd(this.serializer, planDescription, Collections.emptyList());
        ExecutionResultSerializerTest.writeTransactionInfo(this.serializer);
        String resultString = this.output.toString(StandardCharsets.UTF_8);
        ExecutionResultSerializerTest.assertIsPlanRoot(resultString);
        Map<String, ?> rootMap = ExecutionResultSerializerTest.planRootMap(resultString);
        org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new String[]{"operatorType", "identifiers", "children"}), rootMap.keySet());
        org.junit.jupiter.api.Assertions.assertEquals((Object)operatorType, rootMap.get("operatorType"));
        org.junit.jupiter.api.Assertions.assertEquals(List.of(id2, id1, id3), rootMap.get("identifiers"));
    }

    @Test
    void shouldSerializePlanWithChildren() throws Exception {
        this.serializer = ExecutionResultSerializerTest.getSerializerWith(this.output, "http://base.uri/");
        String leftId = "leftId";
        String rightId = "rightId";
        String parentId = "parentId";
        ExecutionPlanDescription left = ExecutionResultSerializerTest.mockedPlanDescription("child", Iterators.asSet((Object[])new String[]{leftId}), Map.of("id", 1), NO_PLANS);
        ExecutionPlanDescription right = ExecutionResultSerializerTest.mockedPlanDescription("child", Iterators.asSet((Object[])new String[]{rightId}), Map.of("id", 2), NO_PLANS);
        ExecutionPlanDescription parent = ExecutionResultSerializerTest.mockedPlanDescription("parent", Iterators.asSet((Object[])new String[]{parentId}), Map.of("id", 0), List.of(left, right));
        ExecutionResultSerializerTest.writeStatementStart(this.serializer, Collections.singletonList(ResultDataContent.rest), new String[0]);
        ExecutionResultSerializerTest.writeRecord(this.serializer, Collections.emptyMap(), new String[0]);
        ExecutionResultSerializerTest.writeStatementEnd(this.serializer, parent, Collections.emptyList());
        ExecutionResultSerializerTest.writeTransactionInfo(this.serializer);
        String result = this.output.toString(StandardCharsets.UTF_8);
        JsonNode root = ExecutionResultSerializerTest.assertIsPlanRoot(result);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"parent", (Object)root.get("operatorType").asText());
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)root.get("id").asLong());
        org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new String[]{parentId}), ExecutionResultSerializerTest.identifiersOf(root));
        HashSet<Integer> childIds = new HashSet<Integer>();
        HashSet<Set<String>> identifiers = new HashSet<Set<String>>();
        for (JsonNode child : root.get("children")) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)child.isObject(), (String)"Expected object");
            org.junit.jupiter.api.Assertions.assertEquals((Object)"child", (Object)child.get("operatorType").asText());
            identifiers.add(ExecutionResultSerializerTest.identifiersOf(child));
            childIds.add(child.get("id").asInt());
        }
        org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new Integer[]{1, 2}), childIds);
        org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new Set[]{Iterators.asSet((Object[])new String[]{leftId}), Iterators.asSet((Object[])new String[]{rightId})}), identifiers);
    }

    @Test
    void shouldReturnNotifications() {
        NotificationImplementation notification = NotificationCodeWithDescription.cartesianProduct((InputPosition)new InputPosition(1, 2, 3), (String)"a", (String)"(), ()");
        List<NotificationImplementation> notifications = Collections.singletonList(notification);
        Map<String, String> row = Map.of("column1", "value1", "column2", "value2");
        ExecutionResultSerializerTest.writeStatementStart(this.serializer, "column1", "column2");
        ExecutionResultSerializerTest.writeRecord(this.serializer, row, "column1", "column2");
        ExecutionResultSerializerTest.writeStatementEnd(this.serializer, null, notifications);
        ExecutionResultSerializerTest.writeTransactionInfo(this.serializer, "commit/uri/1");
        String result = this.output.toString(StandardCharsets.UTF_8);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"{\"results\":[{\"columns\":[\"column1\",\"column2\"],\"data\":[{\"row\":[\"value1\",\"value2\"],\"meta\":[null,null]}]}],\"notifications\":[{\"code\":\"Neo.ClientNotification.Statement.CartesianProduct\",\"severity\":\"INFORMATION\",\"title\":\"This query builds a cartesian product between disconnected patterns.\",\"description\":\"If a part of a query contains multiple disconnected patterns, this will build a cartesian product between all those parts. This may produce a large amount of data and slow down query processing. While occasionally intended, it may often be possible to reformulate the query that avoids the use of this cross product, perhaps by adding a relationship between the different parts or by using OPTIONAL MATCH (a)\",\"position\":{\"offset\":1,\"line\":2,\"column\":3}}],\"errors\":[],\"commit\":\"commit/uri/1\"}", (Object)result);
    }

    @Test
    void shouldNotReturnNotificationsWhenEmptyNotifications() {
        Map<String, String> row = Map.of("column1", "value1", "column2", "value2");
        ExecutionResultSerializerTest.writeStatementStart(this.serializer, "column1", "column2");
        ExecutionResultSerializerTest.writeRecord(this.serializer, row, "column1", "column2");
        ExecutionResultSerializerTest.writeStatementEnd(this.serializer, null, Collections.emptyList());
        ExecutionResultSerializerTest.writeTransactionInfo(this.serializer, "commit/uri/1");
        String result = this.output.toString(StandardCharsets.UTF_8);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"{\"results\":[{\"columns\":[\"column1\",\"column2\"],\"data\":[{\"row\":[\"value1\",\"value2\"],\"meta\":[null,null]}]}],\"errors\":[],\"commit\":\"commit/uri/1\"}", (Object)result);
    }

    @Test
    void shouldNotReturnPositionWhenEmptyPosition() {
        Map<String, String> row = Map.of("column1", "value1", "column2", "value2");
        NotificationImplementation notification = NotificationCodeWithDescription.cartesianProduct((InputPosition)InputPosition.empty, (String)"a", (String)"(), ()");
        List<NotificationImplementation> notifications = Collections.singletonList(notification);
        ExecutionResultSerializerTest.writeStatementStart(this.serializer, "column1", "column2");
        ExecutionResultSerializerTest.writeRecord(this.serializer, row, "column1", "column2");
        ExecutionResultSerializerTest.writeStatementEnd(this.serializer, null, notifications);
        ExecutionResultSerializerTest.writeTransactionInfo(this.serializer, "commit/uri/1");
        String result = this.output.toString(StandardCharsets.UTF_8);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"{\"results\":[{\"columns\":[\"column1\",\"column2\"],\"data\":[{\"row\":[\"value1\",\"value2\"],\"meta\":[null,null]}]}],\"notifications\":[{\"code\":\"Neo.ClientNotification.Statement.CartesianProduct\",\"severity\":\"INFORMATION\",\"title\":\"This query builds a cartesian product between disconnected patterns.\",\"description\":\"If a part of a query contains multiple disconnected patterns, this will build a cartesian product between all those parts. This may produce a large amount of data and slow down query processing. While occasionally intended, it may often be possible to reformulate the query that avoids the use of this cross product, perhaps by adding a relationship between the different parts or by using OPTIONAL MATCH (a)\"}],\"errors\":[],\"commit\":\"commit/uri/1\"}", (Object)result);
    }

    private static ExecutionResultSerializer getSerializerWith(OutputStream output) {
        return ExecutionResultSerializerTest.getSerializerWith(output, null);
    }

    private static ExecutionResultSerializer getSerializerWith(OutputStream output, String uri) {
        return new ExecutionResultSerializer(Collections.emptyMap(), uri == null ? null : URI.create(uri), Neo4jJsonCodec.class, JSON_FACTORY, output);
    }

    private static void writeStatementStart(ExecutionResultSerializer serializer, String ... columns) {
        ExecutionResultSerializerTest.writeStatementStart(serializer, null, columns);
    }

    private static void writeStatementStart(ExecutionResultSerializer serializer, List<ResultDataContent> resultDataContents, String ... columns) {
        serializer.writeStatementStart(new StatementStartEvent(null, Arrays.asList(columns)), new InputStatement(null, null, false, resultDataContents));
    }

    private static void writeRecord(ExecutionResultSerializer serializer, Map<String, ?> row, String ... columns) {
        serializer.writeRecord(new RecordEvent(Arrays.asList(columns), row::get));
    }

    private static void writeStatementEnd(ExecutionResultSerializer serializer) {
        ExecutionResultSerializerTest.writeStatementEnd(serializer, null, Collections.emptyList());
    }

    private static void writeStatementEnd(ExecutionResultSerializer serializer, ExecutionPlanDescription planDescription, Iterable<Notification> notifications) {
        QueryExecutionType queryExecutionType = null != planDescription ? QueryExecutionType.profiled((QueryExecutionType.QueryType)QueryExecutionType.QueryType.READ_WRITE) : QueryExecutionType.query((QueryExecutionType.QueryType)QueryExecutionType.QueryType.READ_WRITE);
        serializer.writeStatementEnd(new StatementEndEvent(queryExecutionType, null, planDescription, notifications));
    }

    private static void writeTransactionInfo(ExecutionResultSerializer serializer) {
        serializer.writeTransactionInfo(new TransactionInfoEvent(TransactionNotificationState.NO_TRANSACTION, null, -1L, null));
    }

    private static void writeTransactionInfo(ExecutionResultSerializer serializer, String commitUri) {
        serializer.writeTransactionInfo(new TransactionInfoEvent(TransactionNotificationState.NO_TRANSACTION, URI.create(commitUri), -1L, null));
    }

    private static void writeError(ExecutionResultSerializer serializer, Status status, String message) {
        serializer.writeFailure(new FailureEvent(status, message));
    }

    private static Set<String> identifiersOf(JsonNode root) {
        HashSet<String> parentIds = new HashSet<String>();
        for (JsonNode id : root.get("identifiers")) {
            parentIds.add(id.asText());
        }
        return parentIds;
    }

    private static ExecutionPlanDescription mockedPlanDescription(String operatorType, Set<String> identifiers, Map<String, Object> args, List<ExecutionPlanDescription> children) {
        ExecutionPlanDescription planDescription = (ExecutionPlanDescription)Mockito.mock(ExecutionPlanDescription.class);
        Mockito.when((Object)planDescription.getChildren()).thenReturn(children);
        Mockito.when((Object)planDescription.getName()).thenReturn((Object)operatorType);
        Mockito.when((Object)planDescription.getArguments()).thenReturn(args);
        Mockito.when((Object)planDescription.getIdentifiers()).thenReturn(identifiers);
        return planDescription;
    }

    private static JsonNode assertIsPlanRoot(String result) throws JsonParseException {
        JsonNode json = JsonHelper.jsonNode((String)result);
        JsonNode results = json.get("results").get(0);
        JsonNode plan = results.get("plan");
        org.junit.jupiter.api.Assertions.assertTrue((plan != null && plan.isObject() ? 1 : 0) != 0, (String)"Expected plan to be an object");
        JsonNode root = plan.get("root");
        org.junit.jupiter.api.Assertions.assertTrue((root != null && root.isObject() ? 1 : 0) != 0, (String)"Expected plan to be an object");
        return root;
    }

    private static Map<String, ?> planRootMap(String resultString) throws JsonParseException {
        Map resultMap = (Map)((List)((Map)JsonHelper.readJson((String)resultString)).get("results")).get(0);
        Map planMap = (Map)resultMap.get("plan");
        return (Map)planMap.get("root");
    }

    private static Path mockPathWithHttpEntities(Map<String, Object> startNodeProperties, Map<String, Object> relationshipProperties, Map<String, Object> endNodeProperties) {
        HttpNode startNode = new HttpNode("1", 1L, Collections.emptyList(), startNodeProperties, false);
        HttpNode endNode = new HttpNode("2", 2L, Collections.emptyList(), endNodeProperties, false);
        HttpRelationship relationship = new HttpRelationship("1", 1L, "1", 1L, "2", 2L, "RELATED", relationshipProperties, false, (ignoredA, ignoredB) -> Optional.empty());
        return GraphMock.path((Node)startNode, (Link[])new Link[]{Link.link((Relationship)relationship, (Node)endNode)});
    }
}

