/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.web;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.rest.web.CorsFilter;

class CorsFilterTest {
    private final HttpServletRequest emptyRequest = CorsFilterTest.requestMock(Collections.emptyList(), Collections.emptyList());
    private final HttpServletResponse response = CorsFilterTest.responseMock();
    private final FilterChain chain = CorsFilterTest.filterChainMock();
    private final CorsFilter filter = new CorsFilter((InternalLogProvider)NullLogProvider.getInstance(), "*");

    CorsFilterTest() {
    }

    @Test
    void shouldCallChainDoFilter() throws Exception {
        this.filter.doFilter((ServletRequest)this.emptyRequest, (ServletResponse)this.response, this.chain);
        ((FilterChain)Mockito.verify((Object)this.chain)).doFilter((ServletRequest)this.emptyRequest, (ServletResponse)this.response);
    }

    @Test
    void shouldSetAccessControlAllowOrigin() throws Exception {
        this.filter.doFilter((ServletRequest)this.emptyRequest, (ServletResponse)this.response, CorsFilterTest.filterChainMock());
        ((HttpServletResponse)Mockito.verify((Object)this.response)).setHeader("Access-Control-Allow-Origin", "*");
    }

    @Test
    void shouldAttachNoHttpMethodsToAccessControlAllowMethodsWhenHeaderIsEmpty() throws Exception {
        this.filter.doFilter((ServletRequest)this.emptyRequest, (ServletResponse)this.response, this.chain);
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.never())).addHeader((String)ArgumentMatchers.eq((Object)"Access-Control-Allow-Methods"), ArgumentMatchers.anyString());
    }

    @Test
    void shouldAttachNoHttpMethodsToAccessControlAllowMethodsWhenHeaderIsNull() throws Exception {
        HttpServletRequest request = CorsFilterTest.requestMock();
        Mockito.when((Object)request.getHeaders("Access-Control-Request-Method")).thenReturn(null);
        this.filter.doFilter((ServletRequest)request, (ServletResponse)this.response, this.chain);
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.never())).addHeader((String)ArgumentMatchers.eq((Object)"Access-Control-Allow-Methods"), ArgumentMatchers.anyString());
    }

    @Test
    void shouldAttachValidHttpMethodsToAccessControlAllowMethods() throws Exception {
        List<String> accessControlRequestMethods = Arrays.asList("GET", "WRONG", "POST", "TAKE", "CONNECT");
        HttpServletRequest request = CorsFilterTest.requestMock(accessControlRequestMethods, Collections.emptyList());
        this.filter.doFilter((ServletRequest)request, (ServletResponse)this.response, this.chain);
        ((HttpServletResponse)Mockito.verify((Object)this.response)).addHeader("Access-Control-Allow-Methods", "GET");
        ((HttpServletResponse)Mockito.verify((Object)this.response)).addHeader("Access-Control-Allow-Methods", "POST");
        ((HttpServletResponse)Mockito.verify((Object)this.response)).addHeader("Access-Control-Allow-Methods", "CONNECT");
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.never())).addHeader("Access-Control-Allow-Methods", "TAKE");
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.never())).addHeader("Access-Control-Allow-Methods", "WRONG");
    }

    @Test
    void shouldAttachNoRequestHeadersToAccessControlAllowHeadersWhenHeaderIsEmpty() throws Exception {
        this.filter.doFilter((ServletRequest)this.emptyRequest, (ServletResponse)this.response, this.chain);
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.never())).addHeader((String)ArgumentMatchers.eq((Object)"Access-Control-Allow-Headers"), ArgumentMatchers.anyString());
    }

    @Test
    void shouldAttachNoRequestHeadersToAccessControlAllowHeadersWhenHeaderIsNull() throws Exception {
        HttpServletRequest request = CorsFilterTest.requestMock();
        Mockito.when((Object)request.getHeaders("Access-Control-Request-Headers")).thenReturn(null);
        this.filter.doFilter((ServletRequest)request, (ServletResponse)this.response, this.chain);
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.never())).addHeader((String)ArgumentMatchers.eq((Object)"Access-Control-Allow-Headers"), ArgumentMatchers.anyString());
    }

    @Test
    void shouldAttachValidRequestHeadersToAccessControlAllowHeaders() throws Exception {
        List<String> accessControlRequestHeaders = Arrays.asList("Accept", "X-Wrong\nHeader", "Content-Type", "Accept\r", "Illegal\r\nHeader", "", null, "   ");
        HttpServletRequest request = CorsFilterTest.requestMock(Collections.emptyList(), accessControlRequestHeaders);
        this.filter.doFilter((ServletRequest)request, (ServletResponse)this.response, this.chain);
        ((HttpServletResponse)Mockito.verify((Object)this.response)).addHeader("Access-Control-Allow-Headers", "Accept");
        ((HttpServletResponse)Mockito.verify((Object)this.response)).addHeader("Access-Control-Allow-Headers", "Content-Type");
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.never())).addHeader("Access-Control-Allow-Headers", null);
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.never())).addHeader("Access-Control-Allow-Headers", "");
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.never())).addHeader("Access-Control-Allow-Headers", "   ");
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.never())).addHeader("Access-Control-Allow-Headers", "X-Wrong\nHeader");
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.never())).addHeader("Access-Control-Allow-Headers", "Accept\r");
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.never())).addHeader("Access-Control-Allow-Headers", "Illegal\r\nHeader");
    }

    private static HttpServletRequest requestMock() {
        return CorsFilterTest.requestMock(Collections.emptyList(), Collections.emptyList());
    }

    private static HttpServletRequest requestMock(List<String> accessControlRequestMethods, List<String> accessControlRequestHeaders) {
        HttpServletRequest mock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)mock.getHeaders("Access-Control-Request-Method")).thenReturn(Collections.enumeration(accessControlRequestMethods));
        Mockito.when((Object)mock.getHeaders("Access-Control-Request-Headers")).thenReturn(Collections.enumeration(accessControlRequestHeaders));
        return mock;
    }

    private static HttpServletResponse responseMock() {
        return (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
    }

    private static FilterChain filterChainMock() {
        return (FilterChain)Mockito.mock(FilterChain.class);
    }
}

