/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web;

import java.net.URI;
import java.net.URISyntaxException;
import org.neo4j.configuration.helpers.SocketAddress;

public final class SimpleUriBuilder {
    private SimpleUriBuilder() {
    }

    public static URI buildURI(SocketAddress address, boolean isSsl) {
        Object scheme = "http";
        if (isSsl) {
            scheme = (String)scheme + "s";
        }
        try {
            int port = address.getPort();
            if (!isSsl && port == 80 || isSsl && port == 443) {
                return new URI((String)scheme, address.getHostname(), "/", null);
            }
            return new URI((String)scheme, null, address.getHostname(), port, "/", null, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

