/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher;

import java.net.URI;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import org.neo4j.bolt.protocol.common.fsm.response.ResponseHandler;
import org.neo4j.bolt.tx.error.TransactionCreationException;
import org.neo4j.bolt.tx.error.TransactionException;
import org.neo4j.bolt.tx.error.statement.StatementException;
import org.neo4j.exceptions.KernelException;
import org.neo4j.exceptions.Neo4jException;
import org.neo4j.fabric.executor.FabricException;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.WriteOperationsNotAllowedException;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.util.DefaultValueMapper;
import org.neo4j.logging.InternalLog;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryPool;
import org.neo4j.router.QueryRouterException;
import org.neo4j.server.http.cypher.CachingWriter;
import org.neo4j.server.http.cypher.OutputEventStream;
import org.neo4j.server.http.cypher.TransactionHandle;
import org.neo4j.server.http.cypher.TransactionIndependentValueMapper;
import org.neo4j.server.http.cypher.consumer.OutputEventStreamResponseHandler;
import org.neo4j.server.http.cypher.consumer.SingleNodeResponseHandler;
import org.neo4j.server.http.cypher.format.api.ConnectionException;
import org.neo4j.server.http.cypher.format.api.InputEventStream;
import org.neo4j.server.http.cypher.format.api.InputFormatException;
import org.neo4j.server.http.cypher.format.api.OutputFormatException;
import org.neo4j.server.http.cypher.format.api.Statement;
import org.neo4j.server.http.cypher.format.api.TransactionNotificationState;
import org.neo4j.server.rest.Neo4jError;
import org.neo4j.values.ValueMapper;

class Invocation {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(Invocation.class);
    private final InternalLog log;
    private final TransactionHandle transactionHandle;
    private final InputEventStream inputEventStream;
    private boolean finishWithCommit;
    private final URI commitUri;
    private final MemoryPool memoryPool;
    private OutputEventStream outputEventStream;
    private Neo4jError neo4jError;
    private Exception outputError;
    private TransactionNotificationState transactionNotificationState = TransactionNotificationState.NO_TRANSACTION;

    Invocation(InternalLog log, TransactionHandle transactionHandle, URI commitUri, MemoryPool memoryPool, InputEventStream inputEventStream, boolean finishWithCommit) {
        this.log = log;
        this.transactionHandle = transactionHandle;
        this.commitUri = commitUri;
        this.memoryPool = memoryPool;
        this.inputEventStream = inputEventStream;
        this.finishWithCommit = finishWithCommit;
    }

    void execute(OutputEventStream outputEventStream) {
        this.outputEventStream = outputEventStream;
        if (!this.executePreStatementsTransactionLogic()) {
            this.sendTransactionStateInformation();
            return;
        }
        this.executeStatements();
        this.executePostStatementsTransactionLogic();
        this.sendTransactionStateInformation();
        if (this.outputError != null) {
            throw new RuntimeException(this.outputError);
        }
    }

    private boolean executePreStatementsTransactionLogic() {
        try {
            this.transactionHandle.ensureActiveTransaction();
            this.transactionNotificationState = TransactionNotificationState.OPEN;
        }
        catch (Exception e) {
            Throwable cause;
            Throwable rootCause = e;
            if (e instanceof TransactionCreationException && (cause = e.getCause()) != null) {
                rootCause = cause;
            }
            if (rootCause instanceof AuthorizationViolationException) {
                AuthorizationViolationException se = (AuthorizationViolationException)rootCause;
                this.handleNeo4jError(se.status(), se);
                return false;
            }
            if (!this.transactionHandle.hasTransactionContext()) {
                this.log.error("Failed to start transaction", rootCause);
                this.handleNeo4jError((Status)Status.Transaction.TransactionStartFailed, rootCause);
            } else {
                this.log.error("Failed to resume transaction", rootCause);
                this.handleNeo4jError((Status)Status.Transaction.TransactionNotFound, rootCause);
            }
            return false;
        }
        return true;
    }

    private void executePostStatementsTransactionLogic() {
        if (this.outputError != null && this.transactionHandle.isImplicit()) {
            try {
                this.transactionHandle.rollback();
                this.transactionNotificationState = TransactionNotificationState.ROLLED_BACK;
            }
            catch (Exception e) {
                this.log.error("Failed to Rollback of implicit transaction after output error", (Throwable)e);
                this.transactionNotificationState = TransactionNotificationState.UNKNOWN;
            }
            return;
        }
        if (this.neo4jError != null && this.neo4jError.status().code().classification().rollbackTransaction()) {
            try {
                this.transactionHandle.rollback();
                this.transactionNotificationState = TransactionNotificationState.ROLLED_BACK;
            }
            catch (Exception e) {
                this.log.error("Failed to roll back transaction.", (Throwable)e);
                this.handleNeo4jError((Status)Status.Transaction.TransactionRollbackFailed, e);
                this.transactionNotificationState = TransactionNotificationState.UNKNOWN;
            }
            return;
        }
        if (this.outputError == null && this.finishWithCommit) {
            try {
                this.transactionHandle.commit();
                this.transactionNotificationState = TransactionNotificationState.COMMITTED;
            }
            catch (Exception e) {
                if (e.getCause() instanceof Status.HasStatus) {
                    this.handleNeo4jError(((Status.HasStatus)e.getCause()).status(), e);
                } else {
                    this.log.error("Failed to commit transaction.", (Throwable)e);
                    this.handleNeo4jError((Status)Status.Transaction.TransactionCommitFailed, e);
                }
                this.transactionNotificationState = TransactionNotificationState.UNKNOWN;
            }
            return;
        }
        this.transactionHandle.suspendTransaction();
    }

    private void executeStatements() {
        try {
            while (this.outputError == null) {
                this.memoryPool.reserveHeap(Statement.SHALLOW_SIZE);
                try {
                    Statement statement = this.readStatement();
                    if (statement == null) {
                        return;
                    }
                    this.executeStatement(statement);
                }
                finally {
                    this.memoryPool.releaseHeap(Statement.SHALLOW_SIZE);
                }
            }
        }
        catch (InputFormatException e) {
            this.handleNeo4jError((Status)Status.Request.InvalidFormat, e);
        }
        catch (KernelException | Neo4jException | WriteOperationsNotAllowedException | AuthorizationViolationException e) {
            this.handleNeo4jError(((Status.HasStatus)e).status(), e);
        }
        catch (DeadlockDetectedException e) {
            this.handleNeo4jError((Status)Status.Transaction.DeadlockDetected, e);
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (e instanceof FabricException && ((FabricException)e).status().equals(Status.Statement.AccessMode)) {
                this.handleNeo4jError(((FabricException)e).status(), e);
            }
            if (cause instanceof Status.HasStatus) {
                this.handleNeo4jError(((Status.HasStatus)cause).status(), cause);
            }
            this.handleNeo4jError((Status)Status.Statement.ExecutionFailed, e);
        }
    }

    private Statement readStatement() {
        try {
            return this.inputEventStream.read();
        }
        catch (ConnectionException e) {
            this.handleOutputError(e);
            return null;
        }
    }

    private void executeStatement(Statement statement) throws Exception {
        org.neo4j.bolt.tx.statement.Statement result = this.transactionHandle.executeStatement(statement);
        this.writeResult(statement, result);
    }

    private void writeResult(Statement statement, org.neo4j.bolt.tx.statement.Statement boltStatement) throws StatementException {
        CachingWriter cacheWriter = new CachingWriter((ValueMapper)new DefaultValueMapper(null));
        cacheWriter.setGetNodeById(this.createGetNodeByIdFunction(cacheWriter));
        TransactionIndependentValueMapper valueMapper = new TransactionIndependentValueMapper(cacheWriter);
        try {
            OutputEventStreamResponseHandler resultConsumer = new OutputEventStreamResponseHandler(this.outputEventStream, statement, valueMapper, this.transactionHandle);
            boltStatement.consume((ResponseHandler)resultConsumer, -1L);
        }
        catch (ConnectionException | OutputFormatException e) {
            this.handleOutputError(e);
        }
    }

    private BiFunction<Long, Boolean, Optional<Node>> createGetNodeByIdFunction(CachingWriter cachingWriter) {
        return (id, isDeleted) -> {
            AtomicReference nodeReference = new AtomicReference();
            if (!isDeleted.booleanValue()) {
                try {
                    Statement statement = this.createGetNodeByIdStatement((Long)id);
                    org.neo4j.bolt.tx.statement.Statement statementMetadata = this.transactionHandle.executeStatement(statement);
                    statementMetadata.consume((ResponseHandler)new SingleNodeResponseHandler(cachingWriter, nodeReference::set), -1L);
                }
                catch (TransactionException e) {
                    this.handleNeo4jError((Status)Status.General.UnknownError, e);
                }
            }
            return Optional.ofNullable((Node)nodeReference.get());
        };
    }

    private void handleOutputError(Exception e) {
        if (this.outputError != null) {
            return;
        }
        this.outputError = e;
        this.log.error("An error has occurred while sending a response", (Throwable)e);
    }

    private void handleNeo4jError(Status status, Throwable cause) {
        Status rootCause;
        this.neo4jError = cause instanceof FabricException || cause instanceof QueryRouterException ? ((rootCause = ((Status.HasStatus)cause).status()).equals(Status.Statement.AccessMode) && cause.getMessage() != null && cause.getMessage().startsWith("Writing in read access mode not allowed") ? new Neo4jError((Status)Status.Request.Invalid, "Routing WRITE queries is not supported in clusters where Server-Side Routing is disabled.") : new Neo4jError(rootCause, cause.getCause() != null ? cause.getCause() : cause)) : new Neo4jError(status, cause);
        try {
            this.outputEventStream.writeFailure(this.neo4jError.status(), this.neo4jError.getMessage());
        }
        catch (ConnectionException | OutputFormatException e) {
            this.handleOutputError(e);
        }
    }

    private Statement createGetNodeByIdStatement(Long id) {
        return new Statement("MATCH (n) WHERE id(n) = $id RETURN n;", Map.of("id", id));
    }

    private void sendTransactionStateInformation() {
        if (this.outputError != null) {
            return;
        }
        try {
            this.outputEventStream.writeTransactionInfo(this.transactionNotificationState, this.commitUri, this.transactionHandle.getExpirationTimestamp(), this.transactionHandle.getOutputBookmark());
        }
        catch (ConnectionException | OutputFormatException e) {
            this.handleOutputError(e);
        }
    }
}

