/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher;

import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.logging.InternalLog;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.server.http.cypher.OutputEventStream;
import org.neo4j.server.http.cypher.TransactionHandle;
import org.neo4j.server.http.cypher.format.api.TransactionNotificationState;

class RollbackInvocation {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(RollbackInvocation.class);
    private final InternalLog log;
    private final TransactionHandle transactionHandle;

    RollbackInvocation(InternalLog log, TransactionHandle transactionHandle) {
        this.log = log;
        this.transactionHandle = transactionHandle;
    }

    void execute(OutputEventStream outputEventStream) {
        TransactionNotificationState transactionNotificationState = TransactionNotificationState.NO_TRANSACTION;
        try {
            if (this.transactionHandle != null) {
                this.transactionHandle.ensureActiveTransaction();
                this.transactionHandle.rollback();
                transactionNotificationState = TransactionNotificationState.ROLLED_BACK;
            }
        }
        catch (Exception e) {
            this.log.error("Failed to roll back transaction.", (Throwable)e);
            outputEventStream.writeFailure((Status)Status.Transaction.TransactionRollbackFailed, e.getMessage());
            transactionNotificationState = TransactionNotificationState.UNKNOWN;
        }
        outputEventStream.writeTransactionInfo(transactionNotificationState, null, -1L, null);
    }
}

