/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.httpv2.metrics;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.neo4j.server.httpv2.metrics.QueryAPIMetricsMonitor;

public class QueryAPIMetricsFilter
implements Filter {
    private final QueryAPIMetricsMonitor monitor;
    private final String pathSpec;

    public QueryAPIMetricsFilter(QueryAPIMetricsMonitor monitor, String pathSpec) {
        this.monitor = monitor;
        this.pathSpec = pathSpec;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        chain.doFilter(request, response);
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        if (httpServletRequest.getRequestURI().endsWith("query/v2")) {
            this.monitor.totalRequests();
            this.meterStatusCode(httpServletResponse);
            this.meterRequestedContentType(httpServletRequest);
            this.meterReturnedContentType(httpServletResponse);
        }
    }

    private void meterRequestedContentType(HttpServletRequest httpServletRequest) {
        String contentType = httpServletRequest.getContentType();
        if (contentType.contains("application/vnd.neo4j.query")) {
            this.monitor.applicationVndNeo4jQueryRequests();
        } else if (contentType.contains("application/json")) {
            this.monitor.applicationJsonRequests();
        }
    }

    private void meterReturnedContentType(HttpServletResponse httpServletResponse) {
        String contentType = httpServletResponse.getContentType();
        if (contentType.contains("application/vnd.neo4j.query")) {
            this.monitor.applicationVndNeo4jQueryResponses();
        } else if (contentType.contains("application/json")) {
            this.monitor.applicationJsonResponses();
        }
    }

    private void meterStatusCode(HttpServletResponse response) {
        if (response != null) {
            switch (response.getStatus() / 100) {
                case 2: {
                    this.monitor.successStatus();
                    break;
                }
                case 4: {
                    this.monitor.badRequestStatus();
                    break;
                }
                case 5: {
                    this.monitor.serverErrorStatus();
                    break;
                }
            }
        }
    }
}

