/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.format.output.eventsource;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.graphdb.InputPosition;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.spatial.CRS;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.notifications.NotificationCodeWithDescription;
import org.neo4j.notifications.NotificationImplementation;
import org.neo4j.server.http.cypher.TransitionalTxManagementKernelTransaction;
import org.neo4j.server.http.cypher.format.api.RecordEvent;
import org.neo4j.server.http.cypher.format.api.TransactionInfoEvent;
import org.neo4j.server.http.cypher.format.api.TransactionNotificationState;
import org.neo4j.server.http.cypher.format.jolt.v1.JoltV1Codec;
import org.neo4j.server.http.cypher.format.output.eventsource.AbstractEventSourceJoltSerializerTest;
import org.neo4j.server.http.cypher.format.output.eventsource.LineDelimitedEventSourceJoltSerializer;
import org.neo4j.server.http.cypher.format.output.json.ResultDataContent;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.test.mockito.mock.GraphMock;
import org.neo4j.test.mockito.mock.Link;
import org.neo4j.test.mockito.mock.Properties;
import org.neo4j.test.mockito.mock.Property;
import org.neo4j.test.mockito.mock.SpatialMocks;
import org.neo4j.values.storable.DurationValue;

public class LineDelimitedEventSourceJoltSerializerTest
extends AbstractEventSourceJoltSerializerTest {
    private static final Map<String, Object> NO_ARGS = Collections.emptyMap();
    private static final Set<String> NO_IDS = Collections.emptySet();
    private static final List<ExecutionPlanDescription> NO_PLANS = Collections.emptyList();
    private static final JsonFactory JSON_FACTORY = new JsonFactory().disable(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM);
    private final ByteArrayOutputStream output = new ByteArrayOutputStream();
    private LineDelimitedEventSourceJoltSerializer serializer;

    @BeforeEach
    void init() {
        TransitionalTxManagementKernelTransaction context = (TransitionalTxManagementKernelTransaction)Mockito.mock(TransitionalTxManagementKernelTransaction.class);
        KernelTransactionImplementation kernelTransaction = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        this.serializer = LineDelimitedEventSourceJoltSerializerTest.getSerializerWith(this.output);
    }

    @Test
    void shouldSerializeResponseWithCommitUriOnly() {
        this.serializer.writeTransactionInfo(new TransactionInfoEvent(TransactionNotificationState.NO_TRANSACTION, URI.create("commit/uri/1"), -1L, null));
        String result = this.output.toString(StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)"{\"info\":{\"commit\":\"commit/uri/1\"}}\n", (Object)result);
    }

    @Test
    void shouldSerializeBookmarkOnCommittedNotificationState() {
        this.serializer.writeTransactionInfo(new TransactionInfoEvent(TransactionNotificationState.COMMITTED, URI.create("commit/uri/1"), -1L, "I AM BOOKMARK!"));
        String result = this.output.toString(StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)"{\"info\":{\"commit\":\"commit/uri/1\",\"lastBookmarks\":[\"I AM BOOKMARK!\"]}}\n", (Object)result);
    }

    @Test
    void shouldNotSerializeBookmarkOnNonCommittedNotificationStates() {
        this.serializer.writeTransactionInfo(new TransactionInfoEvent(TransactionNotificationState.NO_TRANSACTION, URI.create("commit/uri/1"), -1L, "NOT SEEN!"));
        String result = this.output.toString(StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)"{\"info\":{\"commit\":\"commit/uri/1\"}}\n", (Object)result);
    }

    @Test
    void shouldSerializeResponseWithCommitUriAndResults() {
        Map<String, String> row = Map.of("column1", "value1", "column2", "value2");
        LineDelimitedEventSourceJoltSerializerTest.writeStatementStart(this.serializer, "column1", "column2");
        LineDelimitedEventSourceJoltSerializerTest.writeRecord(this.serializer, row, "column1", "column2");
        LineDelimitedEventSourceJoltSerializerTest.writeStatementEnd(this.serializer);
        this.serializer.writeTransactionInfo(new TransactionInfoEvent(TransactionNotificationState.NO_TRANSACTION, URI.create("commit/uri/1"), -1L, null));
        String result = this.output.toString(StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)"{\"header\":{\"fields\":[\"column1\",\"column2\"]}}\n{\"data\":[{\"U\":\"value1\"},{\"U\":\"value2\"}]}\n{\"summary\":{}}\n{\"info\":{\"commit\":\"commit/uri/1\"}}\n", (Object)result);
    }

    @Test
    void shouldSerializeResponseWithResultsOnly() {
        Map<String, String> row = Map.of("column1", "value1", "column2", "value2");
        LineDelimitedEventSourceJoltSerializerTest.writeStatementStart(this.serializer, "column1", "column2");
        LineDelimitedEventSourceJoltSerializerTest.writeRecord(this.serializer, row, "column1", "column2");
        LineDelimitedEventSourceJoltSerializerTest.writeStatementEnd(this.serializer);
        LineDelimitedEventSourceJoltSerializerTest.writeTransactionInfo(this.serializer);
        String result = this.output.toString(StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)"{\"header\":{\"fields\":[\"column1\",\"column2\"]}}\n{\"data\":[{\"U\":\"value1\"},{\"U\":\"value2\"}]}\n{\"summary\":{}}\n{\"info\":{}}\n", (Object)result);
    }

    @Test
    void shouldSerializeResponseWithCommitUriAndResultsAndErrors() {
        Map<String, String> row = Map.of("column1", "value1", "column2", "value2");
        LineDelimitedEventSourceJoltSerializerTest.writeStatementStart(this.serializer, "column1", "column2");
        LineDelimitedEventSourceJoltSerializerTest.writeRecord(this.serializer, row, "column1", "column2");
        LineDelimitedEventSourceJoltSerializerTest.writeStatementEnd(this.serializer);
        LineDelimitedEventSourceJoltSerializerTest.writeError(this.serializer, (Status)Status.Request.InvalidFormat, "cause1");
        LineDelimitedEventSourceJoltSerializerTest.writeTransactionInfo(this.serializer, "commit/uri/1");
        String result = this.output.toString(StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)"{\"header\":{\"fields\":[\"column1\",\"column2\"]}}\n{\"data\":[{\"U\":\"value1\"},{\"U\":\"value2\"}]}\n{\"summary\":{}}\n{\"error\":{\"errors\":[{\"code\":{\"U\":\"Neo.ClientError.Request.InvalidFormat\"},\"message\":{\"U\":\"cause1\"}}]}}\n{\"info\":{\"commit\":\"commit/uri/1\"}}\n", (Object)result);
    }

    @Test
    void shouldSerializeResponseWithResultsAndErrors() {
        Map<String, String> row = Map.of("column1", "value1", "column2", "value2");
        LineDelimitedEventSourceJoltSerializerTest.writeStatementStart(this.serializer, "column1", "column2");
        LineDelimitedEventSourceJoltSerializerTest.writeRecord(this.serializer, row, "column1", "column2");
        LineDelimitedEventSourceJoltSerializerTest.writeStatementEnd(this.serializer);
        LineDelimitedEventSourceJoltSerializerTest.writeError(this.serializer, (Status)Status.Request.InvalidFormat, "cause1");
        LineDelimitedEventSourceJoltSerializerTest.writeTransactionInfo(this.serializer);
        String result = this.output.toString(StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)"{\"header\":{\"fields\":[\"column1\",\"column2\"]}}\n{\"data\":[{\"U\":\"value1\"},{\"U\":\"value2\"}]}\n{\"summary\":{}}\n{\"error\":{\"errors\":[{\"code\":{\"U\":\"Neo.ClientError.Request.InvalidFormat\"},\"message\":{\"U\":\"cause1\"}}]}}\n{\"info\":{}}\n", (Object)result);
    }

    @Test
    void shouldSerializeResponseWithCommitUriAndErrors() {
        LineDelimitedEventSourceJoltSerializerTest.writeError(this.serializer, (Status)Status.Request.InvalidFormat, "cause1");
        LineDelimitedEventSourceJoltSerializerTest.writeTransactionInfo(this.serializer, "commit/uri/1");
        String result = this.output.toString(StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)"{\"error\":{\"errors\":[{\"code\":{\"U\":\"Neo.ClientError.Request.InvalidFormat\"},\"message\":{\"U\":\"cause1\"}}]}}\n{\"info\":{\"commit\":\"commit/uri/1\"}}\n", (Object)result);
    }

    @Test
    void shouldSerializeResponseWithErrorsOnly() {
        LineDelimitedEventSourceJoltSerializerTest.writeError(this.serializer, (Status)Status.Request.InvalidFormat, "cause1");
        LineDelimitedEventSourceJoltSerializerTest.writeTransactionInfo(this.serializer);
        String result = this.output.toString(StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)"{\"error\":{\"errors\":[{\"code\":{\"U\":\"Neo.ClientError.Request.InvalidFormat\"},\"message\":{\"U\":\"cause1\"}}]}}\n{\"info\":{}}\n", (Object)result);
    }

    @Test
    void shouldSerializeResponseWithNoCommitUriResultsOrErrors() {
        LineDelimitedEventSourceJoltSerializerTest.writeTransactionInfo(this.serializer);
        String result = this.output.toString(StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)"{\"info\":{}}\n", (Object)result);
    }

    @Test
    void shouldSerializeResponseWithMultipleResultRows() {
        Map<String, String> row1 = Map.of("column1", "value1", "column2", "value2");
        Map<String, String> row2 = Map.of("column1", "value3", "column2", "value4");
        LineDelimitedEventSourceJoltSerializerTest.writeStatementStart(this.serializer, "column1", "column2");
        LineDelimitedEventSourceJoltSerializerTest.writeRecord(this.serializer, row1, "column1", "column2");
        LineDelimitedEventSourceJoltSerializerTest.writeRecord(this.serializer, row2, "column1", "column2");
        LineDelimitedEventSourceJoltSerializerTest.writeStatementEnd(this.serializer);
        LineDelimitedEventSourceJoltSerializerTest.writeTransactionInfo(this.serializer);
        String result = this.output.toString(StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)"{\"header\":{\"fields\":[\"column1\",\"column2\"]}}\n{\"data\":[{\"U\":\"value1\"},{\"U\":\"value2\"}]}\n{\"data\":[{\"U\":\"value3\"},{\"U\":\"value4\"}]}\n{\"summary\":{}}\n{\"info\":{}}\n", (Object)result);
    }

    @Test
    void shouldSerializeResponseWithMultipleResults() {
        Map<String, String> row1 = Map.of("column1", "value1", "column2", "value2");
        Map<String, String> row2 = Map.of("column3", "value3", "column4", "value4");
        LineDelimitedEventSourceJoltSerializerTest.writeStatementStart(this.serializer, "column1", "column2");
        LineDelimitedEventSourceJoltSerializerTest.writeRecord(this.serializer, row1, "column1", "column2");
        LineDelimitedEventSourceJoltSerializerTest.writeStatementEnd(this.serializer);
        LineDelimitedEventSourceJoltSerializerTest.writeStatementStart(this.serializer, "column3", "column4");
        LineDelimitedEventSourceJoltSerializerTest.writeRecord(this.serializer, row2, "column3", "column4");
        LineDelimitedEventSourceJoltSerializerTest.writeStatementEnd(this.serializer);
        LineDelimitedEventSourceJoltSerializerTest.writeTransactionInfo(this.serializer);
        String result = this.output.toString(StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)"{\"header\":{\"fields\":[\"column1\",\"column2\"]}}\n{\"data\":[{\"U\":\"value1\"},{\"U\":\"value2\"}]}\n{\"summary\":{}}\n{\"header\":{\"fields\":[\"column3\",\"column4\"]}}\n{\"data\":[{\"U\":\"value3\"},{\"U\":\"value4\"}]}\n{\"summary\":{}}\n{\"info\":{}}\n", (Object)result);
    }

    @Test
    void shouldSerializeNodeAsMapOfProperties() {
        Node node = GraphMock.node((long)1L, (Properties)Properties.properties((Property[])new Property[]{Property.property((String)"a", (Object)12), Property.property((String)"b", (Object)true), Property.property((String)"c", (Object)new int[]{1, 0, 1, 2}), Property.property((String)"d", (Object)new byte[]{1, 0, 1, 2}), Property.property((String)"e", (Object)new String[]{"a", "b", "\u00e4\u00e4\u00f6"})}), (String[])new String[0]);
        Map<String, Node> row = Map.of("node", node);
        LineDelimitedEventSourceJoltSerializerTest.writeStatementStart(this.serializer, "node");
        LineDelimitedEventSourceJoltSerializerTest.writeRecord(this.serializer, row, "node");
        LineDelimitedEventSourceJoltSerializerTest.writeStatementEnd(this.serializer);
        LineDelimitedEventSourceJoltSerializerTest.writeTransactionInfo(this.serializer);
        String result = this.output.toString(StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)"{\"header\":{\"fields\":[\"node\"]}}\n{\"data\":[{\"()\":[1,[],{\"a\":{\"Z\":\"12\"},\"b\":{\"?\":\"true\"},\"c\":[1,0,1,2],\"d\":{\"#\":\"01000102\"},\"e\":[{\"U\":\"a\"},{\"U\":\"b\"},{\"U\":\"\u00e4\u00e4\u00f6\"}]}]}]}\n{\"summary\":{}}\n{\"info\":{}}\n", (Object)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldHandleTransactionHandleStateCorrectly() throws Exception {
        Function<Integer, Node> selectNode = i -> GraphMock.node((long)1L, (Properties)Properties.properties((Property[])new Property[]{Property.property((String)"i", (Object)i)}), (String[])new String[0]);
        Function<Integer, Callable> callableProvider = selectNode.andThen(node -> () -> {
            TransitionalTxManagementKernelTransaction localContext = (TransitionalTxManagementKernelTransaction)Mockito.mock(TransitionalTxManagementKernelTransaction.class);
            InternalTransaction localInternalTransaction = (InternalTransaction)Mockito.mock(InternalTransaction.class);
            KernelTransactionImplementation localKernelTransaction = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
            Mockito.when((Object)localInternalTransaction.getNodeById(1L)).thenReturn(node);
            Mockito.when((Object)localInternalTransaction.kernelTransaction()).thenReturn((Object)localKernelTransaction);
            Mockito.when((Object)localContext.getInternalTransaction()).thenReturn((Object)localInternalTransaction);
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            LineDelimitedEventSourceJoltSerializer serializer = LineDelimitedEventSourceJoltSerializerTest.getSerializerWith(output);
            LineDelimitedEventSourceJoltSerializerTest.writeStatementStart(serializer, "node");
            LineDelimitedEventSourceJoltSerializerTest.writeRecord(serializer, Collections.singletonMap("node", node), "node");
            LineDelimitedEventSourceJoltSerializerTest.writeStatementEnd(serializer);
            LineDelimitedEventSourceJoltSerializerTest.writeTransactionInfo(serializer);
            return output.toString(StandardCharsets.UTF_8);
        });
        int numberOfRequests = 10;
        ExecutorService executor = Executors.newCachedThreadPool();
        List calledRequests = executor.invokeAll(IntStream.range(0, numberOfRequests).boxed().map(callableProvider).collect(Collectors.toList()));
        try {
            int i2 = 0;
            for (Future request : calledRequests) {
                String expectedResult = "{\"header\":{\"fields\":[\"node\"]}}\n{\"data\":[{\"()\":[1,[],{\"i\":{\"Z\":\"" + i2 + "\"}}]}]}\n{\"summary\":{}}\n{\"info\":{}}\n";
                try {
                    String result = (String)request.get();
                    Assertions.assertEquals((Object)expectedResult, (Object)result);
                }
                catch (ExecutionException e) {
                    Assertions.fail((String)("At least one request failed " + e.getMessage()));
                }
                ++i2;
            }
        }
        finally {
            executor.shutdown();
        }
    }

    @Test
    void shouldSerializeNestedEntities() {
        Node a = GraphMock.node((long)1L, (Properties)Properties.properties((Property[])new Property[]{Property.property((String)"foo", (Object)12)}), (String[])new String[0]);
        Node b = GraphMock.node((long)2L, (Properties)Properties.properties((Property[])new Property[]{Property.property((String)"bar", (Object)false)}), (String[])new String[0]);
        Relationship r = GraphMock.relationship((long)1L, (Properties)Properties.properties((Property[])new Property[]{Property.property((String)"baz", (Object)"quux")}), (Node)a, (String)"FRAZZLE", (Node)b);
        Map<String, TreeMap<String, Path>> row = Map.of("nested", new TreeMap<String, Path>(Map.of("node", a, "edge", r, "path", GraphMock.path((Node)a, (Link[])new Link[]{GraphMock.link((Relationship)r, (Node)b)}))));
        LineDelimitedEventSourceJoltSerializerTest.writeStatementStart(this.serializer, "nested");
        LineDelimitedEventSourceJoltSerializerTest.writeRecord(this.serializer, row, "nested");
        LineDelimitedEventSourceJoltSerializerTest.writeStatementEnd(this.serializer);
        LineDelimitedEventSourceJoltSerializerTest.writeTransactionInfo(this.serializer);
        String result = this.output.toString(StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)"{\"header\":{\"fields\":[\"nested\"]}}\n{\"data\":[{\"{}\":{\"edge\":{\"->\":[1,1,\"FRAZZLE\",2,{\"baz\":{\"U\":\"quux\"}}]},\"node\":{\"()\":[1,[],{\"foo\":{\"Z\":\"12\"}}]},\"path\":{\"..\":[{\"()\":[1,[],{\"foo\":{\"Z\":\"12\"}}]},{\"->\":[1,1,\"FRAZZLE\",2,{\"baz\":{\"U\":\"quux\"}}]},{\"()\":[2,[],{\"bar\":{\"?\":\"false\"}}]}]}}}]}\n{\"summary\":{}}\n{\"info\":{}}\n", (Object)result);
    }

    @Test
    void shouldSerializePathAsListOfMapsOfProperties() {
        Path path = LineDelimitedEventSourceJoltSerializerTest.mockPath(Map.of("key1", "value1"), Map.of("key2", "value2"), Map.of("key3", "value3"));
        Map<String, Path> row = Map.of("path", path);
        Node startNode = path.startNode();
        Node endNode = path.endNode();
        Relationship rel = path.lastRelationship();
        LineDelimitedEventSourceJoltSerializerTest.writeStatementStart(this.serializer, "path");
        LineDelimitedEventSourceJoltSerializerTest.writeRecord(this.serializer, row, "path");
        LineDelimitedEventSourceJoltSerializerTest.writeStatementEnd(this.serializer);
        LineDelimitedEventSourceJoltSerializerTest.writeTransactionInfo(this.serializer);
        String result = this.output.toString(StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)"{\"header\":{\"fields\":[\"path\"]}}\n{\"data\":[{\"..\":[{\"()\":[1,[],{\"key1\":{\"U\":\"value1\"}}]},{\"->\":[1,1,\"RELATED\",2,{\"key2\":{\"U\":\"value2\"}}]},{\"()\":[2,[],{\"key3\":{\"U\":\"value3\"}}]}]}]}\n{\"summary\":{}}\n{\"info\":{}}\n", (Object)result);
    }

    @Test
    void shouldSerializePointsAsListOfMapsOfProperties() {
        Map<String, SpatialMocks.MockPoint> row1 = Map.of("geom", SpatialMocks.mockPoint((double)12.3, (double)45.6, (CRS)SpatialMocks.mockWGS84()));
        Map<String, SpatialMocks.MockPoint> row2 = Map.of("geom", SpatialMocks.mockPoint((double)123.0, (double)456.0, (CRS)SpatialMocks.mockCartesian()));
        Map<String, SpatialMocks.MockPoint3D> row3 = Map.of("geom", SpatialMocks.mockPoint((double)12.3, (double)45.6, (double)78.9, (CRS)SpatialMocks.mockWGS84_3D()));
        Map<String, SpatialMocks.MockPoint3D> row4 = Map.of("geom", SpatialMocks.mockPoint((double)123.0, (double)456.0, (double)789.0, (CRS)SpatialMocks.mockCartesian_3D()));
        LineDelimitedEventSourceJoltSerializerTest.writeStatementStart(this.serializer, "geom");
        LineDelimitedEventSourceJoltSerializerTest.writeRecord(this.serializer, row1, "geom");
        LineDelimitedEventSourceJoltSerializerTest.writeRecord(this.serializer, row2, "geom");
        LineDelimitedEventSourceJoltSerializerTest.writeRecord(this.serializer, row3, "geom");
        LineDelimitedEventSourceJoltSerializerTest.writeRecord(this.serializer, row4, "geom");
        LineDelimitedEventSourceJoltSerializerTest.writeStatementEnd(this.serializer);
        LineDelimitedEventSourceJoltSerializerTest.writeTransactionInfo(this.serializer);
        String result = this.output.toString(StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)"{\"header\":{\"fields\":[\"geom\"]}}\n{\"data\":[{\"@\":\"SRID=4326;POINT(12.3 45.6)\"}]}\n{\"data\":[{\"@\":\"SRID=7203;POINT(123.0 456.0)\"}]}\n{\"data\":[{\"@\":\"SRID=4979;POINT Z (12.3 45.6 78.9)\"}]}\n{\"data\":[{\"@\":\"SRID=9157;POINT Z (123.0 456.0 789.0)\"}]}\n{\"summary\":{}}\n{\"info\":{}}\n", (Object)result);
    }

    @Test
    void shouldSerializeTemporalAsListOfMapsOfProperties() {
        Map<String, LocalDate> row1 = Map.of("temporal", LocalDate.of(2018, 3, 12));
        Map<String, ZonedDateTime> row2 = Map.of("temporal", ZonedDateTime.of(2018, 3, 12, 13, 2, 10, 10, ZoneId.of("UTC+1")));
        Map<String, OffsetTime> row3 = Map.of("temporal", OffsetTime.of(12, 2, 4, 71, ZoneOffset.UTC));
        Map<String, LocalDateTime> row4 = Map.of("temporal", LocalDateTime.of(2018, 3, 12, 13, 2, 10, 10));
        Map<String, LocalTime> row5 = Map.of("temporal", LocalTime.of(13, 2, 10, 10));
        Map<String, DurationValue> row6 = Map.of("temporal", DurationValue.duration((Duration)Duration.of(12L, ChronoUnit.HOURS)));
        LineDelimitedEventSourceJoltSerializerTest.writeStatementStart(this.serializer, "temporal");
        LineDelimitedEventSourceJoltSerializerTest.writeRecord(this.serializer, row1, "temporal");
        LineDelimitedEventSourceJoltSerializerTest.writeRecord(this.serializer, row2, "temporal");
        LineDelimitedEventSourceJoltSerializerTest.writeRecord(this.serializer, row3, "temporal");
        LineDelimitedEventSourceJoltSerializerTest.writeRecord(this.serializer, row4, "temporal");
        LineDelimitedEventSourceJoltSerializerTest.writeRecord(this.serializer, row5, "temporal");
        LineDelimitedEventSourceJoltSerializerTest.writeRecord(this.serializer, row6, "temporal");
        LineDelimitedEventSourceJoltSerializerTest.writeStatementEnd(this.serializer);
        this.serializer.writeTransactionInfo(new TransactionInfoEvent(TransactionNotificationState.NO_TRANSACTION, null, -1L, null));
        String result = this.output.toString(StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)"{\"header\":{\"fields\":[\"temporal\"]}}\n{\"data\":[{\"T\":\"2018-03-12\"}]}\n{\"data\":[{\"T\":\"2018-03-12T13:02:10.00000001+01:00[UTC+01:00]\"}]}\n{\"data\":[{\"T\":\"12:02:04.000000071Z\"}]}\n{\"data\":[{\"T\":\"2018-03-12T13:02:10.00000001\"}]}\n{\"data\":[{\"T\":\"13:02:10.00000001\"}]}\n{\"data\":[{\"T\":\"PT12H\"}]}\n{\"summary\":{}}\n{\"info\":{}}\n", (Object)result);
    }

    @Test
    void shouldProduceWellFormedJsonEvenIfResultIteratorThrowsExceptionOnNext() {
        Map<String, String> row = Map.of("column1", "value1", "column2", "value2");
        RecordEvent recordEvent = (RecordEvent)Mockito.mock(RecordEvent.class);
        Mockito.when((Object)recordEvent.getValue((String)ArgumentMatchers.any())).thenThrow(new Throwable[]{new RuntimeException("Stuff went wrong!")});
        Mockito.when((Object)recordEvent.getColumns()).thenReturn(List.of("column1", "column2"));
        LineDelimitedEventSourceJoltSerializerTest.writeStatementStart(this.serializer, "column1", "column2");
        LineDelimitedEventSourceJoltSerializerTest.writeRecord(this.serializer, row, "column1", "column2");
        RuntimeException e = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> this.serializer.writeRecord(recordEvent));
        LineDelimitedEventSourceJoltSerializerTest.writeError(this.serializer, (Status)Status.Statement.ExecutionFailed, e.getMessage());
        LineDelimitedEventSourceJoltSerializerTest.writeTransactionInfo(this.serializer);
        String result = this.output.toString(StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)"{\"header\":{\"fields\":[\"column1\",\"column2\"]}}\n{\"data\":[{\"U\":\"value1\"},{\"U\":\"value2\"}]}\n{\"data\":[]}\n{\"error\":{\"errors\":[{\"code\":{\"U\":\"Neo.DatabaseError.Statement.ExecutionFailed\"},\"message\":{\"U\":\"Stuff went wrong!\"}}]}}\n{\"info\":{}}\n", (Object)result);
    }

    @Test
    void shouldSerializePlanWithoutChildButAllKindsOfSupportedArguments() throws Exception {
        this.serializer = LineDelimitedEventSourceJoltSerializerTest.getSerializerWith(this.output);
        String operatorType = "Ich habe einen Plan!";
        Map<String, Object> args = Map.of("string", "A String", "bool", true, "number", 1, "double", 2.3, "listOfInts", List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)), "listOfListOfInts", List.of(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3))));
        ExecutionPlanDescription planDescription = LineDelimitedEventSourceJoltSerializerTest.mockedPlanDescription(operatorType, NO_IDS, args, NO_PLANS);
        LineDelimitedEventSourceJoltSerializerTest.writeStatementStart(this.serializer, new String[0]);
        LineDelimitedEventSourceJoltSerializerTest.writeRecord(this.serializer, Collections.emptyMap(), new String[0]);
        LineDelimitedEventSourceJoltSerializerTest.writeStatementEnd(this.serializer, planDescription, Collections.emptyList());
        LineDelimitedEventSourceJoltSerializerTest.writeTransactionInfo(this.serializer);
        String resultString = this.output.toString(StandardCharsets.UTF_8);
        JsonNode plan = JsonHelper.jsonNode((String)resultString.split("\n")[2]).get("summary").get("plan").get("root");
        Assertions.assertTrue((boolean)Iterators.asSet((Object[])new String[]{"operatorType", "identifiers", "children", "string", "bool", "number", "double", "listOfInts", "listOfListOfInts"}).containsAll(Iterators.asList((Iterator)plan.fieldNames())));
        Assertions.assertEquals((Object)LineDelimitedEventSourceJoltSerializerTest.wrapWithType("U", operatorType), (Object)plan.get("operatorType"));
        Assertions.assertEquals((Object)LineDelimitedEventSourceJoltSerializerTest.wrapWithType("U", args.get("string")), (Object)plan.get("string"));
        Assertions.assertEquals((Object)LineDelimitedEventSourceJoltSerializerTest.wrapWithType("?", args.get("bool")), (Object)plan.get("bool"));
        Assertions.assertEquals((Object)LineDelimitedEventSourceJoltSerializerTest.wrapWithType("Z", args.get("number")), (Object)plan.get("number"));
        Assertions.assertEquals((Object)LineDelimitedEventSourceJoltSerializerTest.wrapWithType("R", args.get("double")), (Object)plan.get("double"));
        Assertions.assertEquals((Object)JsonHelper.jsonNode((String)"{\"[]\":[{\"Z\":\"1\"},{\"Z\":\"2\"},{\"Z\":\"3\"}]}"), (Object)plan.get("listOfInts"));
        Assertions.assertEquals((Object)JsonHelper.jsonNode((String)"{\"[]\":[{\"[]\":[{\"Z\":\"1\"},{\"Z\":\"2\"},{\"Z\":\"3\"}]}]}"), (Object)plan.get("listOfListOfInts"));
    }

    @Test
    void shouldSerializePlanWithoutChildButWithIdentifiers() throws Exception {
        this.serializer = LineDelimitedEventSourceJoltSerializerTest.getSerializerWith(this.output);
        String operatorType = "Ich habe einen Plan";
        String id1 = "id1";
        String id2 = "id2";
        String id3 = "id3";
        ExecutionPlanDescription planDescription = LineDelimitedEventSourceJoltSerializerTest.mockedPlanDescription(operatorType, Iterators.asSet((Object[])new String[]{id1, id2, id3}), NO_ARGS, NO_PLANS);
        LineDelimitedEventSourceJoltSerializerTest.writeStatementStart(this.serializer, Collections.singletonList(ResultDataContent.rest), new String[0]);
        LineDelimitedEventSourceJoltSerializerTest.writeRecord(this.serializer, Collections.emptyMap(), new String[0]);
        LineDelimitedEventSourceJoltSerializerTest.writeStatementEnd(this.serializer, planDescription, Collections.emptyList());
        LineDelimitedEventSourceJoltSerializerTest.writeTransactionInfo(this.serializer);
        String resultString = this.output.toString(StandardCharsets.UTF_8);
        JsonNode plan = JsonHelper.jsonNode((String)resultString.split("\n")[2]).get("summary");
        JsonNode rootPlan = LineDelimitedEventSourceJoltSerializerTest.assertIsPlanRoot(plan);
        Assertions.assertTrue((boolean)Iterators.asSet((Object[])new String[]{"operatorType", "identifiers", "children"}).containsAll(Iterators.asList((Iterator)rootPlan.fieldNames())));
        Assertions.assertEquals((Object)LineDelimitedEventSourceJoltSerializerTest.wrapWithType("U", operatorType), (Object)rootPlan.get("operatorType"));
        Assertions.assertEquals((Object)JsonHelper.jsonNode((String)"[{\"U\":\"id2\"},{\"U\":\"id1\"},{\"U\":\"id3\"}]"), (Object)rootPlan.get("identifiers"));
    }

    @Test
    void shouldSerializePlanWithChildren() throws Exception {
        this.serializer = LineDelimitedEventSourceJoltSerializerTest.getSerializerWith(this.output);
        String leftId = "leftId";
        String rightId = "rightId";
        String parentId = "parentId";
        ExecutionPlanDescription left = LineDelimitedEventSourceJoltSerializerTest.mockedPlanDescription("child", Iterators.asSet((Object[])new String[]{leftId}), Map.of("id", 1), NO_PLANS);
        ExecutionPlanDescription right = LineDelimitedEventSourceJoltSerializerTest.mockedPlanDescription("child", Iterators.asSet((Object[])new String[]{rightId}), Map.of("id", 2), NO_PLANS);
        ExecutionPlanDescription parent = LineDelimitedEventSourceJoltSerializerTest.mockedPlanDescription("parent", Iterators.asSet((Object[])new String[]{parentId}), Map.of("id", 0), List.of(left, right));
        LineDelimitedEventSourceJoltSerializerTest.writeStatementStart(this.serializer, Collections.singletonList(ResultDataContent.rest), new String[0]);
        LineDelimitedEventSourceJoltSerializerTest.writeRecord(this.serializer, Collections.emptyMap(), new String[0]);
        LineDelimitedEventSourceJoltSerializerTest.writeStatementEnd(this.serializer, parent, Collections.emptyList());
        LineDelimitedEventSourceJoltSerializerTest.writeTransactionInfo(this.serializer);
        String result = this.output.toString(StandardCharsets.UTF_8);
        JsonNode endEventContents = JsonHelper.jsonNode((String)result.split("\n")[2]).get("summary");
        JsonNode root = LineDelimitedEventSourceJoltSerializerTest.assertIsPlanRoot(endEventContents);
        Assertions.assertEquals((Object)"parent", (Object)root.get("operatorType").get("U").asText());
        Assertions.assertEquals((long)0L, (long)root.get("id").asLong());
        Assertions.assertEquals((Object)Iterators.asSet((Object[])new JsonNode[]{LineDelimitedEventSourceJoltSerializerTest.wrapWithType("U", parentId)}), LineDelimitedEventSourceJoltSerializerTest.identifiersOf(root));
        HashSet<Integer> childIds = new HashSet<Integer>();
        HashSet<Set<JsonNode>> identifiers = new HashSet<Set<JsonNode>>();
        for (JsonNode child : root.get("children")) {
            Assertions.assertTrue((boolean)child.isObject(), (String)"Expected object");
            Assertions.assertEquals((Object)"child", (Object)child.get("operatorType").get("U").asText());
            identifiers.add(LineDelimitedEventSourceJoltSerializerTest.identifiersOf(child));
            childIds.add(child.get("id").get("Z").asInt());
        }
        Assertions.assertEquals((Object)Iterators.asSet((Object[])new Integer[]{1, 2}), childIds);
        Assertions.assertEquals((Object)Iterators.asSet((Object[])new Set[]{Iterators.asSet((Object[])new JsonNode[]{LineDelimitedEventSourceJoltSerializerTest.wrapWithType("U", leftId)}), Iterators.asSet((Object[])new JsonNode[]{LineDelimitedEventSourceJoltSerializerTest.wrapWithType("U", rightId)})}), identifiers);
    }

    @Test
    void shouldReturnNotifications() {
        NotificationImplementation notification = NotificationCodeWithDescription.cartesianProduct((InputPosition)new InputPosition(1, 2, 3), (String)"a", (String)"(),()");
        List<NotificationImplementation> notifications = Collections.singletonList(notification);
        Map<String, String> row = Map.of("column1", "value1", "column2", "value2");
        LineDelimitedEventSourceJoltSerializerTest.writeStatementStart(this.serializer, "column1", "column2");
        LineDelimitedEventSourceJoltSerializerTest.writeRecord(this.serializer, row, "column1", "column2");
        LineDelimitedEventSourceJoltSerializerTest.writeStatementEnd(this.serializer, null, notifications);
        LineDelimitedEventSourceJoltSerializerTest.writeTransactionInfo(this.serializer, "commit/uri/1");
        String result = this.output.toString(StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)"{\"header\":{\"fields\":[\"column1\",\"column2\"]}}\n{\"data\":[{\"U\":\"value1\"},{\"U\":\"value2\"}]}\n{\"summary\":{}}\n{\"info\":{\"notifications\":[{\"code\":\"Neo.ClientNotification.Statement.CartesianProduct\",\"severity\":\"INFORMATION\",\"title\":\"This query builds a cartesian product between disconnected patterns.\",\"description\":\"If a part of a query contains multiple disconnected patterns, this will build a cartesian product between all those parts. This may produce a large amount of data and slow down query processing. While occasionally intended, it may often be possible to reformulate the query that avoids the use of this cross product, perhaps by adding a relationship between the different parts or by using OPTIONAL MATCH (a)\",\"position\":{\"offset\":1,\"line\":2,\"column\":3}}],\"commit\":\"commit/uri/1\"}}\n", (Object)result);
    }

    @Test
    void shouldNotReturnNotificationsWhenEmptyNotifications() {
        Map<String, String> row = Map.of("column1", "value1", "column2", "value2");
        LineDelimitedEventSourceJoltSerializerTest.writeStatementStart(this.serializer, "column1", "column2");
        LineDelimitedEventSourceJoltSerializerTest.writeRecord(this.serializer, row, "column1", "column2");
        LineDelimitedEventSourceJoltSerializerTest.writeStatementEnd(this.serializer, null, Collections.emptyList());
        LineDelimitedEventSourceJoltSerializerTest.writeTransactionInfo(this.serializer, "commit/uri/1");
        String result = this.output.toString(StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)"{\"header\":{\"fields\":[\"column1\",\"column2\"]}}\n{\"data\":[{\"U\":\"value1\"},{\"U\":\"value2\"}]}\n{\"summary\":{}}\n{\"info\":{\"commit\":\"commit/uri/1\"}}\n", (Object)result);
    }

    @Test
    void shouldReturnDeprecationNotification() {
        LineDelimitedEventSourceJoltSerializer joltV2Serializer = new LineDelimitedEventSourceJoltSerializer(Collections.emptyMap(), JoltV1Codec.class, true, JSON_FACTORY, (OutputStream)this.output, "application/vnd.neo4j.jolt");
        Map<String, String> row = Map.of("column1", "value1", "column2", "value2");
        LineDelimitedEventSourceJoltSerializerTest.writeStatementStart(joltV2Serializer, "column1", "column2");
        LineDelimitedEventSourceJoltSerializerTest.writeRecord(joltV2Serializer, row, "column1", "column2");
        LineDelimitedEventSourceJoltSerializerTest.writeStatementEnd(joltV2Serializer, null, Collections.emptyList());
        LineDelimitedEventSourceJoltSerializerTest.writeTransactionInfo(joltV2Serializer, "commit/uri/1");
        String result = this.output.toString(StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)"{\"header\":{\"fields\":[\"column1\",\"column2\"]}}\n{\"data\":[{\"U\":\"value1\"},{\"U\":\"value2\"}]}\n{\"summary\":{}}\n{\"info\":{\"notifications\":[{\"code\":\"Neo.ClientNotification.Request.DeprecatedFormat\",\"severity\":\"WARNING\",\"title\":\"The client made a request for a format which has been deprecated.\",\"description\":\"The requested format has been deprecated. ('application/vnd.neo4j.jolt' and 'application/vnd.neo4j.jolt-v1' have been deprecated and will be removed in a future version. Please use 'application/vnd.neo4j.jolt-v2'.)\"}],\"commit\":\"commit/uri/1\"}}\n", (Object)result);
    }

    @Test
    void shouldNotReturnPositionWhenEmptyPosition() {
        Map<String, String> row = Map.of("column1", "value1", "column2", "value2");
        NotificationImplementation notification = NotificationCodeWithDescription.cartesianProduct((InputPosition)InputPosition.empty, (String)"a", (String)"(), ()");
        List<NotificationImplementation> notifications = Collections.singletonList(notification);
        LineDelimitedEventSourceJoltSerializerTest.writeStatementStart(this.serializer, "column1", "column2");
        LineDelimitedEventSourceJoltSerializerTest.writeRecord(this.serializer, row, "column1", "column2");
        LineDelimitedEventSourceJoltSerializerTest.writeStatementEnd(this.serializer, null, notifications);
        LineDelimitedEventSourceJoltSerializerTest.writeTransactionInfo(this.serializer, "commit/uri/1");
        String result = this.output.toString(StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)"{\"header\":{\"fields\":[\"column1\",\"column2\"]}}\n{\"data\":[{\"U\":\"value1\"},{\"U\":\"value2\"}]}\n{\"summary\":{}}\n{\"info\":{\"notifications\":[{\"code\":\"Neo.ClientNotification.Statement.CartesianProduct\",\"severity\":\"INFORMATION\",\"title\":\"This query builds a cartesian product between disconnected patterns.\",\"description\":\"If a part of a query contains multiple disconnected patterns, this will build a cartesian product between all those parts. This may produce a large amount of data and slow down query processing. While occasionally intended, it may often be possible to reformulate the query that avoids the use of this cross product, perhaps by adding a relationship between the different parts or by using OPTIONAL MATCH (a)\"}],\"commit\":\"commit/uri/1\"}}\n", (Object)result);
    }

    protected static LineDelimitedEventSourceJoltSerializer getSerializerWith(OutputStream output) {
        return new LineDelimitedEventSourceJoltSerializer(Collections.emptyMap(), JoltV1Codec.class, true, JSON_FACTORY, output, null);
    }
}

