/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.entity;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.graphdb.Node;
import org.neo4j.server.http.cypher.entity.HttpNode;
import org.neo4j.server.http.cypher.entity.HttpRelationship;

class HttpRelationshipTest {
    private static final long START_NODE_ID = 1245L;
    private static final String START_NODE_ELEMENT_ID = String.valueOf(1245L);
    private static final long END_NODE_ID = 54321L;
    private static final String END_NODE_ELEMENT_ID = String.valueOf(54321L);

    HttpRelationshipTest() {
    }

    @Test
    void getStartNodeId_shouldReturnStartNodeIdWithoutCallGetStartNode() {
        HttpRelationship subject = this.setupSubject();
        long startNodeId = subject.getStartNodeId();
        Assertions.assertEquals((long)1245L, (long)startNodeId);
        ((HttpRelationship)Mockito.verify((Object)subject, (VerificationMode)Mockito.never())).getStartNode();
    }

    @Test
    void getEndNodeId_shouldReturnEndNodeIdWithoutCallGetEndNode() {
        HttpRelationship subject = this.setupSubject();
        long endNodeId = subject.getEndNodeId();
        Assertions.assertEquals((long)54321L, (long)endNodeId);
        ((HttpRelationship)Mockito.verify((Object)subject, (VerificationMode)Mockito.never())).getEndNode();
    }

    @Test
    void getStartNode_whenSupplierReturnsEmpty_shouldReturnNodeCreatedOnlyWithNodeId() {
        HttpRelationship subject = this.setupSubject();
        HttpNode expectedNode = new HttpNode(START_NODE_ELEMENT_ID, 1245L);
        Node startNode = subject.getStartNode();
        Assertions.assertEquals((Object)expectedNode, (Object)startNode);
    }

    @Test
    void getStartNode_whenSupplierReturnsTheNode_shouldReturnIt() {
        HttpNode expectedNode = new HttpNode(START_NODE_ELEMENT_ID, 1245L, List.of(), Map.of(), false);
        HttpRelationship subject = this.setupSubject((ignoredA, ignoredB) -> Optional.of(expectedNode));
        Node startNode = subject.getStartNode();
        Assertions.assertSame((Object)expectedNode, (Object)startNode);
    }

    @Test
    void getEndNode_whenSupplierReturnsEmpty_shouldReturnNodeCreatedOnlyWithNodeId() {
        HttpRelationship subject = this.setupSubject();
        HttpNode expectedNode = new HttpNode(END_NODE_ELEMENT_ID, 54321L);
        Node endNode = subject.getEndNode();
        Assertions.assertEquals((Object)expectedNode, (Object)endNode);
    }

    @Test
    void getEndNode_whenSupplierReturnsTheNode_shouldReturnIt() {
        HttpNode expectedNode = new HttpNode(END_NODE_ELEMENT_ID, 54321L, List.of(), Map.of(), false);
        HttpRelationship subject = this.setupSubject((ignoredA, ignoredB) -> Optional.of(expectedNode));
        Node endNode = subject.getEndNode();
        Assertions.assertSame((Object)expectedNode, (Object)endNode);
    }

    private HttpRelationship setupSubject() {
        return this.setupSubject((ignoredA, ignoredB) -> Optional.empty());
    }

    private HttpRelationship setupSubject(BiFunction<Long, Boolean, Optional<Node>> getNodeById) {
        HttpRelationship httpRelationship = new HttpRelationship("1", 1L, START_NODE_ELEMENT_ID, 1245L, END_NODE_ELEMENT_ID, 54321L, "KNOWS", Map.of(), false, getNodeById);
        return (HttpRelationship)Mockito.spy((Object)httpRelationship);
    }
}

