/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web;

import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.web.StaticContentFilter;

class StaticContentFilterTest {
    StaticContentFilterTest() {
    }

    @Test
    void shouldAddStaticContentHeadersToHtmlResponses() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getServletPath()).thenReturn((Object)"any-file.txt");
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        FilterChain filterChain = (FilterChain)Mockito.mock(FilterChain.class);
        new StaticContentFilter((String)ServerSettings.http_static_content_security_policy.defaultValue()).doFilter((ServletRequest)request, (ServletResponse)response, filterChain);
        ((HttpServletResponse)Mockito.verify((Object)response)).addHeader("Cache-Control", "no-store");
        ((HttpServletResponse)Mockito.verify((Object)response)).addHeader("Pragma", "no-cache");
        ((HttpServletResponse)Mockito.verify((Object)response)).addHeader("Content-Security-Policy", (String)ServerSettings.http_static_content_security_policy.defaultValue());
        ((HttpServletResponse)Mockito.verify((Object)response)).addHeader("X-Frame-Options", "DENY");
        ((HttpServletResponse)Mockito.verify((Object)response)).addHeader("X-Content-Type-Options", "nosniff");
        ((HttpServletResponse)Mockito.verify((Object)response)).addHeader("X-XSS-Protection", "1; mode=block");
        ((FilterChain)Mockito.verify((Object)filterChain)).doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

