/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.consumer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.bolt.protocol.common.fsm.response.AbstractMetadataAwareResponseHandler;
import org.neo4j.bolt.protocol.common.fsm.response.RecordHandler;
import org.neo4j.bolt.protocol.common.fsm.response.metadata.MetadataHandler;
import org.neo4j.bolt.protocol.common.message.Error;
import org.neo4j.bolt.protocol.v44.fsm.response.metadata.MetadataHandlerV44;
import org.neo4j.bolt.tx.TransactionType;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.graphdb.GqlStatusObject;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.server.http.cypher.OutputEventStream;
import org.neo4j.server.http.cypher.TransactionHandle;
import org.neo4j.server.http.cypher.TransactionIndependentValueMapper;
import org.neo4j.server.http.cypher.consumer.OutputEventStreamRecordHandler;
import org.neo4j.server.http.cypher.format.api.Statement;
import org.neo4j.values.AnyValue;

public class OutputEventStreamResponseHandler
extends AbstractMetadataAwareResponseHandler {
    private final OutputEventStream outputEventStream;
    private final Statement statement;
    private final TransactionIndependentValueMapper valueMapper;
    private Map<String, AnyValue> metadataMap = new HashMap<String, AnyValue>();
    private QueryExecutionType executionType;
    private QueryStatistics queryStatistics;
    private Iterable<Notification> notifications;
    private ExecutionPlanDescription executionPlanDescription;
    private TransactionHandle transactionHandle;

    public OutputEventStreamResponseHandler(OutputEventStream outputEventStream, Statement statement, TransactionIndependentValueMapper valueMapper, TransactionHandle transactionHandle) {
        super((MetadataHandler)MetadataHandlerV44.getInstance());
        this.outputEventStream = outputEventStream;
        this.statement = statement;
        this.valueMapper = valueMapper;
        this.transactionHandle = transactionHandle;
    }

    public void onMetadata(String key, AnyValue value) {
        this.metadataMap.put(key, value);
    }

    public void onStatementPrepared(TransactionType transactionType, long statementId, long timeSpentPreparingResults, List<String> fieldNames) {
    }

    public RecordHandler onBeginStreaming(List<String> fieldNames) {
        this.outputEventStream.writeStatementStart(this.statement, fieldNames);
        return new OutputEventStreamRecordHandler(fieldNames, this.outputEventStream, this.valueMapper);
    }

    public void onStreamingMetadata(long timeSpentStreaming, QueryExecutionType executionType, DatabaseReference database, QueryStatistics statistics, Iterable<Notification> notifications, Iterable<GqlStatusObject> statuses) {
        this.executionType = executionType;
        this.queryStatistics = statistics;
        this.notifications = notifications;
    }

    public void onStreamingExecutionPlan(ExecutionPlanDescription plan) {
        this.executionPlanDescription = plan;
    }

    public void onCompleteStreaming(boolean hasRemaining) {
        this.outputEventStream.writeStatementEnd(this.executionType, this.queryStatistics, this.executionPlanDescription, this.notifications);
        this.executionType = null;
        this.queryStatistics = null;
        this.notifications = null;
        this.executionPlanDescription = null;
    }

    public void onBookmark(String encodedBookmark) {
        if (encodedBookmark != null) {
            this.transactionHandle.setOutputBookmark(encodedBookmark);
        }
    }

    public void onFailure(Error error) {
    }

    public void onIgnored() {
    }

    public void onSuccess() {
    }
}

