/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jetty.io.Connection;
import org.neo4j.kernel.api.net.NetworkConnectionTracker;
import org.neo4j.kernel.api.net.TrackedNetworkConnection;
import org.neo4j.server.web.JettyHttp2Connection;

public class JettyHttp2ConnectionListener
implements Connection.Listener {
    private final NetworkConnectionTracker connectionTracker;
    private final String connectorName;
    private final Map<Connection, String> connectionHashToConnectionId = new HashMap<Connection, String>();

    public JettyHttp2ConnectionListener(NetworkConnectionTracker connectionTracker, String connectorName) {
        this.connectionTracker = connectionTracker;
        this.connectorName = connectorName;
    }

    public void onOpened(Connection connection) {
        String connectionId = this.connectionTracker.newConnectionId(this.connectorName);
        this.connectionHashToConnectionId.put(connection, connectionId);
        this.connectionTracker.add((TrackedNetworkConnection)new JettyHttp2Connection(this.connectorName, connectionId, connection));
    }

    public void onClosed(Connection connection) {
        String connectionId = this.connectionHashToConnectionId.get(connection);
        this.connectionTracker.remove(this.connectionTracker.get(connectionId));
    }
}

