/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web;

import org.assertj.core.api.Assertions;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Server;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.server.web.JettyHttpConnection;

class JettyHttpConnectionTest {
    JettyHttpConnectionTest() {
    }

    @Test
    void shouldHaveId() {
        Connector connector = JettyHttpConnectionTest.connectorMock("https");
        JettyHttpConnection connection = JettyHttpConnectionTest.newConnection(connector);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"http-1", (Object)connection.id());
    }

    @Test
    void shouldHaveConnectTime() {
        JettyHttpConnection connection = JettyHttpConnectionTest.newConnection(JettyHttpConnectionTest.connectorMock("http"));
        Assertions.assertThat((long)connection.connectTime()).isGreaterThan(0L);
    }

    @Test
    void shouldHaveConnector() {
        JettyHttpConnection connection = JettyHttpConnectionTest.newConnection(JettyHttpConnectionTest.connectorMock("http+routing"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"http+routing", (Object)connection.connectorId());
    }

    @Test
    void shouldHaveUsernameAndUserAgent() {
        JettyHttpConnection connection = JettyHttpConnectionTest.newConnection(JettyHttpConnectionTest.connectorMock("http+routing"));
        org.junit.jupiter.api.Assertions.assertNull((Object)connection.username());
        connection.updateUser("hello", "my-http-driver/1.2.3");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"hello", (Object)connection.username());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"my-http-driver/1.2.3", (Object)connection.userAgent());
    }

    private static JettyHttpConnection newConnection(Connector connector) {
        return new JettyHttpConnection("http-1", new HttpConfiguration(), connector, (EndPoint)Mockito.mock(EndPoint.class), false);
    }

    private static Connector connectorMock(String name) {
        Connector connector = (Connector)Mockito.mock(Connector.class);
        Mockito.when((Object)connector.getName()).thenReturn((Object)name);
        Mockito.when((Object)connector.getExecutor()).thenReturn(Runnable::run);
        Mockito.when((Object)connector.getByteBufferPool()).thenReturn((Object)((ByteBufferPool)Mockito.mock(ByteBufferPool.class)));
        Mockito.when((Object)connector.getServer()).thenReturn((Object)new Server());
        return connector;
    }
}

