/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.format.input.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.server.http.cypher.format.api.ConnectionException;
import org.neo4j.server.http.cypher.format.api.InputFormatException;
import org.neo4j.server.http.cypher.format.input.json.InputStatement;
import org.neo4j.server.http.cypher.format.output.json.ResultDataContent;

class StatementDeserializer {
    private static final Map<String, Object> NO_PARAMETERS = Collections.unmodifiableMap(MapUtil.map((Object[])new Object[0]));
    private final JsonParser parser;
    private State state;

    StatementDeserializer(JsonFactory jsonFactory, InputStream input) {
        try {
            this.parser = jsonFactory.createParser(input);
            this.state = State.BEFORE_OUTER_ARRAY;
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create a JSON parser", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    InputStatement read() {
        switch (this.state) {
            case BEFORE_OUTER_ARRAY: {
                if (!this.beginsWithCorrectTokens()) {
                    return null;
                }
                this.state = State.IN_BODY;
            }
            case IN_BODY: {
                String statement = null;
                Map<String, Object> parameters = null;
                List<Object> resultsDataContents = null;
                boolean includeStats = false;
                try {
                    Map<String, Object> map;
                    JsonToken tok;
                    block21: while ((tok = this.parser.nextToken()) != null && tok != JsonToken.END_OBJECT) {
                        String currentName;
                        if (tok == JsonToken.END_ARRAY) {
                            this.state = State.FINISHED;
                            return null;
                        }
                        this.parser.nextValue();
                        switch (currentName = this.parser.getCurrentName()) {
                            case "statement": {
                                statement = (String)this.parser.readValueAs(String.class);
                                continue block21;
                            }
                            case "parameters": {
                                parameters = this.readMap();
                                continue block21;
                            }
                            case "resultDataContents": {
                                resultsDataContents = this.readArray();
                                continue block21;
                            }
                            case "includeStats": {
                                includeStats = this.parser.getBooleanValue();
                                continue block21;
                            }
                        }
                        this.discardValue();
                    }
                    if (statement == null) {
                        throw InputFormatException.emptyInputString("statement", "No statement provided.");
                    }
                    if (parameters == null) {
                        map = NO_PARAMETERS;
                        return new InputStatement(statement, map, includeStats, ResultDataContent.fromNames(resultsDataContents));
                    }
                    map = parameters;
                    return new InputStatement(statement, map, includeStats, ResultDataContent.fromNames(resultsDataContents));
                }
                catch (JsonParseException e) {
                    throw InputFormatException.jsonParingException("Could not parse the incoming JSON", e);
                }
                catch (JsonMappingException e) {
                    throw InputFormatException.jsonMappingException("Could not map the incoming JSON", e);
                }
                catch (IOException e) {
                    throw new ConnectionException("An error encountered while reading the inbound entity", e);
                }
            }
            case FINISHED: {
                return null;
            }
        }
        return null;
    }

    private void discardValue() throws IOException {
        this.parser.readValueAs(Object.class);
    }

    private Map<String, Object> readMap() throws IOException {
        return (Map)this.parser.readValueAs(Map.class);
    }

    private List<Object> readArray() throws IOException {
        return (List)this.parser.readValueAs(List.class);
    }

    private boolean beginsWithCorrectTokens() {
        List<JsonToken> expectedTokens = Arrays.asList(JsonToken.START_OBJECT, JsonToken.FIELD_NAME, JsonToken.START_ARRAY);
        String expectedField = "statements";
        ArrayList<JsonToken> foundTokens = new ArrayList<JsonToken>();
        try {
            for (int i = 0; i < expectedTokens.size(); ++i) {
                JsonToken token = this.parser.nextToken();
                if (i == 0 && token == null) {
                    return false;
                }
                if (token == JsonToken.FIELD_NAME && !expectedField.equals(this.parser.getText())) {
                    throw InputFormatException.wrongFirstFieldDuringDeserialization(expectedField, this.parser.getText());
                }
                foundTokens.add(token);
            }
            if (!expectedTokens.equals(foundTokens)) {
                throw InputFormatException.wrongTokenDuringDeserialization(expectedTokens.toString(), ((Object)foundTokens).toString());
            }
        }
        catch (JsonParseException e) {
            throw new InputFormatException("Could not parse the incoming JSON", e);
        }
        catch (IOException e) {
            throw new ConnectionException("An error encountered while reading the inbound entity", e);
        }
        return true;
    }

    private static enum State {
        BEFORE_OUTER_ARRAY,
        IN_BODY,
        FINISHED;

    }
}

