/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.format.output.eventsource;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.server.http.cypher.format.api.RecordEvent;
import org.neo4j.server.http.cypher.format.jolt.v1.JoltV1Codec;
import org.neo4j.server.http.cypher.format.output.eventsource.EventSourceWriter;
import org.neo4j.server.http.cypher.format.output.json.ResultDataContentWriter;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;

class EventSourceWriterTest {
    EventSourceWriterTest() {
    }

    @Test
    void shouldWriteSimpleRecord() throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JsonGenerator json = new JoltV1Codec(true).createGenerator((OutputStream)out);
        JsonNode row = EventSourceWriterTest.serialize(out, json, (ResultDataContentWriter)new EventSourceWriter(), Map.of("value", Map.of("country", "France")));
        Assertions.assertThat((int)row.size()).isEqualTo(1);
        JsonNode value = row.get(0).get("{}");
        Assertions.assertThat((String)value.get("country").get("U").asText()).isEqualTo("France");
    }

    @Test
    void shouldWriteNestedMaps() throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JsonGenerator json = new JoltV1Codec(true).createGenerator((OutputStream)out);
        Map data = MapUtil.map((Object[])new Object[]{"ColumnA", MapUtil.map((Object[])new Object[]{"one", MapUtil.map((Object[])new Object[]{"two", Arrays.asList(true, MapUtil.map((Object[])new Object[]{"three", 42}))})})});
        JsonNode record = EventSourceWriterTest.serialize(out, json, (ResultDataContentWriter)new EventSourceWriter(), data);
        Assertions.assertThat((int)record.get(0).size()).isEqualTo(1);
        JsonNode value = record.get(0).get("{}");
        Assertions.assertThat((int)value.get("one").get("{}").get("two").get("[]").size()).isEqualTo(2);
        Assertions.assertThat((boolean)value.get("one").get("{}").get("two").get("[]").get(0).get("?").asBoolean()).isEqualTo(true);
        Assertions.assertThat((int)value.get("one").get("{}").get("two").get("[]").get(1).get("{}").get("three").get("Z").asInt()).isEqualTo(42);
    }

    private static JsonNode serialize(ByteArrayOutputStream out, JsonGenerator json, ResultDataContentWriter resultDataContentWriter, Map<String, Object> data) throws IOException, JsonParseException {
        RecordEvent recordEvent = new RecordEvent(new ArrayList<String>(data.keySet()), data::get);
        resultDataContentWriter.write(json, recordEvent);
        json.flush();
        json.close();
        String jsonAsString = out.toString();
        return JsonHelper.jsonNode((String)jsonAsString);
    }
}

