/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.queryapi.tx;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.Session;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.internal.InternalSession;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.server.queryapi.metrics.QueryAPIMetricsMonitor;
import org.neo4j.server.queryapi.tx.QueryAPITransaction;
import org.neo4j.server.queryapi.tx.Transaction;
import org.neo4j.server.queryapi.tx.TransactionConcurrentAccessException;
import org.neo4j.server.queryapi.tx.TransactionIdCollisionException;
import org.neo4j.server.queryapi.tx.TransactionManager;
import org.neo4j.server.queryapi.tx.TransactionNotFoundException;

public class QueryAPITransactionManager
implements TransactionManager {
    private final Map<String, Transaction> transactions = new ConcurrentHashMap<String, Transaction>();
    private final Duration timeout;
    private final QueryAPIMetricsMonitor monitor;

    public QueryAPITransactionManager(Duration timeout, JobScheduler scheduler, QueryAPIMetricsMonitor monitor) {
        this.timeout = timeout;
        this.monitor = monitor;
        scheduler.scheduleRecurring(Group.SERVER_TRANSACTION_TIMEOUT, JobMonitoringParams.systemJob((String)"Timeout of Query API transactions"), this::beginTimeoutJob, 5L, TimeUnit.SECONDS);
    }

    @Override
    public Transaction begin(String txId, Session session, AuthToken authToken, String databaseName, TransactionConfig config, String txType) throws TransactionIdCollisionException {
        this.monitor.openTransaction();
        InternalSession internalSession = (InternalSession)session;
        org.neo4j.driver.Transaction driverTransaction = internalSession.beginTransaction(config, txType);
        QueryAPITransaction tx = new QueryAPITransaction(txId, driverTransaction, session, authToken, databaseName, Instant.now().plus(this.timeout).truncatedTo(ChronoUnit.SECONDS), this.timeout);
        Transaction existingTx = this.transactions.putIfAbsent(txId, tx);
        if (existingTx != null) {
            throw new TransactionIdCollisionException();
        }
        tx.tryAcquire();
        return tx;
    }

    @Override
    public Transaction retrieveTransaction(String transactionId, String requestedDatabase, AuthToken accessingUser) throws TransactionNotFoundException {
        Transaction tx = this.transactions.get(transactionId);
        if (tx != null) {
            if (tx.tryAcquire()) {
                if (tx.databaseName().equals(requestedDatabase) && tx.authToken().equals(accessingUser)) {
                    return tx;
                }
                tx.release();
            } else {
                throw new TransactionConcurrentAccessException("Transaction was accessed concurrently");
            }
        }
        throw new TransactionNotFoundException(transactionId);
    }

    @Override
    public void releaseTransaction(String txId) {
        Transaction tx = this.transactions.get(txId);
        if (tx != null) {
            tx.release();
        }
    }

    @Override
    public void removeTransaction(String txId) {
        Transaction tx = this.transactions.get(txId);
        if (tx != null) {
            tx.close();
            this.transactions.remove(txId);
            this.monitor.closeTransaction();
            tx.release();
        }
    }

    @Override
    public void beginTimeoutJob() {
        Instant timeoutFrom = Instant.now();
        for (Map.Entry<String, Transaction> tx : this.transactions.entrySet()) {
            if (!tx.getValue().tryAcquire()) continue;
            if (timeoutFrom.compareTo(tx.getValue().expiresAt()) > 0) {
                this.removeTransaction(tx.getKey());
                this.monitor.totalTransactionsTimedOut();
            }
            tx.getValue().release();
        }
    }

    @Override
    public long openTransactionCount() {
        return this.transactions.size();
    }
}

