/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.format.jolt;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdDelegatingSerializer;
import com.fasterxml.jackson.databind.util.Converter;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.function.Function;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.server.http.cypher.format.jolt.JoltDelegatingValueSerializer;
import org.neo4j.server.http.cypher.format.jolt.JoltLabelConverter;
import org.neo4j.server.http.cypher.format.jolt.JoltListSerializer;
import org.neo4j.server.http.cypher.format.jolt.JoltLongSerializer;
import org.neo4j.server.http.cypher.format.jolt.JoltMapSerializer;
import org.neo4j.server.http.cypher.format.jolt.JoltRelationshipTypeConverter;
import org.neo4j.server.http.cypher.format.jolt.JoltSparseNumberSerializer;
import org.neo4j.server.http.cypher.format.jolt.PointToWKT;
import org.neo4j.server.http.cypher.format.jolt.Sigil;
import org.neo4j.values.storable.DurationValue;

public class AbstractJoltModule
extends SimpleModule {
    private static final char[] HEX_DIGITS = "0123456789ABCDEF".toCharArray();

    public AbstractJoltModule(boolean strictModeEnabled) {
        if (strictModeEnabled) {
            this.addSerializer((JsonSerializer)new JoltDelegatingValueSerializer<String>(String.class, Sigil.UNICODE, Function.identity()));
            this.addSerializer((JsonSerializer)new JoltDelegatingValueSerializer<Boolean>(Boolean.TYPE, Sigil.BOOLEAN, String::valueOf));
            this.addSerializer((JsonSerializer)new JoltDelegatingValueSerializer<Boolean>(Boolean.class, Sigil.BOOLEAN, String::valueOf));
            this.addSerializer((JsonSerializer)new JoltDelegatingValueSerializer<Integer>(Integer.TYPE, Sigil.INTEGER, String::valueOf));
            this.addSerializer((JsonSerializer)new JoltDelegatingValueSerializer<Integer>(Integer.class, Sigil.INTEGER, String::valueOf));
            this.addSerializer((JsonSerializer)new JoltLongSerializer<Long>(Long.TYPE));
            this.addSerializer((JsonSerializer)new JoltLongSerializer<Long>(Long.class));
            this.addSerializer((JsonSerializer)new JoltDelegatingValueSerializer<Void>(Void.class, Sigil.BOOLEAN, String::valueOf));
            this.addSerializer((JsonSerializer)new JoltListSerializer());
        } else {
            this.addSerializer((JsonSerializer)new JoltSparseNumberSerializer<Integer>(Integer.TYPE, Sigil.INTEGER, String::valueOf));
            this.addSerializer((JsonSerializer)new JoltSparseNumberSerializer<Integer>(Integer.class, Sigil.INTEGER, String::valueOf));
            this.addSerializer((JsonSerializer)new JoltSparseNumberSerializer<Long>(Long.TYPE, Sigil.INTEGER, String::valueOf));
            this.addSerializer((JsonSerializer)new JoltSparseNumberSerializer<Long>(Long.class, Sigil.INTEGER, String::valueOf));
        }
        this.addSerializer((JsonSerializer)new JoltDelegatingValueSerializer<Double>(Double.TYPE, Sigil.REAL, String::valueOf));
        this.addSerializer((JsonSerializer)new JoltDelegatingValueSerializer<Double>(Double.class, Sigil.REAL, String::valueOf));
        this.addSerializer((JsonSerializer)new JoltDelegatingValueSerializer<byte[]>(byte[].class, Sigil.BINARY, AbstractJoltModule::toHexString));
        this.addSerializer((JsonSerializer)new JoltDelegatingValueSerializer<Point>(Point.class, Sigil.SPATIAL, new PointToWKT()));
        this.addSerializer((JsonSerializer)new JoltDelegatingValueSerializer<LocalDate>(LocalDate.class, Sigil.TIME, DateTimeFormatter.ISO_LOCAL_DATE::format));
        this.addSerializer((JsonSerializer)new JoltDelegatingValueSerializer<OffsetTime>(OffsetTime.class, Sigil.TIME, DateTimeFormatter.ISO_OFFSET_TIME::format));
        this.addSerializer((JsonSerializer)new JoltDelegatingValueSerializer<LocalTime>(LocalTime.class, Sigil.TIME, DateTimeFormatter.ISO_LOCAL_TIME::format));
        this.addSerializer((JsonSerializer)new JoltDelegatingValueSerializer<ZonedDateTime>(ZonedDateTime.class, Sigil.TIME, DateTimeFormatter.ISO_ZONED_DATE_TIME::format));
        this.addSerializer((JsonSerializer)new JoltDelegatingValueSerializer<LocalDateTime>(LocalDateTime.class, Sigil.TIME, DateTimeFormatter.ISO_LOCAL_DATE_TIME::format));
        this.addSerializer((JsonSerializer)new JoltDelegatingValueSerializer<DurationValue>(DurationValue.class, Sigil.TIME, DurationValue::toString));
        this.addSerializer((JsonSerializer)new StdDelegatingSerializer(Label.class, (Converter)new JoltLabelConverter()));
        this.addSerializer((JsonSerializer)new StdDelegatingSerializer(RelationshipType.class, (Converter)new JoltRelationshipTypeConverter()));
        this.addSerializer((JsonSerializer)new JoltMapSerializer());
    }

    private static String toHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(2 * bytes.length);
        for (byte b : bytes) {
            sb.append(HEX_DIGITS[b >> 4 & 0xF]).append(HEX_DIGITS[b & 0xF]);
        }
        return sb.toString();
    }
}

