/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.queryapi;

import java.io.IOException;
import java.io.InputStream;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.server.queryapi.request.PeekedFirstByteInputStream;

public class PeekedFirstByteInputStreamTest {
    @Test
    void shouldPeekFirstByte() throws IOException {
        PeekedFirstByteInputStream testStream = new PeekedFirstByteInputStream((InputStream)new TestStream());
        AssertionsForClassTypes.assertThat((int)testStream.peek()).isEqualTo(3);
        AssertionsForClassTypes.assertThat((int)testStream.peek()).isEqualTo(3);
    }

    @Test
    void readingShouldMovePeekAhead() throws IOException {
        PeekedFirstByteInputStream testStream = new PeekedFirstByteInputStream((InputStream)new TestStream());
        AssertionsForClassTypes.assertThat((int)testStream.peek()).isEqualTo(3);
        int readValue = testStream.read();
        AssertionsForClassTypes.assertThat((int)readValue).isEqualTo(3);
        AssertionsForClassTypes.assertThat((int)testStream.peek()).isEqualTo(6);
    }

    @Test
    void shouldCloseUnderlyingStreamOnClosure() throws IOException {
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        PeekedFirstByteInputStream testStream = new PeekedFirstByteInputStream(inputStream);
        testStream.close();
        ((InputStream)Mockito.verify((Object)inputStream)).close();
    }

    private static class TestStream
    extends InputStream {
        private final int[] bytes = new int[]{3, 6, 9};
        private int index = 0;

        private TestStream() {
        }

        @Override
        public int read() throws IOException {
            int next = this.bytes[this.index];
            ++this.index;
            return next;
        }
    }
}

