/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.ssl;

import java.util.ListIterator;
import org.assertj.core.api.Assertions;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.configuration.Config;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.security.ssl.HttpsRequestCustomizer;

class HttpsRequestCustomizerTest {
    HttpsRequestCustomizerTest() {
    }

    @Test
    void shouldSetRequestSchemeToHttps() {
        HttpConfiguration.Customizer customizer = HttpsRequestCustomizerTest.newCustomizer();
        Request request = HttpsRequestCustomizerTest.newRequest();
        Request customizedReq = HttpsRequestCustomizerTest.customize(customizer, request, null);
        Assertions.assertThat((Object)customizedReq.getHttpURI()).isEqualTo((Object)HttpURI.build((String)"https://example.com"));
    }

    @Test
    void shouldAddHstsHeaderWhenConfigured() {
        String configuredValue = "max-age=3600; includeSubDomains";
        HttpConfiguration.Customizer customizer = HttpsRequestCustomizerTest.newCustomizer(configuredValue);
        Request request = HttpsRequestCustomizerTest.newRequest();
        ListIterator responseHeaders = (ListIterator)Mockito.mock(ListIterator.class);
        HttpsRequestCustomizerTest.customize(customizer, request, responseHeaders);
        PreEncodedHttpField stsHeader = new PreEncodedHttpField(HttpHeader.STRICT_TRANSPORT_SECURITY, configuredValue);
        ((ListIterator)Mockito.verify((Object)responseHeaders)).add((HttpField)ArgumentMatchers.eq((Object)stsHeader));
    }

    @Test
    void shouldNotAddHstsHeaderWhenNotConfigured() {
        HttpConfiguration.Customizer customizer = HttpsRequestCustomizerTest.newCustomizer();
        Request request = HttpsRequestCustomizerTest.newRequest();
        ListIterator responseHeaders = (ListIterator)Mockito.mock(ListIterator.class);
        HttpsRequestCustomizerTest.customize(customizer, request, responseHeaders);
        Mockito.verifyNoInteractions((Object[])new Object[]{responseHeaders});
    }

    private static Request customize(HttpConfiguration.Customizer customizer, Request request, ListIterator<HttpField> responseHeaders) {
        Response response = (Response)Mockito.mock(Response.class);
        Mockito.when((Object)response.getHeaders()).thenReturn(index -> responseHeaders);
        return customizer.customize(request, response.getHeaders());
    }

    private static Request newRequest() {
        HttpChannel channel = (HttpChannel)Mockito.mock(HttpChannel.class);
        Request request = (Request)Mockito.mock(Request.class);
        HttpURI.Mutable httpUri = HttpURI.build((String)"http://example.com");
        Mockito.when((Object)request.getHttpURI()).thenReturn((Object)httpUri);
        Mockito.when((Object)channel.getRequest()).thenReturn((Object)request);
        return request;
    }

    private static HttpConfiguration.Customizer newCustomizer() {
        return new HttpsRequestCustomizer(Config.defaults());
    }

    private static HttpConfiguration.Customizer newCustomizer(String hstsValue) {
        Config config = Config.defaults((Setting)ServerSettings.http_strict_transport_security, (Object)hstsValue);
        return new HttpsRequestCustomizer(config);
    }
}

