/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.configuration;

import java.net.URI;
import java.time.Duration;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.neo4j.configuration.Description;
import org.neo4j.configuration.Internal;
import org.neo4j.configuration.SettingConstraints;
import org.neo4j.configuration.SettingImpl;
import org.neo4j.configuration.SettingValueParser;
import org.neo4j.configuration.SettingValueParsers;
import org.neo4j.configuration.SettingsDeclaration;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.server.configuration.ConfigurableServerModules;
import org.neo4j.server.configuration.ConfigurableTransports;
import org.neo4j.server.configuration.ThirdPartyJaxRsPackage;

public class ServerSettings
implements SettingsDeclaration {
    public static final String DBMS_MOUNT_POINT = "/dbms";
    @Description(value="Maximum request header size")
    @Internal
    public static final Setting<Integer> maximum_request_header_size = SettingImpl.newBuilder((String)"internal.dbms.max_http_request_header_size", (SettingValueParser)SettingValueParsers.INT, (Object)20480).build();
    @Description(value="Maximum response header size")
    @Internal
    public static final Setting<Integer> maximum_response_header_size = SettingImpl.newBuilder((String)"internal.dbms.max_http_response_header_size", (SettingValueParser)SettingValueParsers.INT, (Object)20480).build();
    @Description(value="Number of Neo4j worker threads. This setting is only valid for REST, and does not influence bolt-server. It sets the amount of worker threads for the Jetty server used by neo4j-server. This option can be tuned when you plan to execute multiple, concurrent REST requests, with the aim of getting more throughput from the database. By default, it is set to the number of available processors, or to 500 for machines with more than 500 processors. Your OS might enforce a lower limit than the maximum value specified here.")
    public static final Setting<Integer> webserver_max_threads = SettingImpl.newBuilder((String)"server.threads.worker_count", (SettingValueParser)SettingValueParsers.INT, (Object)Math.min(Runtime.getRuntime().availableProcessors(), 500)).addConstraint(SettingConstraints.range((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(44738))).build();
    @Description(value="If execution time limiting is enabled in the database, this configures the maximum request execution time. Please use db.transaction.timeout instead.")
    @Internal
    @Deprecated
    public static final Setting<Duration> webserver_limit_execution_time = SettingImpl.newBuilder((String)"internal.dbms.executiontime_limit.time", (SettingValueParser)SettingValueParsers.DURATION, null).build();
    private static final SettingValueParser<ThirdPartyJaxRsPackage> MOUNT_POINTS = new SettingValueParser<ThirdPartyJaxRsPackage>(){

        public ThirdPartyJaxRsPackage parse(String packageAndMountpoint) {
            String[] parts = packageAndMountpoint.split("=");
            if (parts.length != 2) {
                throw new IllegalArgumentException("config for " + third_party_packages.name() + " is wrong: " + packageAndMountpoint);
            }
            String pkg = parts[0];
            String mountPoint = parts[1];
            return new ThirdPartyJaxRsPackage(pkg, mountPoint);
        }

        public String getDescription() {
            return "<classname>=<mount point> string";
        }

        public Class<ThirdPartyJaxRsPackage> getType() {
            return ThirdPartyJaxRsPackage.class;
        }
    };
    @Description(value="Comma-separated list of <classname>=<mount point> for unmanaged extensions.")
    public static final Setting<List<ThirdPartyJaxRsPackage>> third_party_packages = SettingImpl.newBuilder((String)"server.unmanaged_extension_classes", (SettingValueParser)SettingValueParsers.listOf(MOUNT_POINTS), Collections.emptyList()).build();
    @Description(value="Value of the Access-Control-Allow-Origin header sent over any HTTP or HTTPS connector. This defaults to '*', which allows broadest compatibility. Note that any URI provided here limits HTTP/HTTPS access to that URI only.")
    public static final Setting<String> http_access_control_allow_origin = SettingImpl.newBuilder((String)"dbms.security.http_access_control_allow_origin", (SettingValueParser)SettingValueParsers.STRING, (Object)"*").build();
    @Description(value="Enable HTTP request logging.")
    public static final Setting<Boolean> http_logging_enabled = SettingImpl.newBuilder((String)"dbms.logs.http.enabled", (SettingValueParser)SettingValueParsers.BOOL, (Object)false).build();
    @Description(value="Value of the HTTP Strict-Transport-Security (HSTS) response header. This header tells browsers that a webpage should only be accessed using HTTPS instead of HTTP. It is attached to every HTTPS response. Setting is not set by default so 'Strict-Transport-Security' header is not sent. Value is expected to contain directives like 'max-age', 'includeSubDomains' and 'preload'.")
    public static final Setting<String> http_strict_transport_security = SettingImpl.newBuilder((String)"dbms.security.http_strict_transport_security", (SettingValueParser)SettingValueParsers.STRING, null).build();
    @Description(value="Defines the Content-Security-Policy header to return to content returned on static endpoints.")
    public static final Setting<String> http_static_content_security_policy = SettingImpl.newBuilder((String)"dbms.security.http_static_content_security_policy_header", (SettingValueParser)SettingValueParsers.STRING, (Object)"default-src 'self'; script-src 'self' cdn.segment.com canny.io; img-src 'self' guides.neo4j.com data:; style-src 'self' fonts.googleapis.com 'unsafe-inline'; font-src 'self' fonts.gstatic.com; base-uri 'none'; object-src 'none'; frame-ancestors 'none'; connect-src 'self' api.canny.io api.segment.io ws: wss: http: https:").build();
    @Description(value="Defines an allowlist of http paths where Neo4j authentication is not required.")
    public static final Setting<List<String>> http_auth_allowlist = SettingImpl.newBuilder((String)"dbms.security.http_auth_allowlist", (SettingValueParser)SettingValueParsers.listOf((SettingValueParser)SettingValueParsers.STRING), List.of("/", "/browser.*")).build();
    @Internal
    @Description(value="Defines a blacklist of http paths that should not be accessed.")
    public static final Setting<List<String>> http_paths_blacklist = SettingImpl.newBuilder((String)"internal.dbms.http_paths_blacklist", (SettingValueParser)SettingValueParsers.listOf((SettingValueParser)SettingValueParsers.STRING), Collections.emptyList()).build();
    @Description(value="Defines the set of modules loaded into the Neo4j web server. The enterprise management endpoints are only available in the \u0415nterprise edition.")
    public static final Setting<Set<ConfigurableServerModules>> http_enabled_modules = SettingImpl.newBuilder((String)"server.http_enabled_modules", (SettingValueParser)SettingValueParsers.setOfEnums(ConfigurableServerModules.class), EnumSet.allOf(ConfigurableServerModules.class)).build();
    @Description(value="Defines the set of transports available on the HTTP server.")
    public static final Setting<Set<ConfigurableTransports>> http_enabled_transports = SettingImpl.newBuilder((String)"server.http_enabled_transports", (SettingValueParser)SettingValueParsers.setOfEnums(ConfigurableTransports.class), EnumSet.allOf(ConfigurableTransports.class)).build();
    @Description(value="Timeout for idle transactions in the HTTP Server. Note: this is different from 'db.transaction.timeout' which will timeout the underlying transaction.")
    public static final Setting<Duration> http_transaction_timeout = SettingImpl.newBuilder((String)"server.http.transaction_idle_timeout", (SettingValueParser)SettingValueParsers.DURATION, (Object)Duration.ofSeconds(30L)).build();
    @Description(value="Timeout for idle transactions in the Query API. Note: this is different from 'db.transaction.timeout' which will timeout the underlying transaction.")
    public static final Setting<Duration> queryapi_transaction_timeout = SettingImpl.newBuilder((String)"server.queryapi.transaction_idle_timeout", (SettingValueParser)SettingValueParsers.DURATION, (Object)Duration.ofSeconds(60L)).build();
    @Internal
    @Description(value="The length of the transaction identifier to use in the Query API")
    public static final Setting<Integer> transaction_id_length = SettingImpl.newBuilder((String)"internal.server.queryapi.transactionid_length", (SettingValueParser)SettingValueParsers.INT, (Object)4).build();
    @Internal
    @Description(value="Publicly discoverable bolt:// URI to use for Neo4j Drivers wanting to access the data in this particular database instance. Normally this is the same as the advertised address configured for the connector, but this allows manually overriding that default. Defaults to a bolt://-schemed version of the advertised address of the first found bolt connector.")
    public static final Setting<URI> bolt_discoverable_address = SettingImpl.newBuilder((String)"internal.dbms.discoverable_bolt_address", (SettingValueParser)SettingValueParsers.URI, (Object)((URI)SettingValueParsers.URI.parse(""))).build();
    @Internal
    @Description(value="Publicly discoverable neo4j:// URI to use for Neo4j Drivers wanting to access a cluster or a single instance. Defaults to empty on any deployment that is not a cluster core, and a neo4j://-schemed URI of the advertised address of the bolt connector.")
    public static final Setting<URI> bolt_routing_discoverable_address = SettingImpl.newBuilder((String)"internal.dbms.discoverable_bolt_routing_address", (SettingValueParser)SettingValueParsers.URI, (Object)((URI)SettingValueParsers.URI.parse(""))).build();
    @Description(value="Commands to be run when Neo4j Browser successfully connects to this server. Separate multiple commands with semi-colon.")
    public static final Setting<String> browser_post_connect_cmd = SettingImpl.newBuilder((String)"browser.post_connect_cmd", (SettingValueParser)SettingValueParsers.STRING, (Object)"").build();
    @Description(value="Whitelist of hosts for the Neo4j Browser to be allowed to fetch content from.")
    public static final Setting<String> browser_remote_content_hostname_whitelist = SettingImpl.newBuilder((String)"browser.remote_content_hostname_whitelist", (SettingValueParser)SettingValueParsers.STRING, (Object)"guides.neo4j.com,localhost").build();
    @Description(value="Configure client applications such as Browser and Bloom to send Product Analytics data.")
    public static final Setting<Boolean> allow_telemetry = SettingImpl.newBuilder((String)"client.allow_telemetry", (SettingValueParser)SettingValueParsers.BOOL, (Object)true).build();
    @Internal
    @Description(value="The legacy manage endpoint. This is kept for back-compatibility purpose.")
    public static final Setting<URI> management_api_path = SettingImpl.newBuilder((String)"internal.dbms.uris.management", (SettingValueParser)SettingValueParsers.NORMALIZED_RELATIVE_URI, (Object)((URI)SettingValueParsers.NORMALIZED_RELATIVE_URI.parse("/db/manage"))).build();
    @Internal
    @Description(value="The start endpoint of database api.")
    public static final Setting<URI> db_api_path = SettingImpl.newBuilder((String)"internal.dbms.uris.db", (SettingValueParser)SettingValueParsers.NORMALIZED_RELATIVE_URI, (Object)((URI)SettingValueParsers.NORMALIZED_RELATIVE_URI.parse("/db"))).build();
    @Internal
    @Description(value="The start endpoint of the dbms api.")
    public static final Setting<URI> dbms_api_path = SettingImpl.newBuilder((String)"internal.dbms.uris.dbms", (SettingValueParser)SettingValueParsers.NORMALIZED_RELATIVE_URI, (Object)((URI)SettingValueParsers.NORMALIZED_RELATIVE_URI.parse("/dbms"))).build();
    @Internal
    @Description(value="URI to the browser home page")
    public static final Setting<URI> browser_path = SettingImpl.newBuilder((String)"internal.dbms.uris.browser", (SettingValueParser)SettingValueParsers.URI, (Object)((URI)SettingValueParsers.URI.parse("/browser/"))).build();
    @Internal
    @Description(value="Toggle WADL generation. Matching the underlying jersey server config")
    public static final Setting<Boolean> wadl_enabled = SettingImpl.newBuilder((String)"internal.dbms.wadl_generation_enabled", (SettingValueParser)SettingValueParsers.BOOL, (Object)false).build();
    @Internal
    @Description(value="Enable Clacks module")
    public static final Setting<Boolean> clacks_enabled = SettingImpl.newBuilder((String)"internal.dbms.clacks_enabled", (SettingValueParser)SettingValueParsers.BOOL, (Object)false).build();
    @Internal
    @Description(value="Clacks module names")
    public static final Setting<String> clacks_names = SettingImpl.newBuilder((String)"internal.dbms.clacks_names", (SettingValueParser)SettingValueParsers.STRING, (Object)"Richard Macaskill").build();
}

