/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.format.jolt.v2;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.server.http.cypher.format.jolt.Sigil;

final class JoltNodeSerializerV2
extends StdSerializer<Node> {
    JoltNodeSerializerV2() {
        super(Node.class);
    }

    public void serialize(Node node, JsonGenerator generator, SerializerProvider provider) throws IOException {
        generator.writeStartObject((Object)node);
        generator.writeFieldName(Sigil.NODE.getValue());
        generator.writeStartArray();
        generator.writeString(node.getElementId());
        generator.writeStartArray();
        for (Label label : node.getLabels()) {
            generator.writeString(label.name());
        }
        generator.writeEndArray();
        Map properties = Optional.ofNullable(node.getAllProperties()).orElseGet(Collections::emptyMap);
        generator.writeStartObject();
        for (Map.Entry entry : properties.entrySet()) {
            generator.writeFieldName((String)entry.getKey());
            generator.writeObject(entry.getValue());
        }
        generator.writeEndObject();
        generator.writeEndArray();
        generator.writeEndObject();
    }
}

