/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.logging;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;

public class JULBridge
extends Handler {
    private static final String UNKNOWN_LOGGER_NAME = "unknown";
    private final InternalLogProvider logProvider;
    private final ConcurrentMap<String, InternalLog> logs = new ConcurrentHashMap<String, InternalLog>();

    protected JULBridge(InternalLogProvider logProvider) {
        this.logProvider = logProvider;
    }

    public static void resetJUL() {
        LogManager.getLogManager().reset();
    }

    public static void forwardTo(InternalLogProvider logProvider) {
        JULBridge.rootJULLogger().addHandler(new JULBridge(logProvider));
    }

    private static Logger rootJULLogger() {
        return LogManager.getLogManager().getLogger("");
    }

    @Override
    public void publish(LogRecord record) {
        if (record == null) {
            return;
        }
        String message = JULBridge.getMessage(record);
        if (message == null) {
            return;
        }
        String context = record.getLoggerName();
        InternalLog log = this.getLog(context != null ? context : UNKNOWN_LOGGER_NAME);
        JULBridge.log(log, record.getLevel().intValue(), message, record.getThrown());
    }

    private static void log(InternalLog log, int level, String message, Throwable throwable) {
        if (level <= Level.FINE.intValue()) {
            if (throwable == null) {
                log.debug(message);
            } else {
                log.debug(message, throwable);
            }
        } else if (level <= Level.INFO.intValue()) {
            if (throwable == null) {
                log.info(message);
            } else {
                log.info(message, throwable);
            }
        } else if (level <= Level.WARNING.intValue()) {
            if (throwable == null) {
                log.warn(message);
            } else {
                log.warn(message, throwable);
            }
        } else if (throwable == null) {
            log.error(message);
        } else {
            log.error(message, throwable);
        }
    }

    private InternalLog getLog(String name) {
        InternalLog newLog;
        InternalLog log = (InternalLog)this.logs.get(name);
        if (log == null && (log = this.logs.putIfAbsent(name, newLog = this.logProvider.getLog(name))) == null) {
            log = newLog;
        }
        return log;
    }

    private static String getMessage(LogRecord record) {
        Object[] params;
        String message = record.getMessage();
        if (message == null) {
            return null;
        }
        ResourceBundle bundle = record.getResourceBundle();
        if (bundle != null) {
            try {
                message = bundle.getString(message);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if ((params = record.getParameters()) != null && params.length > 0) {
            message = MessageFormat.format(message, params);
        }
        return message;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }
}

