/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.consumer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.util.DefaultValueMapper;
import org.neo4j.server.http.cypher.CachingWriter;
import org.neo4j.server.http.cypher.OutputEventStream;
import org.neo4j.server.http.cypher.TransactionIndependentValueMapper;
import org.neo4j.server.http.cypher.consumer.OutputEventStreamRecordHandler;
import org.neo4j.values.AnyValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.PathValue;
import org.neo4j.values.virtual.RelationshipValue;

class OutputEventStreamRecordHandlerTest {
    private CachingWriter cachingWriter;
    private OutputEventStream outputEventStream;
    private TransactionIndependentValueMapper transactionIndependentValueMapper;
    private OutputEventStreamRecordHandler subject;
    private Map<String, Object> results;

    OutputEventStreamRecordHandlerTest() {
    }

    @BeforeEach
    void setup() {
        this.outputEventStream = (OutputEventStream)Mockito.mock(OutputEventStream.class);
        this.cachingWriter = new CachingWriter((ValueMapper)new DefaultValueMapper(null));
        this.transactionIndependentValueMapper = (TransactionIndependentValueMapper)Mockito.spy((Object)new TransactionIndependentValueMapper(this.cachingWriter));
        this.results = new HashMap<String, Object>();
    }

    private void prepareSubject(List<String> fieldNames) {
        this.subject = new OutputEventStreamRecordHandler(fieldNames, this.outputEventStream, this.transactionIndependentValueMapper, () -> this.results);
    }

    @ParameterizedTest
    @MethodSource(value={"recordConsumptionValues"})
    void beginRecord_consumeFiled_endRecord_shouldWriteRecordsToTheOutputStream(List<String> fieldNames, List<AnyValue> fields) throws Exception {
        ArgumentCaptor supplierCaptor = ArgumentCaptor.forClass(Function.class);
        this.prepareSubject(fieldNames);
        this.subject.onBegin();
        fields.forEach(field -> this.subject.onField(field));
        this.subject.onCompleted();
        ((OutputEventStream)Mockito.verify((Object)this.outputEventStream)).writeRecord((List)ArgumentMatchers.eq(fieldNames), (Function)supplierCaptor.capture());
        List values = supplierCaptor.getAllValues();
        Assertions.assertEquals((int)1, (int)values.size());
        Function supplier = (Function)values.get(0);
        fieldNames.forEach(fieldName -> Assertions.assertEquals((Object)this.results.get(fieldName), supplier.apply(fieldName)));
    }

    private static Stream<Arguments> recordConsumptionValues() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{List.of("one"), List.of(Values.intValue((int)134))}), Arguments.arguments((Object[])new Object[]{List.of("one", "two", "three"), List.of(Values.intValue((int)134), Values.booleanArray((boolean[])new boolean[]{true, false}), Values.charValue((char)'2'))}), Arguments.arguments((Object[])new Object[]{List.of("node"), List.of((NodeValue)Mockito.mock(NodeValue.class))}), Arguments.arguments((Object[])new Object[]{List.of("relationship"), List.of((RelationshipValue)Mockito.mock(RelationshipValue.class))}), Arguments.arguments((Object[])new Object[]{List.of("path"), List.of((PathValue)Mockito.mock(PathValue.class))}));
    }
}

