/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.struct;

import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.function.Consumer;
import org.neo4j.bolt.testing.assertions.BoltConnectionAssertions;
import org.neo4j.bolt.testing.client.BoltTestConnection;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.struct.StructHeader;

public abstract class AbstractStructArgumentIT {
    protected void testFailureWithUnpackableValueV40(BoltTestConnection connection, Consumer<PackstreamBuf> packer, String expectedMessage) {
        connection.send(this.createRunWith(packer));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureV40((Status)Status.Request.Invalid, expectedMessage);
    }

    protected void testFailureWithUnpackableValue(BoltTestConnection connection, Consumer<PackstreamBuf> packer, String expectedMessage) {
        connection.send(this.createRunWith(packer));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailure((Status)Status.Request.Invalid, expectedMessage, GqlStatusInfoCodes.STATUS_08N06.getGqlStatus(), "error: connection exception - protocol error. General network protocol error.");
    }

    protected void testFailureWithUnpackableValue(BoltTestConnection connection, Consumer<PackstreamBuf> packer, String expectedMessage, Consumer<Map<String, Object>> causeAssertion) {
        connection.send(this.createRunWith(packer));
        BoltConnectionAssertions.assertThat((BoltTestConnection)connection).receivesFailureWithCause((Status)Status.Request.Invalid, expectedMessage, GqlStatusInfoCodes.STATUS_08N06.getGqlStatus(), "error: connection exception - protocol error. General network protocol error.", BoltConnectionAssertions.assertErrorClassificationOnDiagnosticRecord((String)"CLIENT_ERROR"), causeAssertion);
    }

    protected ByteBuf createRunWith(Consumer<PackstreamBuf> packer) {
        PackstreamBuf buf = PackstreamBuf.allocUnpooled().writeStructHeader(new StructHeader(3L, 16)).writeString("RETURN $x").writeMapHeader(1L).writeString("x");
        packer.accept(buf);
        return buf.writeMapHeader(0L).getTarget();
    }
}

